# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Compatibility module to use the KDE Color Dialog instead of the Qt Color Dialog.
"""

try:
    import os
    if os.getenv("e3nokde"):
        raise ImportError
        
    from kdeui import KColorDialog
    from qt import Qt, QColor
    
    def getColor(initial = Qt.white, parent = None, name = None):
        """
        Public function to pop up a modal dialog to select a color.
        
        @param initial initial color to select (QColor)
        @param parent parent widget of the dialog (QWidget)
        @param name name of the dialog (ignored)
        @return the selected color or the invalid color, if the
            canceled the dialog (QColor)
        """
        col = QColor(initial)
        res = KColorDialog.getColor(col, parent)
        if res == KColorDialog.Accepted:
            return col
        else:
            return QColor()
    
except (ImportError, RuntimeError):
    import qt
    getColor = qt.QColorDialog.getColor
