/*!

\if MANPAGES
\page dcmpsprt Read DICOM images and presentation states and render print job
\else
\page dcmpsprt dcmpsprt: Read DICOM images and presentation states and render print job
\endif

\section synopsis SYNOPSIS

\verbatim
dcmpsprt [options] [imagefile_in...]
\endverbatim

\section description DESCRIPTION

The \b dcmpsprt utility reads one or more DICOM images and presentation states
and creates a print job.  The print job consists of one Stored Print object
and one or more Hardcopy Grayscale images and is written to the database
specified in the configuration file.  The print job can optionally be
spooled to the printer.  In this case, \b dcmpsprt calls the \b dcmprtsv
application which performs communication with the printer.

\section parameters PARAMETERS

\verbatim
imagefile_in  DICOM image file(s) to be printed
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h   --help
         print this help text and exit

       --version
         print version information and exit

  -v   --verbose
         verbose mode, print actions

  -d   --debug
         debug mode, print debug information
\endverbatim

\subsection processing_options processing options
\verbatim
  +p   --pstate  [p]state-file: string
         render the following image with pres. state p

  -c   --config  [f]ilename: string
         process using settings from configuration file f

  -p   --printer  [n]ame: string (default: 1st printer in cfg file)
         select printer with identifier n from cfg file
\endverbatim

\subsection spooling_options spooling options
\verbatim
  -s   --spool
         spool print job to DICOM printer

       --nospool
         do not spool print job to DICOM printer (default)
\endverbatim

\subsection film_orientation_options film orientation options
\verbatim
       --portrait
         set portrait orientation

       --landscape
         set landscape orientation

       --default-orientation
         use printer default (default)
\endverbatim

\subsection trim_border_options trim (border) options
\verbatim
       --trim
         set trim on

       --no-trim
         set trim off

       --default-trim
         use printer default (default)
\endverbatim

\subsection behaviour_options requested decimate/crop behaviour options
\verbatim
       --request-decimate
         request decimate

       --request-crop
         request crop

       --request-fail
         request failure

       --default-request
         use printer default (default)
\endverbatim

\subsection print_presentation_LUT_options print presentation LUT options
\verbatim
       --default-plut
         do not create presentation LUT (default)

       --identity
         set IDENTITY presentation LUT shape

       --plut  [l]ut identifier: string
         add LUT l to print job

       --inverse-plut
         render the inverse presentation LUT into the
         bitmap of the hardcopy grayscale image

       --illumination  [v]alue: integer (0..65535)
         set illumination to v (in cd/m^2)

       --reflection  [v]alue: integer (0..65535)
         set reflected ambient light to v (in cd/m^2)
\endverbatim

\subsection film_options basic film session options (only with --spool)
\verbatim
       --copies  [v]alue: integer (1..100, default: 1)
         set number of copies to v

       --medium-type  [v]alue: string
         set medium type to v

       --destination  [v]alue: string
         set film destination to v

       --label  [v]alue: string
         set film session label to v

       --priority  [v]alue: string
         set print priority to v

       --owner  [v]alue: string
         set film session owner ID to v
\endverbatim

\subsection annotation_options annotation options
\verbatim
       --no-annotation
         do not create annotation (default)

  -a   --annotation  [t]ext: string
         create annotation with text [t]

  +pd  --print-date
         prepend date/time to annotation (default)

  -pd  --print-no-date
         do not prepend date/time to annotation

  +pn  --print-name
         prepend printer name to annotation (default)

  -pn  --print-no-name
         do not prepend printer name to annotation

  +pl  --print-lighting
         prepend illumination to annotation (default)

  -pl  --print-no-lighting
         do not prepend illumination to annotation
\endverbatim

\subsection overlay_options overlay options
\verbatim
  +O   --overlay  [f]ilename : string, [x] [y] : integer
         load overlay data from PBM file f and display at position (x,y)

  +Og  --ovl-graylevel  [v]alue: integer (0..4095)
         use overlay gray level v (default: 4095 = white)
\endverbatim

\subsection other_print_options
\verbatim
  -l   --layout  [c]olumns [r]ows: integer (default: 1 1)
         use 'STANDARD\c,r' image display format

       --filmsize  [v]alue: string
         set film size ID to v

       --magnification  [v]alue: string
         set magnification type to v

       --smoothing  [v]alue: string
         set smoothing type to v

       --configinfo  [v]alue: string
         set configuration information to v

       --resolution  [v]alue: string
         set requested resolution ID to v

       --border  [v]alue: string
         set border density to v

       --empty-image  [v]alue: string
         set empty image density to v

       --max-density  [v]alue: string
         set max density to v

       --min-density  [v]alue: string
         set min density to v

       --img-polarity  [v]alue: string
         set image box polarity to v (NORMAL or REVERSE)

       --img-request-size  [v]alue: string
         set requested image size to v (width in mm)

       --img-magnification  [v]alue: string
         set image box magnification type to v

       --img-smoothing  [v]alue: string
         set image box smoothing type to v

       --img-configinfo  [v]alue: string
         set image box configuration information to v
\endverbatim

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator) prior to any further
evaluation.  Please note that a command file cannot contain another command
file.  This simple but effective approach allows to summarize common
combinations of options/parameters and avoids longish and confusing command
lines (an example is provided in file <em>share/data/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b dcmpsprt utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<PREFIX\>/lib/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  The data dictionary
code will attempt to load each file specified in the \e DCMDICTPATH
environment variable.  It is an error if no data dictionary can be loaded.

\section files FILES

<em>etc/dcmpstat.cfg</em>, <em>etc/printers.cfg</em> - sample configuration files

\section see_also SEE ALSO

<b>dcmprtsv</b>(1)

\section copyright COPYRIGHT

Copyright (C) 1999-2004 by Kuratorium OFFIS e.V., Escherweg 2, 26121 Oldenburg,
Germany.

*/