/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.util;

import java.io.*;
/**
 *
 */
public class JoinStream
    extends InputStream
{
    protected InputStream [] instreams;
    protected InputStream currentStream;
    protected int currentIndex = -1;
    /**
     * creates a new JoinStream
     */
    public
    JoinStream (
        InputStream [] instreams)
    {
        this.instreams = instreams;
        this.nextStream ();
    }
    /**
     *
     */
    protected void
    nextStream ()
    {
        ++this.currentIndex;
        if (this.currentIndex >= this.instreams.length) {
            this.currentStream = null;
        }
        else {
            this.currentStream = this.instreams [this.currentIndex];
        }
    }
    /**
     *
     * @return int
     * @param b byte[]
     * @param off int
     * @param len int
     * @exception StreamIOException
     */
    public int
    read(
        byte b[],
        int off,
        int len)
    throws IOException
    {
        int result = 0;
        int chunkLen;

        while ((this.currentStream != null) && (len > 0)) {
            chunkLen = this.currentStream.read (b, off, len);
            if (chunkLen == -1) {
                this.nextStream ();
            }
            else {
                off += chunkLen;
                len -= chunkLen;
                result += chunkLen;
            }
        }
        if ((result == 0) && (this.currentStream == null)) {
            result = -1;
        }
        return result;
    }
    /**
     * read method comment.
     */
    public int
    read()
    throws IOException
    {
        int result = 0;
        while (this.currentStream != null) {
            result = this.currentStream.read ();
            if (result == -1) {
                this.nextStream ();
            }
        }
        if (this.currentStream == null) {
            result = -1;
        }
        return result;
    }
    /**
     * Closes this input stream and releases any system resources associated
     * with the stream.
     *
     * <p> The <code>close</code> method of <code>InputStream</code> does
     * nothing.
     *
     * @exception  IOException  if an I/O error occurs.
     */
    public void
    close()
    throws IOException
    {
        for (int i = this.currentIndex; i < this.instreams.length; ++i) {
            try {
                if (this.instreams [i] != null) {
                    this.instreams [i].close ();
                }
            }
            catch (IOException exc) {
                // ignore
            }
        }
    }
    /**
     * Tests if this input stream supports the <code>mark</code> and
     * <code>reset</code> methods. The <code>markSupported</code> method of
     * <code>InputStream</code> returns <code>false</code>.
     *
     * @return  <code>true</code> if this true type supports the mark and reset
     *          method; <code>false</code> otherwise.
     * @see     java.io.InputStream#mark(int)
     * @see     java.io.InputStream#reset()
     */
    public boolean
    markSupported()
    {
        return false;
    }

}
