/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.procserver;

import com.sap.dbtech.procserver.Log;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;

public class SocketComm
extends JdbcCommunication {
    private Socket socket;
    private InputStream instream;
    private OutputStream outstream;
    private StructuredMem sendBuf;
    int packetSize;

    public SocketComm(int n, int n2) throws RTEException {
        try {
            this.socket = new Socket("localhost", n);
            this.instream = this.socket.getInputStream();
            this.outstream = this.socket.getOutputStream();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RTEException(unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            throw new RTEException(iOException.getMessage());
        }
        this.packetSize = n2;
    }

    void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    public void finalize() {
        this.close();
    }

    void send(byte[] byArray, int n) throws IOException {
        byte[] byArray2 = new byte[4];
        Log.log("send'ing " + n + " bytes");
        if (n == 0) {
            byArray2[3] = 0;
            byArray2[2] = 0;
            byArray2[1] = 0;
            byArray2[0] = 0;
            return;
        }
        int n2 = 3;
        while (n2 >= 0) {
            byArray2[n2] = (byte)(n & 0xFF);
            n >>= 8;
            --n2;
        }
        this.outstream.write(byArray2);
        this.outstream.write(byArray);
    }

    void send(byte[] byArray) throws IOException {
        this.send(byArray, byArray.length);
    }

    void sendString(String string) throws IOException {
        this.send(string.getBytes());
    }

    public byte[] recv() throws IOException {
        byte[] byArray = this.recvBytes(4);
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = byArray[n2];
            if (n3 < 0) {
                n3 += 256;
            }
            n = n * 256 + n3;
            ++n2;
        }
        byte[] byArray2 = this.recvBytes(n);
        return byArray2;
    }

    public String recvString() throws IOException {
        byte[] byArray = this.recv();
        return new String(byArray);
    }

    private byte[] recvBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            n2 += this.instream.read(byArray, n2, n - n2);
        }
        return byArray;
    }

    public void cancel() throws SQLException {
    }

    public StructuredMem getRequestPacket() {
        StructuredMem structuredMem;
        if (this.sendBuf != null) {
            structuredMem = this.sendBuf;
            this.sendBuf = null;
        } else {
            structuredMem = new StructuredBytes(this.packetSize);
        }
        return structuredMem;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public StructuredMem receive() throws RTEException {
        try {
            return new StructuredBytes(this.recv());
        }
        catch (IOException iOException) {
            throw new RTEException(iOException.getMessage());
        }
    }

    public void release() {
        this.close();
    }

    public void request(StructuredMem structuredMem, int n) throws RTEException {
        this.sendBuf = structuredMem;
        StructuredBytes structuredBytes = (StructuredBytes)structuredMem;
        try {
            this.send(structuredBytes.bytes(), n);
        }
        catch (IOException iOException) {
            throw new RTEException(iOException.getMessage());
        }
    }
}

