/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.babelfish;

import java.io.File;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.babelfish.TranslationCache;
import oracle.jdbc.babelfish.Translator;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.SQL_TRANSLATION})
public class TranslationManager {
    private static final ConcurrentHashMap<String, TranslationCache> translationCacheRegistry;
    private static Map<String, String> defaultErrorFile;
    private static final String SEPARATOR = "\u0000";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    public TranslationManager() {
        boolean bl = (0x10000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TranslationManager.class, $$$methodRef$$$1, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TranslationManager.class, $$$methodRef$$$1, null);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TranslationManager.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TranslationManager.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Translator getTranslator(String string, String string2, String string3, String string4) throws SQLException {
        boolean bl = (0x10000L & TraceControllerImpl.feature) != 0L;
        try {
            Translator trnsltr;
            void user;
            String connectionURL;
            void translationProfile;
            String localErrorTranslationFilePath;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TranslationManager.class, $$$methodRef$$$0, null, string, string2, string3, string4);
            }
            if (localErrorTranslationFilePath == null && defaultErrorFile.containsKey(translationProfile)) {
                localErrorTranslationFilePath = defaultErrorFile.get(translationProfile);
            }
            File localErrorTranslationFile = null;
            if (localErrorTranslationFilePath != null && !(localErrorTranslationFile = new File(localErrorTranslationFilePath)).exists()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(277).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, TranslationManager.class, $$$methodRef$$$0, null, sQLException);
                }
                throw sQLException;
            }
            if (!$assertionsDisabled && (".*\u0000.*".matches(connectionURL) || ".*\u0000.*".matches((String)user) || ".*\u0000.*".matches((String)translationProfile))) {
                AssertionError assertionError = new AssertionError();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, TranslationManager.class, $$$methodRef$$$0, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            String key = connectionURL + SEPARATOR + (String)user + SEPARATOR + (String)translationProfile;
            TranslationCache trnscache = translationCacheRegistry.get(key);
            if (trnscache == null) {
                trnscache = new TranslationCache(localErrorTranslationFile);
                translationCacheRegistry.putIfAbsent(key, trnscache);
            }
            Translator translator = trnsltr = new Translator((String)translationProfile, localErrorTranslationFile, trnscache);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TranslationManager.class, $$$methodRef$$$0, null, translator);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TranslationManager.class, $$$methodRef$$$0, null, null);
            }
            return translator;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TranslationManager.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$1 = TranslationManager.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TranslationManager.class.getDeclaredMethod("getTranslator", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        translationCacheRegistry = new ConcurrentHashMap();
        defaultErrorFile = new ConcurrentHashMap<String, String>();
    }
}

