# This file has been autogenerated by the pywayland scanner

# Copyright 2019 Sebastian Wick
# Copyright 2019 Erwin Burema
# Copyright 2020 AMD
# Copyright 2020-2024 Collabora, Ltd.
# Copyright 2024 Xaver Hugl
# Copyright 2022-2025 Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class WpImageDescriptionInfoV1(Interface):
    """Colorimetric image description information

    Sends all matching events describing an image description object exactly
    once and finally sends the 'done' event.

    This means - if the image description is parametric, it must send   -
    primaries   - named_primaries, if applicable   - at least one of tf_power
    and tf_named, as applicable   - luminances   - target_primaries   -
    target_luminance - if the image description is parametric, it may send, if
    applicable,   - target_max_cll   - target_max_fall - if the image
    description contains an ICC profile, it must send the   icc_file event

    Once a :class:`WpImageDescriptionInfoV1` object has delivered a 'done'
    event it is automatically destroyed.

    Every :class:`WpImageDescriptionInfoV1` created from the same
    :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionV1` shall
    always return the exact same data.
    """

    name = "wp_image_description_info_v1"
    version = 2


class WpImageDescriptionInfoV1Proxy(Proxy[WpImageDescriptionInfoV1]):
    interface = WpImageDescriptionInfoV1


class WpImageDescriptionInfoV1Resource(Resource):
    interface = WpImageDescriptionInfoV1

    @WpImageDescriptionInfoV1.event()
    def done(self) -> None:
        """End of information

        Signals the end of information events and destroys the object.
        """
        self._post_event(0)

    @WpImageDescriptionInfoV1.event(
        Argument(ArgumentType.FileDescriptor),
        Argument(ArgumentType.Uint),
    )
    def icc_file(self, icc: int, icc_size: int) -> None:
        """Icc profile matching the image description

        The icc argument provides a file descriptor to the client which may be
        memory-mapped to provide the ICC profile matching the image
        description. The fd is read-only, and if mapped then it must be mapped
        with MAP_PRIVATE by the client.

        The ICC profile version and other details are determined by the
        compositor. There is no provision for a client to ask for a specific
        kind of a profile.

        :param icc:
            ICC profile file descriptor
        :type icc:
            `ArgumentType.FileDescriptor`
        :param icc_size:
            ICC profile size, in bytes
        :type icc_size:
            `ArgumentType.Uint`
        """
        self._post_event(1, icc, icc_size)

    @WpImageDescriptionInfoV1.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def primaries(self, r_x: int, r_y: int, g_x: int, g_y: int, b_x: int, b_y: int, w_x: int, w_y: int) -> None:
        """Primaries as chromaticity coordinates

        Delivers the primary color volume primaries and white point using CIE
        1931 xy chromaticity coordinates.

        Each coordinate value is multiplied by 1 million to get the argument
        value to carry precision of 6 decimals.

        :param r_x:
            Red x * 1M
        :type r_x:
            `ArgumentType.Int`
        :param r_y:
            Red y * 1M
        :type r_y:
            `ArgumentType.Int`
        :param g_x:
            Green x * 1M
        :type g_x:
            `ArgumentType.Int`
        :param g_y:
            Green y * 1M
        :type g_y:
            `ArgumentType.Int`
        :param b_x:
            Blue x * 1M
        :type b_x:
            `ArgumentType.Int`
        :param b_y:
            Blue y * 1M
        :type b_y:
            `ArgumentType.Int`
        :param w_x:
            White x * 1M
        :type w_x:
            `ArgumentType.Int`
        :param w_y:
            White y * 1M
        :type w_y:
            `ArgumentType.Int`
        """
        self._post_event(2, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y)

    @WpImageDescriptionInfoV1.event(
        Argument(ArgumentType.Uint),
    )
    def primaries_named(self, primaries: int) -> None:
        """Named primaries

        Delivers the primary color volume primaries and white point using an
        explicitly enumerated named set.

        :param primaries:
            named primaries
        :type primaries:
            `ArgumentType.Uint`
        """
        self._post_event(3, primaries)

    @WpImageDescriptionInfoV1.event(
        Argument(ArgumentType.Uint),
    )
    def tf_power(self, eexp: int) -> None:
        """Transfer characteristic as a power curve

        The color component transfer characteristic of this image description
        is a pure power curve. This event provides the exponent of the power
        function. This curve represents the conversion from electrical to
        optical pixel or color values.

        The curve exponent has been multiplied by 10000 to get the argument
        eexp value to carry the precision of 4 decimals.

        :param eexp:
            the exponent * 10000
        :type eexp:
            `ArgumentType.Uint`
        """
        self._post_event(4, eexp)

    @WpImageDescriptionInfoV1.event(
        Argument(ArgumentType.Uint),
    )
    def tf_named(self, tf: int) -> None:
        """Named transfer characteristic

        Delivers the transfer characteristic using an explicitly enumerated
        named function.

        :param tf:
            named transfer function
        :type tf:
            `ArgumentType.Uint`
        """
        self._post_event(5, tf)

    @WpImageDescriptionInfoV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def luminances(self, min_lum: int, max_lum: int, reference_lum: int) -> None:
        """Primary color volume luminance range and reference white

        Delivers the primary color volume luminance range and the reference
        white luminance level. These values include the minimum display
        emission and ambient flare luminances, assumed to be optically additive
        and have the chromaticity of the primary color volume white point.

        The minimum luminance is multiplied by 10000 to get the argument
        'min_lum' value and carries precision of 4 decimals. The maximum
        luminance and reference white luminance values are unscaled.

        :param min_lum:
            minimum luminance (cd/m²) * 10000
        :type min_lum:
            `ArgumentType.Uint`
        :param max_lum:
            maximum luminance (cd/m²)
        :type max_lum:
            `ArgumentType.Uint`
        :param reference_lum:
            reference white luminance (cd/m²)
        :type reference_lum:
            `ArgumentType.Uint`
        """
        self._post_event(6, min_lum, max_lum, reference_lum)

    @WpImageDescriptionInfoV1.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def target_primaries(self, r_x: int, r_y: int, g_x: int, g_y: int, b_x: int, b_y: int, w_x: int, w_y: int) -> None:
        """Target primaries as chromaticity coordinates

        Provides the color primaries and white point of the target color volume
        using CIE 1931 xy chromaticity coordinates. This is compatible with the
        SMPTE ST 2086 definition of HDR static metadata for mastering displays.

        While primary color volume is about how color is encoded, the target
        color volume is the actually displayable color volume. If target color
        volume is equal to the primary color volume, then this event is not
        sent.

        Each coordinate value is multiplied by 1 million to get the argument
        value to carry precision of 6 decimals.

        :param r_x:
            Red x * 1M
        :type r_x:
            `ArgumentType.Int`
        :param r_y:
            Red y * 1M
        :type r_y:
            `ArgumentType.Int`
        :param g_x:
            Green x * 1M
        :type g_x:
            `ArgumentType.Int`
        :param g_y:
            Green y * 1M
        :type g_y:
            `ArgumentType.Int`
        :param b_x:
            Blue x * 1M
        :type b_x:
            `ArgumentType.Int`
        :param b_y:
            Blue y * 1M
        :type b_y:
            `ArgumentType.Int`
        :param w_x:
            White x * 1M
        :type w_x:
            `ArgumentType.Int`
        :param w_y:
            White y * 1M
        :type w_y:
            `ArgumentType.Int`
        """
        self._post_event(7, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y)

    @WpImageDescriptionInfoV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def target_luminance(self, min_lum: int, max_lum: int) -> None:
        """Target luminance range

        Provides the luminance range that the image description is targeting as
        the minimum and maximum absolute luminance L. These values include the
        minimum display emission and ambient flare luminances, assumed to be
        optically additive and have the chromaticity of the primary color
        volume white point. This should be compatible with the SMPTE ST 2086
        definition of HDR static metadata.

        This luminance range is only theoretical and may not correspond to the
        luminance of light emitted on an actual display.

        Min L value is multiplied by 10000 to get the argument min_lum value
        and carry precision of 4 decimals. Max L value is unscaled for max_lum.

        :param min_lum:
            min L (cd/m²) * 10000
        :type min_lum:
            `ArgumentType.Uint`
        :param max_lum:
            max L (cd/m²)
        :type max_lum:
            `ArgumentType.Uint`
        """
        self._post_event(8, min_lum, max_lum)

    @WpImageDescriptionInfoV1.event(
        Argument(ArgumentType.Uint),
    )
    def target_max_cll(self, max_cll: int) -> None:
        """Target maximum content light level

        Provides the targeted max_cll of the image description. max_cll is
        defined by CTA-861-H.

        This luminance is only theoretical and may not correspond to the
        luminance of light emitted on an actual display.

        :param max_cll:
            Maximum content light-level (cd/m²)
        :type max_cll:
            `ArgumentType.Uint`
        """
        self._post_event(9, max_cll)

    @WpImageDescriptionInfoV1.event(
        Argument(ArgumentType.Uint),
    )
    def target_max_fall(self, max_fall: int) -> None:
        """Target maximum frame-average light level

        Provides the targeted max_fall of the image description. max_fall is
        defined by CTA-861-H.

        This luminance is only theoretical and may not correspond to the
        luminance of light emitted on an actual display.

        :param max_fall:
            Maximum frame-average light level (cd/m²)
        :type max_fall:
            `ArgumentType.Uint`
        """
        self._post_event(10, max_fall)


class WpImageDescriptionInfoV1Global(Global):
    interface = WpImageDescriptionInfoV1


WpImageDescriptionInfoV1._gen_c()
WpImageDescriptionInfoV1.proxy_class = WpImageDescriptionInfoV1Proxy
WpImageDescriptionInfoV1.resource_class = WpImageDescriptionInfoV1Resource
WpImageDescriptionInfoV1.global_class = WpImageDescriptionInfoV1Global
