/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JrePlatform;
import org.apache.tomcat.util.http.RequestUtil;

public abstract class AbstractFileResourceSet
extends AbstractResourceSet {
    private static final Log log = LogFactory.getLog(AbstractFileResourceSet.class);
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private File fileBase;
    private String absoluteBase;
    private String canonicalBase;
    private boolean readOnly = false;
    private Boolean allowLinking;

    protected AbstractFileResourceSet(String string) {
        this.setInternalPath(string);
    }

    protected final File getFileBase() {
        return this.fileBase;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setAllowLinking(boolean bl) {
        this.allowLinking = bl;
    }

    @Override
    public boolean getAllowLinking() {
        if (this.allowLinking == null) {
            return this.getRoot().getAllowLinking();
        }
        return this.allowLinking;
    }

    protected final File file(String string, boolean bl) {
        if (string.equals("/")) {
            string = "";
        }
        File file = new File(this.fileBase, string);
        if (string.endsWith("/") && file.isFile()) {
            return null;
        }
        if (bl && !file.canRead()) {
            return null;
        }
        if (this.getAllowLinking()) {
            return file;
        }
        if (JrePlatform.IS_WINDOWS && this.isInvalidWindowsFilename(string)) {
            return null;
        }
        String string2 = null;
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string2 == null || !string2.startsWith(this.canonicalBase)) {
            return null;
        }
        String string3 = this.normalize(file.getAbsolutePath());
        if (string3 == null || this.absoluteBase.length() > string3.length()) {
            return null;
        }
        string3 = string3.substring(this.absoluteBase.length());
        if (!(string2 = string2.substring(this.canonicalBase.length())).isEmpty() && string2.charAt(0) != File.separatorChar) {
            return null;
        }
        if (!string2.isEmpty()) {
            string2 = this.normalize(string2);
        }
        if (!string2.equals(string3)) {
            if (!string2.equalsIgnoreCase(string3)) {
                this.logIgnoredSymlink(this.getRoot().getContext().getName(), string3, string2);
            }
            return null;
        }
        return file;
    }

    protected void logIgnoredSymlink(String string, String string2, String string3) {
        if (string2.startsWith("/META-INF/") || string2.startsWith("/WEB-INF/")) {
            log.error((Object)sm.getString("abstractFileResourceSet.canonicalfileCheckFailed", new Object[]{string, string2, string3}));
        } else {
            log.warn((Object)sm.getString("abstractFileResourceSet.canonicalfileCheckFailed", new Object[]{string, string2, string3}));
        }
    }

    private boolean isInvalidWindowsFilename(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c != '\"' && c != '*' && c != ':' && c != '<' && c != '>' && c != '?' && c != '|') continue;
            return true;
        }
        return string.charAt(n - 1) == ' ';
    }

    private String normalize(String string) {
        return RequestUtil.normalize((String)string, (File.separatorChar == '\\' ? 1 : 0) != 0);
    }

    @Override
    public URL getBaseUrl() {
        try {
            return this.getFileBase().toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void gc() {
    }

    @Override
    protected void initInternal() throws LifecycleException {
        this.fileBase = new File(this.getBase(), this.getInternalPath());
        this.checkType(this.fileBase);
        this.absoluteBase = this.normalize(this.fileBase.getAbsolutePath());
        try {
            this.canonicalBase = this.fileBase.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        if ("/".equals(this.absoluteBase)) {
            this.absoluteBase = "";
        }
        if ("/".equals(this.canonicalBase)) {
            this.canonicalBase = "";
        }
    }

    protected abstract void checkType(File var1);
}

