/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CInputStream
extends OracleInputStream {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    T4CInputStream(OracleStatement stmt, int index, Accessor a2) {
        super(stmt, index, a2);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CInputStream.class, $$$methodRef$$$2, null, stmt, index, a2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CInputStream.class, $$$methodRef$$$2, null);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CInputStream.class, $$$methodRef$$$2, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CInputStream.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isNull() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int currentRow;
            boolean result;
            block12: {
                boolean bl2;
                block13: {
                    boolean bl3;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CInputStream.class, $$$methodRef$$$0, this, new Object[0]);
                    }
                    if (!this.statement.isFetchStreams) {
                        boolean bl4 = super.isNull();
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CInputStream.class, $$$methodRef$$$0, this, bl4);
                            ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CInputStream.class, $$$methodRef$$$0, this, null);
                        }
                        return bl4;
                    }
                    result = false;
                    try {
                        currentRow = this.statement.currentResultSet.getRow();
                        if (currentRow < 0) {
                            currentRow = 0;
                        }
                        if ((long)currentRow < this.statement.validRows) break block12;
                        bl2 = bl3 = true;
                        if (!bl) break block13;
                    }
                    catch (SQLException exc) {
                        IOException iOException = (IOException)DatabaseError.createIOException(exc).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4CInputStream.class, $$$methodRef$$$0, this, iOException);
                        }
                        throw iOException;
                    }
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CInputStream.class, $$$methodRef$$$0, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CInputStream.class, $$$methodRef$$$0, this, null);
                }
                return bl2;
            }
            result = this.statement.isNull(currentRow, this.columnIndex);
            boolean bl5 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CInputStream.class, $$$methodRef$$$0, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CInputStream.class, $$$methodRef$$$0, this, null);
            }
            return bl5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CInputStream.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getBytes(int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int n3;
            block26: {
                Monitor.CloseableLock lock;
                block27: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CInputStream.class, $$$methodRef$$$1, this, n2);
                    }
                    lock = this.statement.connection.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        int ret = -1;
                        try {
                            if (this.statement.connection.lifecycle == 1 || this.statement.connection.lifecycle == 2) {
                                ret = this.accessor.readStream(this.resizableBuffer, this.initialBufferSize);
                            }
                        }
                        catch (SQLException e2) {
                            IOException iOException = new IOException(e2.getMessage());
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T4CInputStream.class, $$$methodRef$$$1, this, iOException);
                            }
                            throw iOException;
                        }
                        catch (IOException ea) {
                            try {
                                ((T4CConnection)this.statement.connection).handleIOException(ea);
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            IOException iOException = ea;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T4CInputStream.class, $$$methodRef$$$1, this, iOException);
                            }
                            throw iOException;
                        }
                        n3 = ret;
                        if (lock == null) break block26;
                        if (throwable == null) break block27;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T4CInputStream.class, $$$methodRef$$$1, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T4CInputStream.class, $$$methodRef$$$1, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block26;
                }
                lock.close();
            }
            int n4 = n3;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CInputStream.class, $$$methodRef$$$1, this, n4);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CInputStream.class, $$$methodRef$$$1, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CInputStream.class, $$$methodRef$$$1, this, throwable8);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$2 = T4CInputStream.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Accessor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CInputStream.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CInputStream.class.getDeclaredMethod("isNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

