/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.index.query.InnerHitBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.protobufs.ChildScoreMode;
import org.opensearch.protobufs.NestedQuery;
import org.opensearch.protobufs.QueryContainer;
import org.opensearch.transport.grpc.proto.request.search.InnerHitsBuilderProtoUtils;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;

class NestedQueryBuilderProtoUtils {
    private NestedQueryBuilderProtoUtils() {
    }

    static NestedQueryBuilder fromProto(NestedQuery nestedQueryProto, QueryBuilderProtoConverterRegistry registry) {
        if (nestedQueryProto == null) {
            throw new IllegalArgumentException("NestedQuery cannot be null");
        }
        float boost = 1.0f;
        ScoreMode scoreMode = ScoreMode.Avg;
        String queryName = null;
        QueryBuilder query = null;
        InnerHitBuilder innerHitBuilder = null;
        boolean ignoreUnmapped = false;
        String path = nestedQueryProto.getPath();
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Path is required for NestedQuery");
        }
        if (!nestedQueryProto.hasQuery()) {
            throw new IllegalArgumentException("Query is required for NestedQuery");
        }
        try {
            QueryContainer queryContainer = nestedQueryProto.getQuery();
            query = registry.fromProto(queryContainer);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert inner query for NestedQuery: " + e.getMessage(), e);
        }
        if (nestedQueryProto.hasScoreMode()) {
            scoreMode = NestedQueryBuilderProtoUtils.parseScoreMode(nestedQueryProto.getScoreMode());
        }
        if (nestedQueryProto.hasIgnoreUnmapped()) {
            ignoreUnmapped = nestedQueryProto.getIgnoreUnmapped();
        }
        if (nestedQueryProto.hasBoost()) {
            boost = nestedQueryProto.getBoost();
        }
        if (nestedQueryProto.hasXName()) {
            queryName = nestedQueryProto.getXName();
        }
        if (nestedQueryProto.hasInnerHits()) {
            try {
                innerHitBuilder = InnerHitsBuilderProtoUtils.fromProto(nestedQueryProto.getInnerHits(), registry);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to convert inner hits for NestedQuery: " + e.getMessage(), e);
            }
        }
        NestedQueryBuilder queryBuilder = (NestedQueryBuilder)((NestedQueryBuilder)new NestedQueryBuilder(path, query, scoreMode, innerHitBuilder).ignoreUnmapped(ignoreUnmapped).queryName(queryName)).boost(boost);
        return queryBuilder;
    }

    private static ScoreMode parseScoreMode(ChildScoreMode childScoreMode) {
        switch (childScoreMode) {
            case CHILD_SCORE_MODE_AVG: {
                return ScoreMode.Avg;
            }
            case CHILD_SCORE_MODE_MAX: {
                return ScoreMode.Max;
            }
            case CHILD_SCORE_MODE_MIN: {
                return ScoreMode.Min;
            }
            case CHILD_SCORE_MODE_NONE: {
                return ScoreMode.None;
            }
            case CHILD_SCORE_MODE_SUM: {
                return ScoreMode.Total;
            }
        }
        return ScoreMode.Avg;
    }
}

