/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.extract;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.function.filesleuth.extract.ContentReceiver;

public class XmlParser
extends DefaultHandler {
    private final ContentReceiver _receiver;
    private String _value = null;

    public XmlParser(ContentReceiver contentReceiver) {
        this._receiver = contentReceiver;
    }

    public boolean parseXmlStream(InputStream inputStream) {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance("org.apache.xerces.parsers.SAXParser", null).newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
            return true;
        }
        catch (Throwable throwable) {
            try {
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse(inputStream, (DefaultHandler)this);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string3.toLowerCase();
        if (this.isTextTag(string4) || this.isTimeTag(string4)) {
            this._value = "";
        } else if (this.isPointTag(string4)) {
            String string5 = attributes.getValue("lat");
            String string6 = attributes.getValue("lon");
            this.addCoordinates(string5, string6);
        }
        super.startElement(string, string2, string3, attributes);
    }

    private void addCoordinates(String string, String string2) {
        try {
            double d = Double.parseDouble(string);
            double d2 = Double.parseDouble(string2);
            this._receiver.addCoordinates(d, d2);
        }
        catch (Exception exception) {}
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._value != null) {
            this._value = String.valueOf(this._value) + new String(cArray, n, n2);
        }
        super.characters(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this._value != null) {
            String string4 = string3.toLowerCase();
            if (this.isTextTag(string4)) {
                this._receiver.addString(this._value);
                if ("name".equals(string4)) {
                    this._receiver.setName(this._value);
                } else if ("desc".equals(string4)) {
                    this._receiver.setDescription(this._value);
                }
            } else if (this.isTimeTag(string4)) {
                this._receiver.addDateString(this._value);
            }
            this._value = null;
        }
        super.endElement(string, string2, string3);
    }

    private boolean isTextTag(String string) {
        return "name".equals(string) || "desc".equals(string);
    }

    private boolean isTimeTag(String string) {
        return "when".equals(string) || "time".equals(string);
    }

    private boolean isPointTag(String string) {
        return "wpt".equals(string) || "trkpt".equals(string) || "rtept".equals(string);
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this._receiver.endDocument();
    }
}

