/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.PropertyDescriptor;
import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGrid.ServerDescriptor;
import com.zeroc.IceGrid.ServerInstanceDescriptor;
import com.zeroc.IceGrid.ServiceDescriptor;
import com.zeroc.IceGrid.ServiceInstanceDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.Communicator;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.ListTreeNode;
import com.zeroc.IceGridGUI.Application.Node;
import com.zeroc.IceGridGUI.Application.PropertySet;
import com.zeroc.IceGridGUI.Application.PropertySetParent;
import com.zeroc.IceGridGUI.Application.Server;
import com.zeroc.IceGridGUI.Application.ServerInstanceEditor;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.TreeNodeBase;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ServerInstance
extends ListTreeNode
implements PropertySetParent,
Server {
    private ServerInstanceDescriptor _descriptor;
    private final boolean _ephemeral;
    private boolean _isIceBox;
    private ServerInstanceEditor _editor;
    private Utils.Resolver _resolver;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon _serverIcon;
    private static Icon _iceboxServerIcon;
    private static JPopupMenu _popup;

    public static ServerInstanceDescriptor copyDescriptor(ServerInstanceDescriptor sid) {
        ServerInstanceDescriptor copy = sid.clone();
        copy.propertySet = PropertySet.copyDescriptor(copy.propertySet);
        return copy;
    }

    @Override
    public boolean getAllowsChildren() {
        return this._isIceBox;
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = !this._ephemeral;
        Object clipboard = this.getCoordinator().getClipboard();
        if (clipboard != null && (clipboard instanceof ServerDescriptor || clipboard instanceof ServerInstanceDescriptor || this._isIceBox && clipboard instanceof PropertySetDescriptor)) {
            actions[14] = true;
        }
        actions[15] = true;
        if (!this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
            if (this._isIceBox) {
                actions[3] = true;
            }
        }
        return actions;
    }

    @Override
    public void copy() {
        this.getCoordinator().setClipboard(ServerInstance.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    @Override
    public void paste() {
        Object descriptor;
        if (this._isIceBox && (descriptor = this.getCoordinator().getClipboard()) instanceof PropertySetDescriptor) {
            this.newPropertySet(PropertySet.copyDescriptor((PropertySetDescriptor)descriptor));
            return;
        }
        ((TreeNode)this._parent).paste();
    }

    @Override
    public void newPropertySet() {
        this.newPropertySet(new PropertySetDescriptor(new String[0], new LinkedList<PropertyDescriptor>()));
    }

    @Override
    public JPopupMenu getPopupMenu() {
        if (this._isIceBox) {
            ApplicationActions actions = this.getCoordinator().getActionsForPopup();
            if (_popup == null) {
                _popup = new JPopupMenu();
                _popup.add(actions.get(3));
            }
            actions.setTarget(this);
            return _popup;
        }
        return null;
    }

    @Override
    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ServerInstanceEditor)this.getRoot().getEditor(ServerInstanceEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    @Override
    protected Editor createEditor() {
        return new ServerInstanceEditor();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _serverIcon = Utils.getIcon("/icons/16x16/server_inactive.png");
            _iceboxServerIcon = Utils.getIcon("/icons/16x16/icebox_server_inactive.png");
            _cellRenderer.setLeafIcon(_serverIcon);
            _cellRenderer.setOpenIcon(_iceboxServerIcon);
            _cellRenderer.setClosedIcon(_iceboxServerIcon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public void destroy() {
        Node node = (Node)this._parent;
        if (this._ephemeral) {
            node.removeServer(this);
        } else {
            node.removeDescriptor(this._descriptor);
            node.removeServer(this);
            node.getEditable().removeElement(this._id, this._editable, Server.class);
            this.getRoot().updated();
        }
    }

    @Override
    public Object getDescriptor() {
        return this._descriptor;
    }

    @Override
    public Object saveDescriptor() {
        return this._descriptor.clone();
    }

    @Override
    public void restoreDescriptor(Object savedDescriptor) {
        ServerInstanceDescriptor copy = (ServerInstanceDescriptor)savedDescriptor;
        this._descriptor.template = copy.template;
        this._descriptor.parameterValues = copy.parameterValues;
        this._descriptor.propertySet = copy.propertySet;
    }

    ServerInstance(boolean brandNew, TreeNode parent, String serverId, Utils.Resolver resolver, ServerInstanceDescriptor instanceDescriptor, boolean isIceBox) throws UpdateFailedException {
        super(brandNew, parent, serverId);
        this._ephemeral = false;
        this.rebuild(resolver, instanceDescriptor, isIceBox);
    }

    ServerInstance(TreeNode parent, String serverId, ServerInstanceDescriptor instanceDescriptor) {
        block2: {
            super(false, parent, serverId);
            this._ephemeral = true;
            try {
                this.rebuild(null, instanceDescriptor, false);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            TemplateDescriptor templateDescriptor = this.getRoot().findServerTemplateDescriptor(this._descriptor.template);
            LinkedList<String[]> attributes = ServerInstance.parameterValuesToAttributes(this._descriptor.parameterValues, templateDescriptor.parameters);
            attributes.addFirst(ServerInstance.createAttribute("template", this._descriptor.template));
            if (this._descriptor.propertySet.references.length == 0 && this._descriptor.propertySet.properties.size() == 0 && this._children.size() == 0) {
                writer.writeElement("server-instance", attributes);
            } else {
                writer.writeStartTag("server-instance", attributes);
                ServerInstance.writePropertySet(writer, this._descriptor.propertySet, null, null);
                for (TreeNodeBase p : this._children) {
                    PropertySet ps = (PropertySet)p;
                    ps.write(writer);
                }
                writer.writeEndTag("server-instance");
            }
        }
    }

    void isIceBox(boolean newValue) {
        if (newValue != this._isIceBox) {
            this._isIceBox = newValue;
            this._children.clear();
            this.getRoot().getTreeModel().nodeStructureChanged(this);
        }
    }

    @Override
    public Object rebuild(List<Editable> editables) throws UpdateFailedException {
        ServerInstance newServer;
        Node node = (Node)this._parent;
        Backup backup = new Backup(node.getEditable().save());
        TemplateDescriptor templateDescriptor = this.getRoot().findServerTemplateDescriptor(this._descriptor.template);
        HashSet<String> parameters = new HashSet<String>(templateDescriptor.parameters);
        if (!parameters.equals(this._descriptor.parameterValues.keySet())) {
            backup.parameterValues = this._descriptor.parameterValues;
            this._descriptor.parameterValues = Editor.makeParameterValues(this._descriptor.parameterValues, templateDescriptor.parameters);
        }
        if (this._id.equals((newServer = node.createServer(false, this._descriptor)).getId())) {
            block9: {
                if (this._editable.isModified()) {
                    newServer.getEditable().markModified();
                }
                node.removeServer(this);
                try {
                    node.insertServer(newServer, true);
                }
                catch (UpdateFailedException e) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
            if (backup.parameterValues != null) {
                editables.add(newServer.getEditable());
            }
        } else {
            newServer.getEditable().markNew();
            node.removeServer(this);
            node.getEditable().removeElement(this._id, this._editable, Server.class);
            try {
                node.insertServer(newServer, true);
            }
            catch (UpdateFailedException e) {
                this.restore(backup);
                throw e;
            }
        }
        return backup;
    }

    @Override
    public void restore(Object backupObj) {
        block4: {
            TreeNode badServer;
            Backup backup = (Backup)backupObj;
            Node node = (Node)this._parent;
            node.getEditable().restore(backup.nodeEditable);
            if (backup.parameterValues != null) {
                this._descriptor.parameterValues = backup.parameterValues;
            }
            if ((badServer = node.findChildWithDescriptor(this._descriptor)) != null) {
                node.removeServer(badServer);
            }
            try {
                node.insertServer(this, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void tryAdd(String unsubstitutedId, PropertySetDescriptor descriptor) throws UpdateFailedException {
        this.insertPropertySet(new PropertySet(this, Utils.substitute(unsubstitutedId, this._resolver), unsubstitutedId, descriptor), true);
        this._descriptor.servicePropertySets.put(unsubstitutedId, descriptor);
        this._editable.markModified();
    }

    @Override
    public void tryRename(String oldId, String oldUnresolvedId, String newUnsubstitutedId) throws UpdateFailedException {
        PropertySet oldChild = (PropertySet)this.findChild(oldId);
        assert (oldChild != null);
        this.removePropertySet(oldChild);
        PropertySetDescriptor descriptor = (PropertySetDescriptor)oldChild.getDescriptor();
        try {
            this.insertPropertySet(new PropertySet(this, Utils.substitute(newUnsubstitutedId, this._resolver), newUnsubstitutedId, descriptor), true);
        }
        catch (UpdateFailedException ex) {
            block5: {
                try {
                    this.insertPropertySet(oldChild, true);
                }
                catch (UpdateFailedException ufe) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            throw ex;
        }
        this._editable.markModified();
        this._descriptor.servicePropertySets.remove(oldUnresolvedId);
        this._descriptor.servicePropertySets.put(newUnsubstitutedId, descriptor);
    }

    @Override
    public void insertPropertySet(PropertySet nps, boolean fireEvent) throws UpdateFailedException {
        this.insertChild(nps, fireEvent);
    }

    @Override
    public void removePropertySet(PropertySet nps) {
        this.removeChild(nps);
    }

    @Override
    public void removeDescriptor(String unsubstitutedId) {
        this._descriptor.servicePropertySets.remove(unsubstitutedId);
    }

    @Override
    public Editable getEditable() {
        return this._editable;
    }

    String[] getServiceNames() {
        assert (this._isIceBox);
        Communicator.Services services = this.getRoot().findServerTemplate(this._descriptor.template).getServices();
        String[] result = new String[services.size()];
        int i = 0;
        Iterator<TreeNode> p = services.iterator();
        while (p.hasNext()) {
            TreeNode n = p.next();
            ServiceInstanceDescriptor d = (ServiceInstanceDescriptor)n.getDescriptor();
            if (d.template.length() > 0) {
                TemplateDescriptor templateDescriptor = this.getRoot().findServiceTemplateDescriptor(d.template);
                assert (templateDescriptor != null);
                Utils.Resolver serviceResolver = new Utils.Resolver(this._resolver, d.parameterValues, templateDescriptor.parameterDefaults);
                ServiceDescriptor serviceDescriptor = (ServiceDescriptor)templateDescriptor.descriptor;
                result[i++] = serviceResolver.substitute(serviceDescriptor.name);
                continue;
            }
            result[i++] = this._resolver.substitute(d.descriptor.name);
        }
        return result;
    }

    void rebuild(Utils.Resolver resolver, ServerInstanceDescriptor instanceDescriptor, boolean isIceBox) throws UpdateFailedException {
        this._resolver = resolver;
        this._isIceBox = isIceBox;
        this._descriptor = instanceDescriptor;
        this._children.clear();
        for (Map.Entry<String, PropertySetDescriptor> p : this._descriptor.servicePropertySets.entrySet()) {
            String unsubstitutedId = p.getKey();
            this.insertPropertySet(new PropertySet(this, Utils.substitute(unsubstitutedId, this._resolver), unsubstitutedId, p.getValue()), false);
        }
    }

    private void newPropertySet(PropertySetDescriptor descriptor) {
        PropertySet ps;
        block2: {
            String id = this.makeNewChildId("Service");
            ps = new PropertySet(this, id, descriptor);
            try {
                this.insertChild(ps, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(ps);
    }

    @Override
    Utils.Resolver getResolver() {
        return this._resolver;
    }

    @Override
    public boolean isEphemeral() {
        return this._ephemeral;
    }

    @Override
    public String toString() {
        if (this._ephemeral) {
            return super.toString();
        }
        return this._id + ": " + this._descriptor.template + "<>";
    }

    private static class Backup {
        Editable nodeEditable;
        Map<String, String> parameterValues;

        Backup(Editable ne) {
            this.nodeEditable = ne;
        }
    }
}

