/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

class Editable
implements Cloneable {
    private boolean _isNew = false;
    private boolean _modified = false;
    private HashMap<Class, TreeSet<String>> _removedElements = new HashMap();

    Editable(boolean brandNew) {
        this._isNew = brandNew;
    }

    boolean isNew() {
        return this._isNew;
    }

    boolean isModified() {
        return this._modified;
    }

    void markModified() {
        this._modified = true;
    }

    void commit() {
        this._isNew = false;
        this._modified = false;
        this._removedElements.clear();
    }

    void markNew() {
        this._isNew = true;
    }

    void removeElement(String id, Editable editable, Class forClass) {
        if (!editable.isNew()) {
            TreeSet<String> set = this._removedElements.get(forClass);
            if (set == null) {
                set = new TreeSet();
                this._removedElements.put(forClass, set);
            }
            set.add(id);
        }
    }

    String[] removedElements(Class forClass) {
        TreeSet<String> set = this._removedElements.get(forClass);
        if (set == null) {
            return new String[0];
        }
        return set.toArray(new String[0]);
    }

    Editable save() {
        try {
            Editable result = (Editable)this.clone();
            HashMap removedElements = new HashMap();
            for (Map.Entry<Class, TreeSet<String>> p : result._removedElements.entrySet()) {
                TreeSet val = new TreeSet(p.getValue());
                removedElements.put(p.getKey(), val);
            }
            result._removedElements = removedElements;
            return result;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    void restore(Editable clone) {
        this._isNew = clone._isNew;
        this._modified = clone._modified;
        this._removedElements = clone._removedElements;
    }
}

