/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.ShaderAttributeObjectRetained;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point2i;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Point4i;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple2i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;
import javax.vecmath.Tuple4f;
import javax.vecmath.Tuple4i;

class ShaderAttributeArrayRetained
extends ShaderAttributeObjectRetained {
    ShaderAttributeArrayRetained() {
    }

    void initValue(int n, Object object) {
        ((ArrayWrapper)this.attrWrapper).set(n, object);
    }

    void setValue(int n, Object object) {
        this.initValue(n, object);
        this.setValue(this.attrWrapper.getRef());
    }

    int length() {
        return ((ArrayWrapper)this.attrWrapper).length();
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            ShaderAttributeArrayRetained shaderAttributeArrayRetained = new ShaderAttributeArrayRetained();
            shaderAttributeArrayRetained.createObjectData(this.getValue());
            this.mirror = shaderAttributeArrayRetained;
            this.mirror.source = this.source;
        }
        this.initMirrorObject();
    }

    @Override
    int computeClassType(Object object) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new ClassCastException(clazz + " -- must be array class");
        }
        for (int i = 0; i < classTable.length; ++i) {
            if (!classTableArr[i].isInstance(object)) continue;
            return i;
        }
        throw new ClassCastException(clazz + " -- unrecognized class");
    }

    @Override
    Class getBaseClass(int n) {
        return classTableArr[n];
    }

    @Override
    ShaderAttributeObjectRetained.AttrWrapper createAttrWrapper(Object object, int n) {
        ArrayWrapper arrayWrapper = null;
        switch (n) {
            case 0: {
                arrayWrapper = new IntegerArrayWrapper();
                break;
            }
            case 1: {
                arrayWrapper = new FloatArrayWrapper();
                break;
            }
            case 2: {
                arrayWrapper = new Tuple2iArrayWrapper();
                break;
            }
            case 3: {
                arrayWrapper = new Tuple2fArrayWrapper();
                break;
            }
            case 4: {
                arrayWrapper = new Tuple3iArrayWrapper();
                break;
            }
            case 5: {
                arrayWrapper = new Tuple3fArrayWrapper();
                break;
            }
            case 6: {
                arrayWrapper = new Tuple4iArrayWrapper();
                break;
            }
            case 7: {
                arrayWrapper = new Tuple4fArrayWrapper();
                break;
            }
            case 8: {
                arrayWrapper = new Matrix3fArrayWrapper();
                break;
            }
            case 9: {
                arrayWrapper = new Matrix4fArrayWrapper();
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        arrayWrapper.set(object);
        return arrayWrapper;
    }

    static class Matrix4fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Matrix4fArrayWrapper() {
        }

        @Override
        void set(Object object) {
            Matrix4f[] matrix4fArray = (Matrix4f[])object;
            if (this.length != matrix4fArray.length) {
                this.length = matrix4fArray.length;
                this.value = new float[this.length * 16];
            }
            for (int i = 0; i < this.length; ++i) {
                int n = i * 16;
                this.value[n + 0] = matrix4fArray[i].m00;
                this.value[n + 1] = matrix4fArray[i].m01;
                this.value[n + 2] = matrix4fArray[i].m02;
                this.value[n + 3] = matrix4fArray[i].m03;
                this.value[n + 4] = matrix4fArray[i].m10;
                this.value[n + 5] = matrix4fArray[i].m11;
                this.value[n + 6] = matrix4fArray[i].m12;
                this.value[n + 7] = matrix4fArray[i].m13;
                this.value[n + 8] = matrix4fArray[i].m20;
                this.value[n + 9] = matrix4fArray[i].m21;
                this.value[n + 10] = matrix4fArray[i].m22;
                this.value[n + 11] = matrix4fArray[i].m23;
                this.value[n + 12] = matrix4fArray[i].m30;
                this.value[n + 13] = matrix4fArray[i].m31;
                this.value[n + 14] = matrix4fArray[i].m32;
                this.value[n + 15] = matrix4fArray[i].m33;
            }
        }

        @Override
        void set(int n, Object object) {
            int n2 = n * 16;
            Matrix4f matrix4f = (Matrix4f)object;
            this.value[n2 + 0] = matrix4f.m00;
            this.value[n2 + 1] = matrix4f.m01;
            this.value[n2 + 2] = matrix4f.m02;
            this.value[n2 + 3] = matrix4f.m03;
            this.value[n2 + 4] = matrix4f.m10;
            this.value[n2 + 5] = matrix4f.m11;
            this.value[n2 + 6] = matrix4f.m12;
            this.value[n2 + 7] = matrix4f.m13;
            this.value[n2 + 8] = matrix4f.m20;
            this.value[n2 + 9] = matrix4f.m21;
            this.value[n2 + 10] = matrix4f.m22;
            this.value[n2 + 11] = matrix4f.m23;
            this.value[n2 + 12] = matrix4f.m30;
            this.value[n2 + 13] = matrix4f.m31;
            this.value[n2 + 14] = matrix4f.m32;
            this.value[n2 + 15] = matrix4f.m33;
        }

        @Override
        Object get() {
            Matrix4f[] matrix4fArray = new Matrix4f[this.length];
            for (int i = 0; i < this.length; ++i) {
                int n = i * 16;
                matrix4fArray[i] = new Matrix4f();
                matrix4fArray[i].m00 = this.value[n + 0];
                matrix4fArray[i].m01 = this.value[n + 1];
                matrix4fArray[i].m02 = this.value[n + 2];
                matrix4fArray[i].m03 = this.value[n + 3];
                matrix4fArray[i].m10 = this.value[n + 4];
                matrix4fArray[i].m11 = this.value[n + 5];
                matrix4fArray[i].m12 = this.value[n + 6];
                matrix4fArray[i].m13 = this.value[n + 7];
                matrix4fArray[i].m20 = this.value[n + 8];
                matrix4fArray[i].m21 = this.value[n + 9];
                matrix4fArray[i].m22 = this.value[n + 10];
                matrix4fArray[i].m23 = this.value[n + 11];
                matrix4fArray[i].m30 = this.value[n + 12];
                matrix4fArray[i].m31 = this.value[n + 13];
                matrix4fArray[i].m32 = this.value[n + 14];
                matrix4fArray[i].m33 = this.value[n + 15];
            }
            return matrix4fArray;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Matrix3fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Matrix3fArrayWrapper() {
        }

        @Override
        void set(Object object) {
            Matrix3f[] matrix3fArray = (Matrix3f[])object;
            if (this.length != matrix3fArray.length) {
                this.length = matrix3fArray.length;
                this.value = new float[this.length * 9];
            }
            for (int i = 0; i < this.length; ++i) {
                int n = i * 9;
                this.value[n + 0] = matrix3fArray[i].m00;
                this.value[n + 1] = matrix3fArray[i].m01;
                this.value[n + 2] = matrix3fArray[i].m02;
                this.value[n + 3] = matrix3fArray[i].m10;
                this.value[n + 4] = matrix3fArray[i].m11;
                this.value[n + 5] = matrix3fArray[i].m12;
                this.value[n + 6] = matrix3fArray[i].m20;
                this.value[n + 7] = matrix3fArray[i].m21;
                this.value[n + 8] = matrix3fArray[i].m22;
            }
        }

        @Override
        void set(int n, Object object) {
            int n2 = n * 9;
            Matrix3f matrix3f = (Matrix3f)object;
            this.value[n2 + 0] = matrix3f.m00;
            this.value[n2 + 1] = matrix3f.m01;
            this.value[n2 + 2] = matrix3f.m02;
            this.value[n2 + 3] = matrix3f.m10;
            this.value[n2 + 4] = matrix3f.m11;
            this.value[n2 + 5] = matrix3f.m12;
            this.value[n2 + 6] = matrix3f.m20;
            this.value[n2 + 7] = matrix3f.m21;
            this.value[n2 + 8] = matrix3f.m22;
        }

        @Override
        Object get() {
            Matrix3f[] matrix3fArray = new Matrix3f[this.length];
            for (int i = 0; i < this.length; ++i) {
                int n = i * 9;
                matrix3fArray[i] = new Matrix3f();
                matrix3fArray[i].m00 = this.value[n + 0];
                matrix3fArray[i].m01 = this.value[n + 1];
                matrix3fArray[i].m02 = this.value[n + 2];
                matrix3fArray[i].m10 = this.value[n + 3];
                matrix3fArray[i].m11 = this.value[n + 4];
                matrix3fArray[i].m12 = this.value[n + 5];
                matrix3fArray[i].m20 = this.value[n + 6];
                matrix3fArray[i].m21 = this.value[n + 7];
                matrix3fArray[i].m22 = this.value[n + 8];
            }
            return matrix3fArray;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple4fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Tuple4fArrayWrapper() {
        }

        @Override
        void set(Object object) {
            Tuple4f[] tuple4fArray = (Tuple4f[])object;
            if (this.length != tuple4fArray.length) {
                this.length = tuple4fArray.length;
                this.value = new float[this.length * 4];
            }
            for (int i = 0; i < this.length; ++i) {
                int n = i * 4;
                this.value[n + 0] = tuple4fArray[i].x;
                this.value[n + 1] = tuple4fArray[i].y;
                this.value[n + 2] = tuple4fArray[i].z;
                this.value[n + 3] = tuple4fArray[i].w;
            }
        }

        @Override
        void set(int n, Object object) {
            int n2 = n * 4;
            this.value[n2 + 0] = ((Tuple4f)object).x;
            this.value[n2 + 1] = ((Tuple4f)object).y;
            this.value[n2 + 2] = ((Tuple4f)object).z;
            this.value[n2 + 3] = ((Tuple4f)object).w;
        }

        @Override
        Object get() {
            Tuple4f[] tuple4fArray = new Tuple4f[this.length];
            for (int i = 0; i < this.length; ++i) {
                int n = i * 4;
                tuple4fArray[i] = new Point4f();
                tuple4fArray[i].x = this.value[n + 0];
                tuple4fArray[i].y = this.value[n + 1];
                tuple4fArray[i].z = this.value[n + 2];
                tuple4fArray[i].w = this.value[n + 3];
            }
            return tuple4fArray;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple4iArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        Tuple4iArrayWrapper() {
        }

        @Override
        void set(Object object) {
            Tuple4i[] tuple4iArray = (Tuple4i[])object;
            if (this.length != tuple4iArray.length) {
                this.length = tuple4iArray.length;
                this.value = new int[this.length * 4];
            }
            for (int i = 0; i < this.length; ++i) {
                int n = i * 4;
                this.value[n + 0] = tuple4iArray[i].x;
                this.value[n + 1] = tuple4iArray[i].y;
                this.value[n + 2] = tuple4iArray[i].z;
                this.value[n + 3] = tuple4iArray[i].w;
            }
        }

        @Override
        void set(int n, Object object) {
            int n2 = n * 4;
            this.value[n2 + 0] = ((Tuple4i)object).x;
            this.value[n2 + 1] = ((Tuple4i)object).y;
            this.value[n2 + 2] = ((Tuple4i)object).z;
            this.value[n2 + 3] = ((Tuple4i)object).w;
        }

        @Override
        Object get() {
            Tuple4i[] tuple4iArray = new Tuple4i[this.length];
            for (int i = 0; i < this.length; ++i) {
                int n = i * 4;
                tuple4iArray[i] = new Point4i();
                tuple4iArray[i].x = this.value[n + 0];
                tuple4iArray[i].y = this.value[n + 1];
                tuple4iArray[i].z = this.value[n + 2];
                tuple4iArray[i].w = this.value[n + 3];
            }
            return tuple4iArray;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple3fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Tuple3fArrayWrapper() {
        }

        @Override
        void set(Object object) {
            Tuple3f[] tuple3fArray = (Tuple3f[])object;
            if (this.length != tuple3fArray.length) {
                this.length = tuple3fArray.length;
                this.value = new float[this.length * 3];
            }
            for (int i = 0; i < this.length; ++i) {
                int n = i * 3;
                this.value[n + 0] = tuple3fArray[i].x;
                this.value[n + 1] = tuple3fArray[i].y;
                this.value[n + 2] = tuple3fArray[i].z;
            }
        }

        @Override
        void set(int n, Object object) {
            int n2 = n * 3;
            this.value[n2 + 0] = ((Tuple3f)object).x;
            this.value[n2 + 1] = ((Tuple3f)object).y;
            this.value[n2 + 2] = ((Tuple3f)object).z;
        }

        @Override
        Object get() {
            Tuple3f[] tuple3fArray = new Tuple3f[this.length];
            for (int i = 0; i < this.length; ++i) {
                int n = i * 3;
                tuple3fArray[i] = new Point3f();
                tuple3fArray[i].x = this.value[n + 0];
                tuple3fArray[i].y = this.value[n + 1];
                tuple3fArray[i].z = this.value[n + 2];
            }
            return tuple3fArray;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple3iArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        Tuple3iArrayWrapper() {
        }

        @Override
        void set(Object object) {
            Tuple3i[] tuple3iArray = (Tuple3i[])object;
            if (this.length != tuple3iArray.length) {
                this.length = tuple3iArray.length;
                this.value = new int[this.length * 3];
            }
            for (int i = 0; i < this.length; ++i) {
                int n = i * 3;
                this.value[n + 0] = tuple3iArray[i].x;
                this.value[n + 1] = tuple3iArray[i].y;
                this.value[n + 2] = tuple3iArray[i].z;
            }
        }

        @Override
        void set(int n, Object object) {
            int n2 = n * 3;
            this.value[n2 + 0] = ((Tuple3i)object).x;
            this.value[n2 + 1] = ((Tuple3i)object).y;
            this.value[n2 + 2] = ((Tuple3i)object).z;
        }

        @Override
        Object get() {
            Tuple3i[] tuple3iArray = new Tuple3i[this.length];
            for (int i = 0; i < this.length; ++i) {
                int n = i * 3;
                tuple3iArray[i] = new Point3i();
                tuple3iArray[i].x = this.value[n + 0];
                tuple3iArray[i].y = this.value[n + 1];
                tuple3iArray[i].z = this.value[n + 2];
            }
            return tuple3iArray;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple2fArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        Tuple2fArrayWrapper() {
        }

        @Override
        void set(Object object) {
            Tuple2f[] tuple2fArray = (Tuple2f[])object;
            if (this.length != tuple2fArray.length) {
                this.length = tuple2fArray.length;
                this.value = new float[this.length * 2];
            }
            for (int i = 0; i < this.length; ++i) {
                int n = i * 2;
                this.value[n + 0] = tuple2fArray[i].x;
                this.value[n + 1] = tuple2fArray[i].y;
            }
        }

        @Override
        void set(int n, Object object) {
            int n2 = n * 2;
            this.value[n2 + 0] = ((Tuple2f)object).x;
            this.value[n2 + 1] = ((Tuple2f)object).y;
        }

        @Override
        Object get() {
            Tuple2f[] tuple2fArray = new Tuple2f[this.length];
            for (int i = 0; i < this.length; ++i) {
                int n = i * 2;
                tuple2fArray[i] = new Point2f();
                tuple2fArray[i].x = this.value[n + 0];
                tuple2fArray[i].y = this.value[n + 1];
            }
            return tuple2fArray;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class Tuple2iArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        Tuple2iArrayWrapper() {
        }

        @Override
        void set(Object object) {
            Tuple2i[] tuple2iArray = (Tuple2i[])object;
            if (this.length != tuple2iArray.length) {
                this.length = tuple2iArray.length;
                this.value = new int[this.length * 2];
            }
            for (int i = 0; i < this.length; ++i) {
                int n = i * 2;
                this.value[n + 0] = tuple2iArray[i].x;
                this.value[n + 1] = tuple2iArray[i].y;
            }
        }

        @Override
        void set(int n, Object object) {
            int n2 = n * 2;
            this.value[n2 + 0] = ((Tuple2i)object).x;
            this.value[n2 + 1] = ((Tuple2i)object).y;
        }

        @Override
        Object get() {
            Tuple2i[] tuple2iArray = new Tuple2i[this.length];
            for (int i = 0; i < this.length; ++i) {
                int n = i * 2;
                tuple2iArray[i] = new Point2i();
                tuple2iArray[i].x = this.value[n + 0];
                tuple2iArray[i].y = this.value[n + 1];
            }
            return tuple2iArray;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class FloatArrayWrapper
    extends ArrayWrapper {
        private float[] value = new float[0];

        FloatArrayWrapper() {
        }

        @Override
        void set(Object object) {
            Float[] floatArray = (Float[])object;
            if (this.length != floatArray.length) {
                this.length = floatArray.length;
                this.value = new float[this.length];
            }
            for (int i = 0; i < this.length; ++i) {
                this.value[i] = floatArray[i].floatValue();
            }
        }

        @Override
        void set(int n, Object object) {
            this.value[n] = ((Float)object).floatValue();
        }

        @Override
        Object get() {
            Float[] floatArray = new Float[this.length];
            for (int i = 0; i < this.length; ++i) {
                floatArray[i] = new Float(this.value[i]);
            }
            return floatArray;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static class IntegerArrayWrapper
    extends ArrayWrapper {
        private int[] value = new int[0];

        IntegerArrayWrapper() {
        }

        @Override
        void set(Object object) {
            Integer[] integerArray = (Integer[])object;
            if (this.length != integerArray.length) {
                this.length = integerArray.length;
                this.value = new int[this.length];
            }
            for (int i = 0; i < this.length; ++i) {
                this.value[i] = integerArray[i];
            }
        }

        @Override
        void set(int n, Object object) {
            this.value[n] = (Integer)object;
        }

        @Override
        Object get() {
            Integer[] integerArray = new Integer[this.length];
            for (int i = 0; i < this.length; ++i) {
                integerArray[i] = new Integer(this.value[i]);
            }
            return integerArray;
        }

        @Override
        Object getRef() {
            return this.value;
        }
    }

    static abstract class ArrayWrapper
    extends ShaderAttributeObjectRetained.AttrWrapper {
        int length = 0;

        ArrayWrapper() {
        }

        int length() {
            return this.length;
        }

        abstract void set(int var1, Object var2);
    }
}

