/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicModule;
import com.sun.media.BasicPlugIn;
import com.sun.media.Connector;
import com.sun.media.CreateSourceThreadAction;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.MyOutputConnector;
import com.sun.media.PlaybackEngine;
import com.sun.media.SourceThread;
import com.sun.media.rtp.util.RTPTimeBase;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12PriorityAction;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.BadHeaderException;
import javax.media.Demultiplexer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.PlugInManager;
import javax.media.ResourceUnavailableException;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.Positionable;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;

public class BasicSourceModule
extends BasicModule
implements Duration,
Positionable {
    PlaybackEngine engine;
    protected DataSource source;
    protected Demultiplexer parser;
    protected Track[] tracks = new Track[0];
    protected SourceThread[] loops;
    protected String[] connectorNames;
    protected long bitsRead = 0L;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    Object resetSync = new Object();
    protected boolean started = false;
    protected SystemTimeBase systemTimeBase = new SystemTimeBase();
    protected long lastSystemTime = 0L;
    protected long originSystemTime = 0L;
    protected long currentSystemTime = 0L;
    protected Time lastPositionSet = new Time(0L);
    RTPTimeBase rtpMapperUpdatable = null;
    RTPTimeBase rtpMapper = null;
    long currentRTPTime = 0L;
    long oldOffset = 0L;
    boolean rtpOffsetInvalid = true;
    String cname = null;
    public String errMsg = null;
    int latencyTrack = -1;
    static /* synthetic */ Class class$com$sun$media$SourceThread;

    public static BasicSourceModule createModule(DataSource ds) throws IOException, IncompatibleSourceException {
        Demultiplexer parser = BasicSourceModule.createDemultiplexer(ds);
        if (parser == null) {
            return null;
        }
        return new BasicSourceModule(ds, parser);
    }

    protected BasicSourceModule(DataSource ds, Demultiplexer demux) {
        this.source = ds;
        this.parser = demux;
        PullSourceStream stream = null;
        if (this.source instanceof PullDataSource) {
            stream = ((PullDataSource)this.source).getStreams()[0];
        } else if (this.source instanceof PushDataSource) {
            PushSourceStream pushSourceStream = ((PushDataSource)this.source).getStreams()[0];
        }
    }

    protected static Demultiplexer createDemultiplexer(DataSource ds) throws IOException, IncompatibleSourceException {
        ContentDescriptor cd = new ContentDescriptor(ds.getContentType());
        Vector cnames = PlugInManager.getPlugInList(cd, null, 1);
        Demultiplexer parser = null;
        IOException ioe = null;
        IncompatibleSourceException ise = null;
        int i = 0;
        while (i < cnames.size()) {
            block11: {
                try {
                    Class cls = BasicPlugIn.getClassForName((String)cnames.elementAt(i));
                    Object p = cls.newInstance();
                    if (!(p instanceof Demultiplexer)) break block11;
                    parser = (Demultiplexer)p;
                    try {
                        parser.setSource(ds);
                        break;
                    }
                    catch (IOException e) {
                        parser = null;
                        ioe = e;
                    }
                    catch (IncompatibleSourceException e) {
                        parser = null;
                        ise = e;
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (parser == null) {
            if (ioe != null) {
                throw ioe;
            }
            if (ise != null) {
                throw ise;
            }
        }
        return parser;
    }

    public boolean doRealize() {
        try {
            this.parser.open();
        }
        catch (ResourceUnavailableException e) {
            this.errMsg = "Resource unavailable: " + e.getMessage();
            return false;
        }
        try {
            this.parser.start();
            this.tracks = this.parser.getTracks();
        }
        catch (BadHeaderException e) {
            this.errMsg = "Bad header in the media: " + e.getMessage();
            this.parser.close();
            return false;
        }
        catch (IOException e) {
            this.errMsg = "IO exception: " + e.getMessage();
            this.parser.close();
            return false;
        }
        if (this.tracks == null || this.tracks.length == 0) {
            this.errMsg = "The media has 0 track";
            this.parser.close();
            return false;
        }
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Exception e) {
                securityPrivelege = false;
            }
        }
        this.loops = new SourceThread[this.tracks.length];
        this.connectorNames = new String[this.tracks.length];
        int i = 0;
        while (i < this.tracks.length) {
            MyOutputConnector oc = new MyOutputConnector(this.tracks[i]);
            oc.setProtocol(0);
            oc.setSize(1);
            this.connectorNames[i] = this.tracks[i].toString();
            this.registerOutputConnector(this.tracks[i].toString(), oc);
            this.loops[i] = null;
            ++i;
        }
        this.engine = (PlaybackEngine)this.getController();
        if (this.engine == null || !this.engine.isRTP()) {
            this.parser.stop();
        }
        return true;
    }

    SourceThread createSourceThread(int idx) {
        SourceThread thread = null;
        MyOutputConnector oc = (MyOutputConnector)this.getOutputConnector(this.connectorNames[idx]);
        if (oc == null || oc.getInputConnector() == null) {
            this.tracks[idx].setEnabled(false);
            return null;
        }
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = CreateSourceThreadAction.cons;
                Constructor pcons = jdk12PriorityAction.cons;
                thread = (SourceThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$SourceThread == null ? (class$com$sun$media$SourceThread = BasicSourceModule.class$("com.sun.media.SourceThread")) : class$com$sun$media$SourceThread, this, oc, new Integer(idx)));
                int priority = this.tracks[idx].getFormat() instanceof AudioFormat ? MediaThread.getAudioPriority() : MediaThread.getVideoPriority();
                thread.useVideoPriority();
                jdk12.doPrivM.invoke((Object)jdk12.ac, pcons.newInstance(thread, new Integer(priority)));
            }
            catch (Exception e) {
                thread = null;
            }
        } else {
            thread = new SourceThread(this, oc, idx);
            if (this.tracks[idx].getFormat() instanceof AudioFormat) {
                thread.useAudioPriority();
            } else {
                thread.useVideoPriority();
            }
        }
        if (thread == null) {
            this.tracks[idx].setEnabled(false);
        }
        return thread;
    }

    public void doFailedRealize() {
        this.parser.stop();
        this.parser.close();
    }

    public void abortRealize() {
        this.parser.stop();
        this.parser.close();
    }

    public boolean doPrefetch() {
        super.doPrefetch();
        return true;
    }

    public void doFailedPrefetch() {
    }

    public void abortPrefetch() {
        this.doStop();
    }

    public void doStart() {
        this.lastSystemTime = this.systemTimeBase.getNanoseconds();
        this.originSystemTime = this.currentSystemTime;
        this.rtpOffsetInvalid = true;
        super.doStart();
        try {
            this.parser.start();
        }
        catch (IOException e) {
            // empty catch block
        }
        int i = 0;
        while (i < this.loops.length) {
            if (this.tracks[i].isEnabled() && (this.loops[i] != null || (this.loops[i] = this.createSourceThread(i)) != null)) {
                this.loops[i].start();
            }
            ++i;
        }
        this.started = true;
    }

    public void doStop() {
        this.started = false;
    }

    public void pause() {
        Object object = this.resetSync;
        synchronized (object) {
            int i = 0;
            while (i < this.loops.length) {
                if (this.tracks[i].isEnabled() && this.loops[i] != null && !this.loops[i].resetted) {
                    this.loops[i].pause();
                }
                ++i;
            }
            this.parser.stop();
        }
    }

    public void doDealloc() {
    }

    public void doClose() {
        this.parser.close();
        if (this.tracks == null) {
            return;
        }
        int i = 0;
        while (i < this.tracks.length) {
            if (this.loops[i] != null) {
                this.loops[i].kill();
            }
            ++i;
        }
        if (this.rtpMapperUpdatable != null) {
            RTPTimeBase.returnMapperUpdatable(this.rtpMapperUpdatable);
            this.rtpMapperUpdatable = null;
        }
    }

    public void reset() {
        Object object = this.resetSync;
        synchronized (object) {
            super.reset();
            int i = 0;
            while (i < this.loops.length) {
                if (this.tracks[i].isEnabled() && (this.loops[i] != null || (this.loops[i] = this.createSourceThread(i)) != null)) {
                    this.loops[i].resetted = true;
                    this.loops[i].start();
                }
                ++i;
            }
        }
    }

    public String[] getOutputConnectorNames() {
        return this.connectorNames;
    }

    public Time getDuration() {
        return this.parser.getDuration();
    }

    public Time setPosition(Time when, int rounding) {
        Time t = this.parser.setPosition(when, rounding);
        this.lastPositionSet = this.lastPositionSet.getNanoseconds() == t.getNanoseconds() ? new Time(t.getNanoseconds() + 1L) : t;
        return t;
    }

    public boolean isPositionable() {
        return this.parser.isPositionable();
    }

    public boolean isRandomAccess() {
        return this.parser.isRandomAccess();
    }

    public Object[] getControls() {
        return this.parser.getControls();
    }

    public Object getControl(String s) {
        return this.parser.getControl(s);
    }

    public Demultiplexer getDemultiplexer() {
        return this.parser;
    }

    public void setFormat(Connector connector, Format format) {
    }

    public void process() {
    }

    public long getBitsRead() {
        return this.bitsRead;
    }

    public void resetBitsRead() {
        this.bitsRead = 0L;
    }

    boolean readHasBlocked() {
        if (this.loops == null) {
            return false;
        }
        int i = 0;
        while (i < this.loops.length) {
            if (this.loops[i] != null && this.loops[i].readBlocked) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void checkLatency() {
        if (this.latencyTrack > -1) {
            if (this.tracks[this.latencyTrack].isEnabled() && this.loops[this.latencyTrack] != null) {
                this.loops[this.latencyTrack].checkLatency = true;
                return;
            }
            this.latencyTrack = -1;
        }
        int i = 0;
        while (i < this.tracks.length) {
            if (this.tracks[i].isEnabled()) {
                this.latencyTrack = i;
                if (this.tracks[i].getFormat() instanceof VideoFormat) break;
            }
            ++i;
        }
        if (this.latencyTrack > -1 && this.loops[this.latencyTrack] != null) {
            this.loops[this.latencyTrack].checkLatency = true;
        }
    }

    protected boolean checkAllPaused() {
        int i = 0;
        while (i < this.loops.length) {
            if (this.tracks[i].isEnabled() && this.loops[i] != null && !this.loops[i].isPaused()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

