# Property2\[T1: T1, T2: T2\]
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-101)</span>
```pony
trait ref Property2[T1: T1, T2: T2] is
  Property1[(T1 , T2)] ref
```

#### Implements

* [Property1](pony_check-Property1.md)\[(T1 , T2)\] ref

---

## Public Functions

### gen1
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-103)</span>


The Generator for the first argument to your `property2`.


```pony
fun box gen1()
: Generator[T1] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[T1\] box

---

### gen2
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-108)</span>


The Generator for the second argument to your `property2`.


```pony
fun box gen2()
: Generator[T2] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[T2\] box

---

### gen
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-113)</span>


```pony
fun box gen()
: Generator[(T1 , T2)] box
```

#### Returns

* [Generator](pony_check-Generator.md)\[(T1 , T2)\] box

---

### property
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-118)</span>


```pony
fun ref property(
  arg1: (T1 , T2),
  h: PropertyHelper val)
: None val ?
```
#### Parameters

*   arg1: (T1 , T2)
*   h: [PropertyHelper](pony_check-PropertyHelper.md) val

#### Returns

* [None](builtin-None.md) val ?

---

### property2
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-122)</span>


A method verifying that a certain property holds for all given
`arg1` and `arg2`
with the help of [PropertyHelper](pony_check-PropertyHelper.md) `h`.


```pony
fun ref property2(
  arg1: T1,
  arg2: T2,
  h: PropertyHelper val)
: None val ?
```
#### Parameters

*   arg1: T1
*   arg2: T2
*   h: [PropertyHelper](pony_check-PropertyHelper.md) val

#### Returns

* [None](builtin-None.md) val ?

---

### name
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-79)</span>


```pony
fun box name()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### params
<span class="source-link">[[Source]](src/pony_check/property.md#L-0-84)</span>


```pony
fun box params()
: PropertyParams val
```

#### Returns

* [PropertyParams](pony_check-PropertyParams.md) val

---

