/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.perl.inline.java.InlineJavaCastException;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaPerlObject;
import org.perl.inline.java.InlineJavaProtocol;
import org.perl.inline.java.InlineJavaServer;
import org.perl.inline.java.InlineJavaUtils;

class InlineJavaClass {
    private InlineJavaServer ijs;
    private InlineJavaProtocol ijp;
    private static HashMap<Class, String> class2jni_code;
    private static HashMap<Class, Class> class2wrapper;
    private static HashMap<String, Class> name2class;
    private static HashMap<Class, Boolean> numeric_classes;
    private static HashMap<Class, Boolean> double_classes;
    private static HashMap<Class, Boolean> string_classes;
    private static HashMap<Class, Boolean> char_classes;
    private static HashMap<Class, Boolean> bool_classes;

    InlineJavaClass(InlineJavaServer _ijs, InlineJavaProtocol _ijp) {
        this.ijs = _ijs;
        this.ijp = _ijp;
    }

    static Class ValidateClass(String name) throws InlineJavaException {
        Class pc = InlineJavaClass.FindType(name);
        if (pc != null) {
            return pc;
        }
        try {
            Class<?> c = Class.forName(name, true, InlineJavaServer.GetInstance().GetUserClassLoader());
            return c;
        }
        catch (ClassNotFoundException e) {
            throw new InlineJavaException("Class " + name + " not found");
        }
    }

    static String CleanClassName(String name) {
        int l;
        if (name != null && (l = name.length()) > 2 && name.charAt(0) == 'L' && name.charAt(l - 1) == ';') {
            name = name.substring(1, l - 1);
        }
        return name;
    }

    private static Class ValidateClassQuiet(String name) {
        try {
            return InlineJavaClass.ValidateClass(name);
        }
        catch (InlineJavaException ije) {
            return null;
        }
    }

    Object[] CastArguments(Class[] params, ArrayList args) throws InlineJavaException {
        Object[] ret = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Class p = params[i];
            InlineJavaUtils.debug(4, "arg " + String.valueOf(i) + " of signature is " + p.getName());
            ret[i] = this.CastArgument(p, (String)args.get(i));
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object CastArgument(Class p, String argument) throws InlineJavaException {
        Object ret = null;
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(argument, ":");
        int j = 0;
        while (st.hasMoreTokens()) {
            tokens.add(j, st.nextToken());
            ++j;
        }
        if (tokens.size() == 1) {
            tokens.add(1, "");
        }
        String type = (String)tokens.get(0);
        boolean num = InlineJavaClass.ClassIsNumeric(p);
        if (num || InlineJavaClass.ClassIsString(p)) {
            Class ap = p;
            if (ap == Number.class) {
                InlineJavaUtils.debug(4, "specializing java.lang.Number to java.lang.Double");
                ap = Double.class;
            } else if (ap.getName().equals("java.lang.CharSequence")) {
                InlineJavaUtils.debug(4, "specializing java.lang.CharSequence to java.lang.String");
                ap = String.class;
            }
            if (type.equals("undef")) {
                if (num) {
                    InlineJavaUtils.debug(4, "args is undef -> forcing to " + ap.getName() + " 0");
                    ret = this.ijp.CreateObject(ap, new Object[]{"0"}, new Class[]{String.class});
                    InlineJavaUtils.debug(4, " result is " + ret.toString());
                    return ret;
                }
                ret = null;
                InlineJavaUtils.debug(4, "args is undef -> forcing to " + ap.getName() + " " + ret);
                InlineJavaUtils.debug(4, " result is " + ret);
                return ret;
            }
            if (type.equals("scalar")) {
                String arg = this.ijp.Decode((String)tokens.get(1));
                InlineJavaUtils.debug(4, "args is scalar (" + arg + ") -> forcing to " + ap.getName());
                try {
                    ret = this.ijp.CreateObject(ap, new Object[]{arg}, new Class[]{String.class});
                    InlineJavaUtils.debug(4, " result is " + ret.toString());
                    return ret;
                }
                catch (NumberFormatException e) {
                    throw new InlineJavaCastException("Can't convert " + arg + " to " + ap.getName());
                }
            }
            if (!type.equals("double")) throw new InlineJavaCastException("Can't convert reference to " + p.getName());
            String arg = this.ijp.Decode((String)tokens.get(1));
            long l = 0L;
            char[] c = arg.toCharArray();
            int i = 0;
            while (true) {
                if (i >= 8) {
                    double d = Double.longBitsToDouble(l);
                    return d;
                }
                l += (long)c[i] << 8 * i;
                ++i;
            }
        }
        if (InlineJavaClass.ClassIsBool(p)) {
            if (type.equals("undef")) {
                InlineJavaUtils.debug(4, "args is undef -> forcing to bool false");
                ret = Boolean.FALSE;
                InlineJavaUtils.debug(4, " result is " + ret.toString());
                return ret;
            }
            if (!type.equals("scalar")) throw new InlineJavaCastException("Can't convert reference to " + p.getName());
            String arg = this.ijp.Decode((String)tokens.get(1));
            InlineJavaUtils.debug(4, "args is scalar (" + arg + ") -> forcing to bool");
            arg = arg.equals("") || arg.equals("0") ? "false" : "true";
            ret = Boolean.valueOf(arg);
            InlineJavaUtils.debug(4, " result is " + ret.toString());
            return ret;
        }
        if (InlineJavaClass.ClassIsChar(p)) {
            if (type.equals("undef")) {
                InlineJavaUtils.debug(4, "args is undef -> forcing to char '\u0000'");
                ret = Character.valueOf('\u0000');
                InlineJavaUtils.debug(4, " result is " + ret.toString());
                return ret;
            }
            if (!type.equals("scalar")) throw new InlineJavaCastException("Can't convert reference to " + p.getName());
            String arg = this.ijp.Decode((String)tokens.get(1));
            InlineJavaUtils.debug(4, "args is scalar -> forcing to char");
            char c = '\u0000';
            if (arg.length() == 1) {
                c = arg.toCharArray()[0];
            } else if (arg.length() > 1) {
                throw new InlineJavaCastException("Can't convert " + arg + " to " + p.getName());
            }
            ret = Character.valueOf(c);
            InlineJavaUtils.debug(4, " result is " + ret.toString());
            return ret;
        }
        InlineJavaUtils.debug(4, "class " + p.getName() + " is reference");
        if (type.equals("undef")) {
            InlineJavaUtils.debug(4, "args is undef -> forcing to null");
            return null;
        }
        if (type.equals("scalar")) {
            if (p != Object.class) throw new InlineJavaCastException("Can't convert primitive type to " + p.getName());
            String arg = this.ijp.Decode((String)tokens.get(1));
            return arg;
        }
        if (type.equals("java_object")) {
            InlineJavaUtils.debug(4, "class " + p.getName() + " is reference");
            String c_name = (String)tokens.get(1);
            String objid = (String)tokens.get(2);
            Class c = InlineJavaClass.ValidateClass(c_name);
            if (InlineJavaClass.DoesExtend(c, p) <= -1) throw new InlineJavaCastException("Can't cast a " + c.getName() + " to a " + p.getName());
            InlineJavaUtils.debug(4, " " + c.getName() + " is a kind of " + p.getName());
            int id = Integer.parseInt(objid);
            Object o = this.ijs.GetObject(id);
            return o;
        }
        InlineJavaUtils.debug(4, "class " + p.getName() + " is reference");
        String pkg = (String)tokens.get(1);
        pkg = pkg.replace('/', ':');
        String objid = (String)tokens.get(2);
        if (InlineJavaClass.DoesExtend(p, InlineJavaPerlObject.class) <= -1) throw new InlineJavaCastException("Can't cast a Perl object to a " + p.getName());
        InlineJavaUtils.debug(4, " Perl object is a kind of " + p.getName());
        int id = Integer.parseInt(objid);
        return new InlineJavaPerlObject(pkg, id);
    }

    static int DoesExtend(Class a, Class b) {
        return InlineJavaClass.DoesExtend(a, b, 0);
    }

    static int DoesExtend(Class a, Class b, int level) {
        InlineJavaUtils.debug(4, "checking if " + a.getName() + " extends " + b.getName());
        if (a == b) {
            return level;
        }
        Class parent = a.getSuperclass();
        if (parent != null) {
            InlineJavaUtils.debug(4, " parent is " + parent.getName());
            int ret = InlineJavaClass.DoesExtend(parent, b, level + 1);
            if (ret != -1) {
                return ret;
            }
        }
        Class<?>[] inter = a.getInterfaces();
        for (int i = 0; i < inter.length; ++i) {
            InlineJavaUtils.debug(4, " interface is " + inter[i].getName());
            int ret = InlineJavaClass.DoesExtend(inter[i], b, level + 1);
            if (ret == -1) continue;
            return ret;
        }
        return -1;
    }

    static Class FindWrapper(Class p) {
        Class w = class2wrapper.get(p);
        if (w == null) {
            w = p;
        }
        return w;
    }

    static Class FindType(String name) {
        return name2class.get(name);
    }

    static String FindJNICode(Class p) {
        if (!Object.class.isAssignableFrom(p)) {
            return class2jni_code.get(p);
        }
        String name = p.getName().replace('.', '/');
        if (p.isArray()) {
            return name;
        }
        return "L" + name + ";";
    }

    static boolean ClassIsPrimitive(Class p) {
        String name = p.getName();
        if (InlineJavaClass.ClassIsNumeric(p) || InlineJavaClass.ClassIsString(p) || InlineJavaClass.ClassIsChar(p) || InlineJavaClass.ClassIsBool(p)) {
            InlineJavaUtils.debug(4, "class " + name + " is primitive");
            return true;
        }
        return false;
    }

    static boolean ClassIsNumeric(Class p) {
        return numeric_classes.get(p) != null;
    }

    static boolean ClassIsDouble(Class p) {
        return double_classes.get(p) != null;
    }

    static boolean ClassIsString(Class p) {
        return string_classes.get(p) != null;
    }

    static boolean ClassIsChar(Class p) {
        return char_classes.get(p) != null;
    }

    static boolean ClassIsBool(Class p) {
        return bool_classes.get(p) != null;
    }

    static boolean ClassIsReference(Class p) {
        String name = p.getName();
        if (InlineJavaClass.ClassIsPrimitive(p)) {
            return false;
        }
        InlineJavaUtils.debug(4, "class " + name + " is reference");
        return true;
    }

    static boolean ClassIsArray(Class p) {
        String name = p.getName();
        if (name.startsWith("[") && InlineJavaClass.ClassIsReference(p)) {
            InlineJavaUtils.debug(4, "class " + name + " is array");
            return true;
        }
        return false;
    }

    static boolean ClassIsPublic(Class p) {
        int pub = p.getModifiers() & 1;
        return pub != 0;
    }

    static boolean ClassIsHandle(Class p) {
        return InlineJavaClass.ClassIsReadHandle(p) || InlineJavaClass.ClassIsWriteHandle(p);
    }

    static boolean ClassIsReadHandle(Class p) {
        return Reader.class.isAssignableFrom(p) || InputStream.class.isAssignableFrom(p);
    }

    static boolean ClassIsWriteHandle(Class p) {
        return Writer.class.isAssignableFrom(p) || OutputStream.class.isAssignableFrom(p);
    }

    static {
        int i;
        int i2;
        class2jni_code = new HashMap();
        class2jni_code.put(Byte.TYPE, "B");
        class2jni_code.put(Short.TYPE, "S");
        class2jni_code.put(Integer.TYPE, "I");
        class2jni_code.put(Long.TYPE, "J");
        class2jni_code.put(Float.TYPE, "F");
        class2jni_code.put(Double.TYPE, "D");
        class2jni_code.put(Boolean.TYPE, "Z");
        class2jni_code.put(Character.TYPE, "C");
        class2jni_code.put(Void.TYPE, "V");
        class2wrapper = new HashMap();
        class2wrapper.put(Byte.TYPE, Byte.class);
        class2wrapper.put(Short.TYPE, Short.class);
        class2wrapper.put(Integer.TYPE, Integer.class);
        class2wrapper.put(Long.TYPE, Long.class);
        class2wrapper.put(Float.TYPE, Float.class);
        class2wrapper.put(Double.TYPE, Double.class);
        class2wrapper.put(Boolean.TYPE, Boolean.class);
        class2wrapper.put(Character.TYPE, Character.class);
        class2wrapper.put(Void.TYPE, Void.class);
        name2class = new HashMap();
        name2class.put("byte", Byte.TYPE);
        name2class.put("short", Short.TYPE);
        name2class.put("int", Integer.TYPE);
        name2class.put("long", Long.TYPE);
        name2class.put("float", Float.TYPE);
        name2class.put("double", Double.TYPE);
        name2class.put("boolean", Boolean.TYPE);
        name2class.put("char", Character.TYPE);
        name2class.put("void", Void.TYPE);
        name2class.put("B", Byte.TYPE);
        name2class.put("S", Short.TYPE);
        name2class.put("I", Integer.TYPE);
        name2class.put("J", Long.TYPE);
        name2class.put("F", Float.TYPE);
        name2class.put("D", Double.TYPE);
        name2class.put("Z", Boolean.TYPE);
        name2class.put("C", Character.TYPE);
        name2class.put("V", Void.TYPE);
        numeric_classes = new HashMap();
        Class[] list = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Number.class, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        for (i2 = 0; i2 < list.length; ++i2) {
            numeric_classes.put(list[i2], Boolean.TRUE);
        }
        double_classes = new HashMap();
        list = new Class[]{Double.class, Double.TYPE};
        for (i2 = 0; i2 < list.length; ++i2) {
            double_classes.put(list[i2], Boolean.TRUE);
        }
        string_classes = new HashMap();
        Class csq = InlineJavaClass.ValidateClassQuiet("java.lang.CharSequence");
        Class[] list2 = new Class[]{String.class, StringBuffer.class, csq};
        for (int i3 = 0; i3 < list2.length; ++i3) {
            string_classes.put(list2[i3], Boolean.TRUE);
        }
        char_classes = new HashMap();
        list = new Class[]{Character.class, Character.TYPE};
        for (i = 0; i < list.length; ++i) {
            char_classes.put(list[i], Boolean.TRUE);
        }
        bool_classes = new HashMap();
        list = new Class[]{Boolean.class, Boolean.TYPE};
        for (i = 0; i < list.length; ++i) {
            bool_classes.put(list[i], Boolean.TRUE);
        }
    }
}

