"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElementAttrs = getElementAttrs;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
function getElementAttrs(fileName, tagName) {
    const { typescript: ts, language, languageService } = this;
    const sourceScript = language.scripts.get(fileName);
    const root = sourceScript?.generated?.root;
    if (!sourceScript?.generated || !(root instanceof language_core_1.VueVirtualCode)) {
        return [];
    }
    const program = languageService.getProgram();
    const checker = program.getTypeChecker();
    const elements = (0, utils_1.getVariableType)(ts, languageService, root, '__VLS_elements');
    if (!elements) {
        return [];
    }
    const elementType = elements.type.getProperty(tagName);
    if (!elementType) {
        return [];
    }
    const attrs = checker.getTypeOfSymbol(elementType).getProperties();
    return attrs.map(c => c.name);
}
//# sourceMappingURL=getElementAttrs.js.map