"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const utils_1 = require("../utils");
function create({ getDocumentHighlights }) {
    return {
        name: 'vue-document-highlights',
        capabilities: {
            documentHighlightProvider: true,
        },
        create(context) {
            return {
                async provideDocumentHighlights(document, position) {
                    const info = (0, utils_1.getEmbeddedInfo)(context, document, 'main');
                    if (!info) {
                        return;
                    }
                    const { root } = info;
                    const result = await getDocumentHighlights(root.fileName, document.offsetAt(position));
                    return result
                        ?.filter(({ fileName }) => fileName === root.fileName)
                        .flatMap(({ highlightSpans }) => highlightSpans)
                        .map(({ textSpan, kind }) => ({
                        range: {
                            start: document.positionAt(textSpan.start),
                            end: document.positionAt(textSpan.start + textSpan.length),
                        },
                        kind: kind === 'reference'
                            ? 2
                            : kind === 'writtenReference'
                                ? 3
                                : 1,
                    }));
                },
            };
        },
    };
}
//# sourceMappingURL=vue-document-highlights.js.map