import type ts from 'typescript/lib/tsserverlibrary';
import { SvelteSnapshot } from './svelte-snapshots';
type _ts = typeof ts;
export declare function isSvelteFilePath(filePath: string): boolean;
export declare function isVirtualSvelteFilePath(filePath: string): boolean;
export declare function toRealSvelteFilePath(filePath: string): string;
export declare function toVirtualSvelteFilePath(svelteFilePath: string): string;
export declare function ensureRealSvelteFilePath(filePath: string): string;
export declare function isNotNullOrUndefined<T>(val: T | undefined | null): val is T;
/**
 * Checks if this a section that should be completely ignored
 * because it's purely generated.
 */
export declare function isInGeneratedCode(text: string, start: number, end: number): boolean;
/**
 * Checks that this isn't a text span that should be completely ignored
 * because it's purely generated.
 */
export declare function isNoTextSpanInGeneratedCode(text: string, span: ts.TextSpan): boolean;
/**
 * Replace all occurrences of a string within an object with another string,
 */
export declare function replaceDeep<T extends Record<string, any>>(obj: T, searchStr: string | RegExp, replacementStr: string): T;
export declare function getConfigPathForProject(project: ts.server.Project): ts.server.NormalizedPath;
export declare function isStoreVariableIn$storeDeclaration(text: string, varStart: number): boolean;
export declare function get$storeOffsetOf$storeDeclaration(text: string, storePosition: number): number;
type NodeTypePredicate<T extends ts.Node> = (node: ts.Node) => node is T;
/**
 * Finds node exactly matching span {start, length}.
 */
export declare function findNodeAtSpan<T extends ts.Node>(node: ts.Node, span: {
    start: number;
    length: number;
}, predicate?: NodeTypePredicate<T>): T | void;
/**
 * Finds node somewhere at position.
 */
export declare function findNodeAtPosition<T extends ts.Node>(node: ts.Node, pos: number, predicate?: NodeTypePredicate<T>): T | void;
/**
 * True if is `export const/let/function`
 */
export declare function isTopLevelExport(ts: _ts, node: ts.Node, source: ts.SourceFile): boolean;
export declare function isGeneratedSvelteComponentName(className: string): boolean;
export declare function offsetOfGeneratedComponentExport(snapshot: SvelteSnapshot): number;
export declare function gatherDescendants<T extends ts.Node>(node: ts.Node, predicate: NodeTypePredicate<T>, dest?: T[]): T[];
export declare function findIdentifier(ts: _ts, node: ts.Node): ts.Identifier | undefined;
export declare function getProjectDirectory(project: ts.server.Project): string | undefined;
export declare function hasNodeModule(startPath: string, module: string): string | boolean;
export declare function isSvelteProject(project: ts.server.Project): string | boolean;
export declare function importSvelteCompiler(fromPath: string | undefined): typeof import('svelte/compiler') | undefined;
export {};
