/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ProcessOutput {
    private final byte[] data;

    public ProcessOutput(byte[] data2) {
        this.data = data2;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public String getString() {
        return new String(this.getBytes());
    }

    public String getUTF8() {
        return this.getString("UTF-8");
    }

    public String getString(String charset) {
        try {
            return new String(this.getBytes(), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public List<String> getLines() {
        return ProcessOutput.getLinesFrom(this.getString());
    }

    public List<String> getLinesAsUTF8() {
        return ProcessOutput.getLinesFrom(this.getUTF8());
    }

    public List<String> getLines(String charset) {
        return ProcessOutput.getLinesFrom(this.getString(charset));
    }

    static List<String> getLinesFrom(String output2) {
        ArrayList<String> result2 = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(output2, "\n\r");
        while (st.hasMoreTokens()) {
            result2.add(st.nextToken());
        }
        return result2;
    }
}

