/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.TeXFontFamily;
import com.dickimawbooks.texparserlib.TeXFontShape;
import com.dickimawbooks.texparserlib.TeXFontWeight;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.primitives.TeXFontDeclaration;
import java.io.IOException;

public class TeXFontWeightDeclaration
extends TeXFontDeclaration {
    private TeXFontWeight weight;
    private TeXFontWeight orgWeight;
    private TeXFontFamily orgFamily;
    private TeXFontShape orgShape;

    public TeXFontWeightDeclaration(String string, int n) {
        super(string);
        this.orgWeight = TeXFontWeight.INHERIT;
        this.orgFamily = TeXFontFamily.INHERIT;
        this.orgShape = TeXFontShape.INHERIT;
        switch (n) {
            case -1: {
                this.weight = TeXFontWeight.INHERIT;
                break;
            }
            case 0: {
                this.weight = TeXFontWeight.MD;
                break;
            }
            case 1: {
                this.weight = TeXFontWeight.BF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid font weightD " + n);
            }
        }
    }

    public TeXFontWeightDeclaration(String string, TeXFontWeight teXFontWeight) {
        super(string);
        this.weight = teXFontWeight;
        this.orgWeight = TeXFontWeight.INHERIT;
        this.orgFamily = TeXFontFamily.INHERIT;
        this.orgShape = TeXFontShape.INHERIT;
    }

    @Override
    public Object clone() {
        return new TeXFontWeightDeclaration(this.getName(), this.weight);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgWeight = teXSettings.getCurrentFontWeight();
        this.orgShape = teXSettings.getCurrentFontShape();
        this.orgFamily = teXSettings.getCurrentFontFamily();
        teXSettings.setFontWeight(this.weight);
        teXSettings.setFontShape(TeXFontShape.UP);
        teXSettings.setFontFamily(TeXFontFamily.RM);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setFontWeight(this.orgWeight);
        teXSettings.setFontShape(this.orgShape);
        teXSettings.setFontFamily(this.orgFamily);
    }
}

