import ts from 'typescript';
import { Position } from 'vscode-languageserver';
import { Document } from '../../../lib/documents';
import { ComponentInfoProvider } from '../ComponentInfoProvider';
import { DocumentSnapshot, SvelteDocumentSnapshot } from '../DocumentSnapshot';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
import { LSConfig } from '../../../ls-config';
import { LanguageServiceContainer } from '../service';
type NodeTypePredicate<T extends ts.Node> = (node: ts.Node) => node is T;
/**
 * If the given original position is within a Svelte starting tag,
 * return the snapshot of that component.
 */
export declare function getComponentAtPosition(lang: ts.LanguageService, doc: Document, tsDoc: SvelteDocumentSnapshot, originalPosition: Position): ComponentInfoProvider | null;
export declare function isComponentAtPosition(doc: Document, tsDoc: SvelteDocumentSnapshot, originalPosition: Position): boolean;
export declare const IGNORE_START_COMMENT = "/*\u03A9ignore_start\u03A9*/";
export declare const IGNORE_END_COMMENT = "/*\u03A9ignore_end\u03A9*/";
export declare const IGNORE_POSITION_COMMENT = "/*\u03A9ignore_position\u03A9*/";
/**
 * Surrounds given string with a start/end comment which marks it
 * to be ignored by tooling.
 */
export declare function surroundWithIgnoreComments(str: string): string;
/**
 * Checks if this a section that should be completely ignored
 * because it's purely generated.
 */
export declare function isInGeneratedCode(text: string, start: number, end?: number): boolean;
export declare function startsWithIgnoredPosition(text: string, offset: number): boolean;
/**
 * Checks if this is a text span that is inside svelte2tsx-generated code
 * (has no mapping to the original)
 */
export declare function isTextSpanInGeneratedCode(text: string, span: ts.TextSpan): boolean;
export declare function isPartOfImportStatement(text: string, position: Position): boolean;
export declare function isStoreVariableIn$storeDeclaration(text: string, varStart: number): boolean;
export declare function get$storeOffsetOf$storeDeclaration(text: string, storePosition: number): number;
export declare function is$storeVariableIn$storeDeclaration(text: string, varStart: number): boolean;
export declare function getStoreOffsetOf$storeDeclaration(text: string, $storeVarStart: number): number;
export declare class SnapshotMap {
    private resolver;
    private sourceLs;
    private map;
    constructor(resolver: LSAndTSDocResolver, sourceLs: LanguageServiceContainer);
    set(fileName: string, snapshot: DocumentSnapshot): void;
    get(fileName: string): DocumentSnapshot | undefined;
    retrieve(fileName: string): Promise<DocumentSnapshot>;
}
export declare function isAfterSvelte2TsxPropsReturn(text: string, end: number): true | undefined;
export declare function findContainingNode<T extends ts.Node>(node: ts.Node, textSpan: ts.TextSpan, predicate: (node: ts.Node) => node is T): T | undefined;
export declare function findClosestContainingNode<T extends ts.Node>(node: ts.Node, textSpan: ts.TextSpan, predicate: (node: ts.Node) => node is T): T | undefined;
/**
 * Finds node exactly matching span {start, length}.
 */
export declare function findNodeAtSpan<T extends ts.Node>(node: ts.Node, span: {
    start: number;
    length: number;
}, predicate?: NodeTypePredicate<T>): T | void;
export declare const isReactiveStatement: (node: ts.Node | undefined | void | null) => node is ts.LabeledStatement;
export declare function findRenderFunction(sourceFile: ts.SourceFile): (ts.FunctionDeclaration & {
    name: ts.Identifier;
}) | undefined;
export declare const isInReactiveStatement: (node: ts.Node) => boolean;
export declare function gatherDescendants<T extends ts.Node>(node: ts.Node, predicate: NodeTypePredicate<T>, dest?: T[]): T[];
export declare const gatherIdentifiers: (node: ts.Node) => ts.Identifier[];
export declare function isKitTypePath(path?: string): boolean;
export declare function getFormatCodeBasis(formatCodeSetting: ts.FormatCodeSettings): FormatCodeBasis;
export interface FormatCodeBasis {
    baseIndent: string;
    indent: string;
    semi: string;
    newLine: string;
}
/**
 * https://github.com/microsoft/TypeScript/blob/00dc0b6674eef3fbb3abb86f9d71705b11134446/src/services/utilities.ts#L2452
 */
export declare function getQuotePreference(sourceFile: ts.SourceFile, preferences: ts.UserPreferences): '"' | "'";
export declare function findChildOfKind(node: ts.Node, kind: ts.SyntaxKind): ts.Node | undefined;
export declare function getNewScriptStartTag(lsConfig: Readonly<LSConfig>): string;
export {};
