from .. import Provider as PersonProvider


class Provider(PersonProvider):
    formats_female = ("{{last_name}} {{first_name_female}}",)

    formats_male = ("{{last_name}} {{first_name_male}}",)

    formats = formats_male + formats_female

    # Source: https://studentsoftheworld.info/penpals/stats_fr.php?Pays=ALG
    # Last checked: 2025-09-27
    first_names_male = (
        "Abdelatif",
        "Abdelkader",
        "Abderaouf",
        "Abderrahmane",
        "Adam",
        "Adel",
        "Ahmed",
        "Akram",
        "Aladin",
        "Ali",
        "Amine",
        "Amir",
        "Anis",
        "Arezki",
        "Aymen",
        "Ayoub",
        "Chabane",
        "Cherif",
        "Djamel",
        "Fares",
        "Farid",
        "Farouk",
        "Fatteh",
        "Ferhat",
        "Fodil",
        "Ghilas",
        "Hamid",
        "Hamza",
        "Hocine",
        "Houcine",
        "Ibrahim",
        "Ilyes",
        "Kada",
        "Khaled",
        "Khalil",
        "Lamine",
        "Lotfi",
        "Malik",
        "Massinissa",
        "Mehdi",
        "Mohamed",
        "Mohand",
        "Mohammed",
        "Mouloud",
        "Mounir",
        "Mourad",
        "Moussa",
        "Mustapha",
        "Nacer",
        "Nadir",
        "Nassim",
        "Nazim",
        "Omar",
        "Oussama",
        "Ouanes",
        "Rabah",
        "Rachid",
        "Ramzi",
        "Riad",
        "Rida",
        "Rochdi",
        "Saad",
        "Said",
        "Salah",
        "Salim",
        "Sami",
        "Samir",
        "Samy",
        "Sofiane",
        "Soufiane",
        "Taha",
        "Walid",
        "Wassim",
        "Yacine",
        "Yahia",
        "Yanis",
        "Yasser",
        "Youba",
        "Youcef",
        "Younes",
        "Zakaria",
    )

    # Source: https://studentsoftheworld.info/penpals/stats_fr.php?Pays=ALG
    # Last checked: 2025-09-27
    first_names_female = (
        "Amani",
        "Amel",
        "Amina",
        "Amira",
        "Anaïs",
        "Anissa",
        "Asma",
        "Aya",
        "Bouchra",
        "Célia",
        "Céline",
        "Chanez",
        "Chiraz",
        "Dalia",
        "Dounia",
        "Farah",
        "Fatima",
        "Fella",
        "Feriel",
        "Fouzia",
        "Hadjer",
        "Hana",
        "Hania",
        "Hayat",
        "Houda",
        "Ikram",
        "Imene",
        "Ines",
        "Jasmine",
        "Kahina",
        "Katia",
        "Khadidja",
        "Leila",
        "Lila",
        "Lilia",
        "Lina",
        "Lisa",
        "Lydia",
        "Lyna",
        "Lynda",
        "Malak",
        "Manel",
        "Maria",
        "Marwa",
        "Maya",
        "Mélissa",
        "Meriem",
        "Mina",
        "Mira",
        "Myriam",
        "Nadia",
        "Narimane",
        "Nawal",
        "Nedjma",
        "Nesrine",
        "Nihad",
        "Nour",
        "Racha",
        "Rania",
        "Rim",
        "Rose",
        "Rym",
        "Ryma",
        "Sabrina",
        "Safia",
        "Sahra",
        "Salima",
        "Salma",
        "Samira",
        "Sara",
        "Sarah",
        "Selma",
        "Serine",
        "Sofia",
        "Sonia",
        "Sophia",
        "Souad",
        "Soumia",
        "Thinhinane",
        "Wafae",
        "Yasmine",
        "Yasmina",
        "Yousra",
        "Zina",
        "Zineb",
    )

    first_names = first_names_male + first_names_female

    # Source: https://fr.geneawiki.com/wiki/Noms_de_famille_alg%C3%A9riens
    # Last checked: 2025-09-27
    last_names = (
        "Abada",
        "Abbad",
        "Abbas",
        "Abbassi",
        "Abbes",
        "Abdi",
        "Abdelli",
        "Abdellaoui",
        "Abdelaziz",
        "Abdou",
        "Abed",
        "Abid",
        "Abou",
        "Abouda",
        "Aboukir",
        "Achour",
        "Achouri",
        "Adda",
        "Aissaoui",
        "Aissani",
        "Allal",
        "Allali",
        "Amara",
        "Amari",
        "Ameur",
        "Ammari",
        "Amrane",
        "Amrani",
        "Amrouche",
        "Amri",
        "Arab",
        "Aribi",
        "Attia",
        "Ayad",
        "Ayadi",
        "Azzouz",
        "Azizi",
        "Bacha",
        "Bahloul",
        "Bahri",
        "Bakhti",
        "Bakhouche",
        "Baghdadi",
        "Belarbi",
        "Belaid",
        "Belaidi",
        "Belbachir",
        "Belhadj",
        "Belkacem",
        "Belkacemi",
        "Belkadi",
        "Belkheir",
        "Belkhiri",
        "Benabdellah",
        "Benahmed",
        "Benali",
        "Benamar",
        "Benamara",
        "Benameur",
        "Benaicha",
        "Benaissa",
        "Benaouda",
        "Bencheikh",
        "Bensalem",
        "Bensaid",
        "Bensalah",
        "Benslimane",
        "Benyahia",
        "Benyamina",
        "Benmoussa",
        "Benyoucef",
        "Benziane",
        "Berkane",
        "Berkani",
        "Bettahar",
        "Bey",
        "Boubekeur",
        "Bouabdellah",
        "Bouafia",
        "Boualem",
        "Bouali",
        "Bouaziz",
        "Bouchama",
        "Bouchareb",
        "Boucetta",
        "Boudiaf",
        "Boudjemaa",
        "Boudraa",
        "Bouguerra",
        "Boukhari",
        "Boukhalfa",
        "Boukhatem",
        "Boumaza",
        "Boumediene",
        "Bounab",
        "Boussaid",
        "Boutaleb",
        "Bouziane",
        "Bouzid",
        "Bouzidi",
        "Brahimi",
        "Brahmi",
        "Chaib",
        "Chabane",
        "Charef",
        "Chaoui",
        "Chibani",
        "Chikh",
        "Chergui",
        "Cherif",
        "Cherifi",
        "Cheriet",
        "Cheikh",
        "Chellaoua",
        "Daoud",
        "Daoudi",
        "Dahmane",
        "Dahmani",
        "Derbal",
        "Derradji",
        "Derkaoui",
        "Derouiche",
        "Dib",
        "Diaf",
        "Dif",
        "Djebbar",
        "Djellal",
        "Djellouli",
        "Djoudi",
        "Fares",
        "Fellah",
        "Ferhat",
        "Filali",
        "Gacem",
        "Gasmi",
        "Ghazi",
        "Gharbi",
        "Gherbi",
        "Guessoum",
        "Guendouz",
        "Guerfi",
        "Hadjadj",
        "Hadji",
        "Haddad",
        "Haddouche",
        "Hachemi",
        "Hamel",
        "Hamadouche",
        "Hamadi",
        "Hamdani",
        "Hamdi",
        "Hamidi",
        "Hamlaoui",
        "Hammadi",
        "Hamoudi",
        "Hamza",
        "Hamzaoui",
        "Hassani",
        "Henni",
        "Hocine",
        "Houari",
        "Ikhlef",
        "Kaci",
        "Kaddour",
        "Kaddouri",
        "Kadi",
        "Kadri",
        "Kamel",
        "Kara",
        "Kebaili",
        "Kebir",
        "Khaldi",
        "Khaled",
        "Khelif",
        "Khelifa",
        "Khelifi",
        "Khelil",
        "Korichi",
        "Kouidri",
        "Laib",
        "Lakehal",
        "Lakhal",
        "Lakhdari",
        "Lamri",
        "Laouar",
        "Larbi",
        "Laribi",
        "Latreche",
        "Lahmar",
        "Lamri",
        "Laribi",
        "Latreche",
        "Lounis",
        "Loucif",
        "Madani",
        "Madi",
        "Mahmoudi",
        "Mahi",
        "Malki",
        "Malek",
        "Mansour",
        "Mansouri",
        "Maouche",
        "Makhlouf",
        "Makhloufi",
        "Mazouz",
        "Mazouzi",
        "Mebarki",
        "Mecheri",
        "Meftah",
        "Medjahed",
        "Meddah",
        "Meziane",
        "Meziani",
        "Mesbah",
        "Messaoudi",
        "Merabet",
        "Merah",
        "Merzougui",
        "Merzoug",
        "Mihoubi",
        "Miloudi",
        "Mimouni",
        "Mokadem",
        "Mokrane",
        "Mokrani",
        "Mokhtari",
        "Mohammedi",
        "Mostefaoui",
        "Morsli",
        "Moulay",
        "Moussa",
        "Moussaoui",
        "Nacer",
        "Naili",
        "Nasri",
        "Nedjar",
        "Nouar",
        "Noui",
        "Nouri",
        "Ouali",
        "Ouchene",
        "Otmani",
        "Rabhi",
        "Rachedi",
        "Rabia",
        "Rahmani",
        "Rahal",
        "Rahmouni",
        "Rahmoune",
        "Ramdani",
        "Rais",
        "Rezig",
        "Sabri",
        "Saci",
        "Saad",
        "Saadi",
        "Saidi",
        "Said",
        "Saidani",
        "Sahli",
        "Sahraoui",
        "Salem",
        "Salhi",
        "Salmi",
        "Salah",
        "Saoudi",
        "Sayah",
        "Seddiki",
        "Selami",
        "Senouci",
        "Slimani",
        "Smail",
        "Soudani",
        "Soltani",
        "Taibi",
        "Tabet",
        "Tahraoui",
        "Tahri",
        "Talbi",
        "Taleb",
        "Touati",
        "Touil",
        "Toumi",
        "Yahi",
        "Yahia",
        "Yahiaoui",
        "Yousfi",
        "Zaidi",
        "Zaoui",
        "Zeroual",
        "Zerrouki",
        "Ziane",
        "Ziani",
        "Zidane",
        "Zitouni",
        "Zouaoui",
    )
