/**
 * Copyright 2024 Google LLC.
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * THIS FILE IS AUTOGENERATED by cddlconv 0.1.5.
 * Run `node tools/generate-bidi-types.mjs` to regenerate.
 * @see https://github.com/w3c/webdriver-bidi/blob/master/index.bs
 */
// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-nocheck Some types may be circular.
import z from 'zod';
export var Bluetooth;
(function (Bluetooth) {
    Bluetooth.RequestDeviceSchema = z.lazy(() => z.string());
})(Bluetooth || (Bluetooth = {}));
(function (Bluetooth) {
    Bluetooth.RequestDeviceInfoSchema = z.lazy(() => z.object({
        id: Bluetooth.RequestDeviceSchema,
        name: z.union([z.string(), z.null()]),
    }));
})(Bluetooth || (Bluetooth = {}));
(function (Bluetooth) {
    Bluetooth.RequestDevicePromptSchema = z.lazy(() => z.string());
})(Bluetooth || (Bluetooth = {}));
(function (Bluetooth) {
    Bluetooth.HandleRequestDevicePromptSchema = z.lazy(() => z.object({
        method: z.literal('bluetooth.handleRequestDevicePrompt'),
        params: Bluetooth.HandleRequestDevicePromptParametersSchema,
    }));
})(Bluetooth || (Bluetooth = {}));
(function (Bluetooth) {
    Bluetooth.HandleRequestDevicePromptParametersSchema = z.lazy(() => z
        .object({
        context: z.string(),
        prompt: Bluetooth.RequestDevicePromptSchema,
    })
        .and(z.union([
        Bluetooth.HandleRequestDevicePromptAcceptParametersSchema,
        Bluetooth.HandleRequestDevicePromptCancelParametersSchema,
    ])));
})(Bluetooth || (Bluetooth = {}));
(function (Bluetooth) {
    Bluetooth.HandleRequestDevicePromptAcceptParametersSchema = z.lazy(() => z.object({
        accept: z.literal(true),
        device: Bluetooth.RequestDeviceSchema,
    }));
})(Bluetooth || (Bluetooth = {}));
(function (Bluetooth) {
    Bluetooth.HandleRequestDevicePromptCancelParametersSchema = z.lazy(() => z.object({
        accept: z.literal(false),
    }));
})(Bluetooth || (Bluetooth = {}));
(function (Bluetooth) {
    Bluetooth.RequestDevicePromptUpdatedSchema = z.lazy(() => z.object({
        method: z.literal('bluetooth.requestDevicePromptUpdated'),
        params: Bluetooth.RequestDevicePromptUpdatedParametersSchema,
    }));
})(Bluetooth || (Bluetooth = {}));
(function (Bluetooth) {
    Bluetooth.RequestDevicePromptUpdatedParametersSchema = z.lazy(() => z.object({
        context: z.string(),
        prompt: Bluetooth.RequestDevicePromptSchema,
        devices: z.array(Bluetooth.RequestDeviceInfoSchema),
    }));
})(Bluetooth || (Bluetooth = {}));
//# sourceMappingURL=webdriver-bidi-bluetooth.js.map