/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import liquibase.exception.CustomChangeException;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate26_5_0_OrgTableCharset
extends CustomKeycloakTask {
    @Override
    protected boolean isApplicable() throws CustomChangeException {
        try {
            String correctedTableName = this.database.correctObjectName("ORG", Table.class);
            return SnapshotGeneratorFactory.getInstance().has((DatabaseObject)new Table().setName(correctedTableName), this.database);
        }
        catch (Exception e) {
            throw new CustomChangeException("Failed to check for existence of ORG table", (Throwable)e);
        }
    }

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        String orgTableName = this.getTableName("ORG");
        this.statements.add(new RawSqlStatement("ALTER TABLE " + orgTableName + " MODIFY ID VARCHAR(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL"));
        this.confirmationMessage.append("Updated ORG.ID column charset to utf8mb3 for foreign key compatibility");
    }

    @Override
    protected String getTaskId() {
        return "Update ORG table charset and collation";
    }
}

