/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.keycloak.common.util.Base64Url;
import org.keycloak.representations.account.AccountLinkUriRepresentation;
import org.keycloak.services.Urls;

public class BrokerUtil {
    public static AccountLinkUriRepresentation createClientInitiatedLinkURI(String clientId, String redirectUri, String identityProviderAlias, String realmName, String userSessionId, URI serverBaseUri) {
        try {
            String nonce = UUID.randomUUID().toString();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String input = nonce + userSessionId + clientId + identityProviderAlias;
            byte[] check = md.digest(input.getBytes(StandardCharsets.UTF_8));
            String hash = Base64Url.encode((byte[])check);
            URI linkUri = Urls.identityProviderLinkRequest(serverBaseUri, identityProviderAlias, realmName);
            linkUri = UriBuilder.fromUri((URI)linkUri).queryParam("nonce", new Object[]{nonce}).queryParam("hash", new Object[]{hash}).queryParam("client_id", new Object[]{clientId}).queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[0]);
            AccountLinkUriRepresentation rep = new AccountLinkUriRepresentation();
            rep.setAccountLinkUri(linkUri);
            rep.setHash(hash);
            rep.setNonce(nonce);
            return rep;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }
}

