/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.validate.ValidatorConfig;
import org.keycloak.validate.validators.AbstractNumberValidator;

public class IntegerValidator
extends AbstractNumberValidator
implements ConfiguredProvider {
    public static final String ID = "integer";
    public static final IntegerValidator INSTANCE = new IntegerValidator();

    public IntegerValidator() {
    }

    public IntegerValidator(ValidatorConfig config) {
        super(config);
    }

    @Override
    protected Number convert(Object value, ValidatorConfig config) {
        if (value instanceof Integer || value instanceof Long) {
            return (Number)value;
        }
        return Long.valueOf(value.toString());
    }

    public String getId() {
        return ID;
    }

    @Override
    protected Number getMinMaxConfig(ValidatorConfig config, String key) {
        return config != null ? config.getLong(key) : null;
    }

    @Override
    protected boolean isFirstGreaterThanToSecond(Number n1, Number n2) {
        return n1.longValue() > n2.longValue();
    }

    public String getHelpText() {
        return "Validator to check Integer number format and optionally min and max values";
    }
}

