/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import java.util.Map;
import org.hibernate.QueryException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.SQLLoadable;

public class SQLQueryParser {
    private final SessionFactoryImplementor factory;
    private final String originalQueryString;
    private final ParserContext context;
    private long aliasesFound;

    public SQLQueryParser(String queryString, ParserContext context, SessionFactoryImplementor factory) {
        this.originalQueryString = queryString;
        this.context = context;
        this.factory = factory;
    }

    public boolean queryHasAliases() {
        return this.aliasesFound > 0L;
    }

    protected String getOriginalQueryString() {
        return this.originalQueryString;
    }

    public String process() {
        return this.substituteBrackets(this.originalQueryString);
    }

    protected String substituteBrackets(String sqlQuery) throws QueryException {
        String trimmed = sqlQuery.trim();
        if (trimmed.startsWith("{") && trimmed.endsWith("}")) {
            return sqlQuery;
        }
        StringBuilder result = new StringBuilder(sqlQuery.length() + 20);
        StringBuilder token = new StringBuilder();
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        boolean escaped = false;
        block6: for (int index = 0; index < sqlQuery.length(); ++index) {
            char ch = sqlQuery.charAt(index);
            switch (ch) {
                case '\'': {
                    if (escaped) {
                        token.append(ch);
                        continue block6;
                    }
                    if (!doubleQuoted) {
                        singleQuoted = !singleQuoted;
                    }
                    result.append(ch);
                    continue block6;
                }
                case '\"': {
                    if (escaped) {
                        token.append(ch);
                        continue block6;
                    }
                    if (!singleQuoted) {
                        doubleQuoted = !doubleQuoted;
                    }
                    result.append(ch);
                    continue block6;
                }
                case '{': {
                    if (!singleQuoted && !doubleQuoted) {
                        escaped = true;
                        continue block6;
                    }
                    result.append(ch);
                    continue block6;
                }
                case '}': {
                    if (!singleQuoted && !doubleQuoted) {
                        escaped = false;
                        this.interpretToken(token.toString(), result);
                        token.setLength(0);
                        continue block6;
                    }
                    result.append(ch);
                    continue block6;
                }
                default: {
                    if (!escaped) {
                        result.append(ch);
                        continue block6;
                    }
                    token.append(ch);
                }
            }
        }
        return result.toString();
    }

    private void interpretToken(String token, StringBuilder result) {
        if (token.startsWith("h-")) {
            this.handlePlaceholder(token, result);
        } else if (this.context != null) {
            this.handleAliases(token, result);
        } else {
            result.append('{').append(token).append('}');
        }
    }

    private void handleAliases(String token, StringBuilder result) {
        int firstDot = token.indexOf(46);
        if (firstDot == -1) {
            if (this.context.isEntityAlias(token)) {
                result.append(token);
                ++this.aliasesFound;
            } else {
                result.append('{').append(token).append('}');
            }
        } else {
            String aliasName = token.substring(0, firstDot);
            if (this.context.isCollectionAlias(aliasName)) {
                String propertyName = token.substring(firstDot + 1);
                result.append(this.resolveCollectionProperties(aliasName, propertyName));
                ++this.aliasesFound;
            } else if (this.context.isEntityAlias(aliasName)) {
                String propertyName = token.substring(firstDot + 1);
                result.append(this.resolveProperties(aliasName, propertyName));
                ++this.aliasesFound;
            } else {
                result.append('{').append(token).append('}');
            }
        }
    }

    private void handlePlaceholder(String token, StringBuilder result) {
        SqlStringGenerationContext context = this.factory.getSqlStringGenerationContext();
        Identifier defaultCatalog = context.getDefaultCatalog();
        Identifier defaultSchema = context.getDefaultSchema();
        Dialect dialect = context.getDialect();
        switch (token) {
            case "h-domain": {
                if (defaultCatalog != null) {
                    result.append(defaultCatalog.render(dialect));
                    result.append(".");
                }
                if (defaultSchema == null) break;
                result.append(defaultSchema.render(dialect));
                result.append(".");
                break;
            }
            case "h-schema": {
                if (defaultSchema == null) break;
                result.append(defaultSchema.render(dialect));
                result.append(".");
                break;
            }
            case "h-catalog": {
                if (defaultCatalog == null) break;
                result.append(defaultCatalog.render(dialect));
                result.append(".");
                break;
            }
            default: {
                throw new QueryException("Unknown placeholder ", token);
            }
        }
    }

    private String resolveCollectionProperties(String aliasName, String propertyName) {
        Map<String, String[]> fieldResults = this.context.getPropertyResultsMap(aliasName);
        SQLLoadableCollection collectionPersister = this.context.getCollectionPersister(aliasName);
        String collectionSuffix = this.context.getCollectionSuffix(aliasName);
        switch (propertyName) {
            case "*": {
                if (!fieldResults.isEmpty()) {
                    throw new QueryException("Using return-property together with * syntax is not supported");
                }
                ++this.aliasesFound;
                return collectionPersister.selectFragment(aliasName, collectionSuffix) + ", " + this.resolveProperties(aliasName, propertyName);
            }
            case "element.*": {
                return this.resolveProperties(aliasName, "*");
            }
        }
        String[] columnAliases = fieldResults.get(propertyName);
        if (columnAliases == null) {
            columnAliases = collectionPersister.getCollectionPropertyColumnAliases(propertyName, collectionSuffix);
        }
        this.validate(aliasName, propertyName, columnAliases);
        ++this.aliasesFound;
        return columnAliases[0];
    }

    private String resolveProperties(String aliasName, String propertyName) {
        Map<String, String[]> fieldResults = this.context.getPropertyResultsMap(aliasName);
        SQLLoadable persister = this.context.getEntityPersister(aliasName);
        String suffix = this.context.getEntitySuffix(aliasName);
        if ("*".equals(propertyName)) {
            if (!fieldResults.isEmpty()) {
                throw new QueryException("Using return-property together with * syntax is not supported");
            }
            ++this.aliasesFound;
            return persister.selectFragment(aliasName, suffix);
        }
        String[] columnAliases = fieldResults.get(propertyName);
        if (columnAliases == null) {
            columnAliases = persister.getSubclassPropertyColumnAliases(propertyName, suffix);
        }
        this.validate(aliasName, propertyName, columnAliases);
        ++this.aliasesFound;
        return columnAliases[0];
    }

    private void validate(String aliasName, String propertyName, String[] columnAliases) {
        if (columnAliases == null || columnAliases.length == 0) {
            throw new QueryException("No column name found for property [" + propertyName + "] for alias [" + aliasName + "]", this.originalQueryString);
        }
        if (columnAliases.length != 1) {
            throw new QueryException("SQL queries only support properties mapped to a single column - property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.originalQueryString);
        }
    }

    public static interface ParserContext {
        public boolean isEntityAlias(String var1);

        public SQLLoadable getEntityPersister(String var1);

        public String getEntitySuffix(String var1);

        public boolean isCollectionAlias(String var1);

        public SQLLoadableCollection getCollectionPersister(String var1);

        public String getCollectionSuffix(String var1);

        public Map<String, String[]> getPropertyResultsMap(String var1);
    }
}

