/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.graph.entity.EntityInitializer;

public class SubselectFetch {
    private final @UnknownKeyFor @NonNull @Initialized QuerySpec loadingSqlAst;
    private final @UnknownKeyFor @NonNull @Initialized TableGroup ownerTableGroup;
    private final @UnknownKeyFor @NonNull @Initialized JdbcParametersList loadingJdbcParameters;
    private final @UnknownKeyFor @NonNull @Initialized JdbcParameterBindings loadingJdbcParameterBindings;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized EntityKey> resultingEntityKeys;
    private static final @UnknownKeyFor @NonNull @Initialized RegistrationHandler NO_OP_REG_HANDLER = new RegistrationHandler(){

        @Override
        public void addKey(EntityHolder holder) {
        }
    };

    public SubselectFetch(@UnknownKeyFor @NonNull @Initialized QuerySpec loadingSqlAst, @UnknownKeyFor @NonNull @Initialized TableGroup ownerTableGroup, @UnknownKeyFor @NonNull @Initialized JdbcParametersList loadingJdbcParameters, @UnknownKeyFor @NonNull @Initialized JdbcParameterBindings loadingJdbcParameterBindings, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized EntityKey> resultingEntityKeys) {
        this.loadingSqlAst = loadingSqlAst;
        this.ownerTableGroup = ownerTableGroup;
        this.loadingJdbcParameters = loadingJdbcParameters;
        this.loadingJdbcParameterBindings = loadingJdbcParameterBindings;
        this.resultingEntityKeys = resultingEntityKeys;
    }

    public @UnknownKeyFor @NonNull @Initialized JdbcParametersList getLoadingJdbcParameters() {
        return this.loadingJdbcParameters;
    }

    public @UnknownKeyFor @NonNull @Initialized QuerySpec getLoadingSqlAst() {
        return this.loadingSqlAst;
    }

    public @UnknownKeyFor @NonNull @Initialized TableGroup getOwnerTableGroup() {
        return this.ownerTableGroup;
    }

    public @UnknownKeyFor @NonNull @Initialized JdbcParameterBindings getLoadingJdbcParameterBindings() {
        return this.loadingJdbcParameterBindings;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized EntityKey> getResultingEntityKeys() {
        return this.resultingEntityKeys;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "SubselectFetch(" + String.valueOf(this.ownerTableGroup.getNavigablePath()) + ")";
    }

    public static @UnknownKeyFor @NonNull @Initialized RegistrationHandler createRegistrationHandler(@UnknownKeyFor @NonNull @Initialized BatchFetchQueue batchFetchQueue, @UnknownKeyFor @NonNull @Initialized SelectStatement sqlAst, @UnknownKeyFor @NonNull @Initialized TableGroup tableGroup, @UnknownKeyFor @NonNull @Initialized JdbcParametersList jdbcParameters, @UnknownKeyFor @NonNull @Initialized JdbcParameterBindings jdbcParameterBindings) {
        return new StandardRegistrationHandler(batchFetchQueue, sqlAst, tableGroup, jdbcParameters, jdbcParameterBindings);
    }

    public static @UnknownKeyFor @NonNull @Initialized RegistrationHandler createRegistrationHandler(@UnknownKeyFor @NonNull @Initialized BatchFetchQueue batchFetchQueue, @UnknownKeyFor @NonNull @Initialized SelectStatement sqlAst, @UnknownKeyFor @NonNull @Initialized JdbcParametersList jdbcParameters, @UnknownKeyFor @NonNull @Initialized JdbcParameterBindings jdbcParameterBindings) {
        List<TableGroup> roots = sqlAst.getQuerySpec().getFromClause().getRoots();
        if (roots.isEmpty()) {
            return NO_OP_REG_HANDLER;
        }
        return SubselectFetch.createRegistrationHandler(batchFetchQueue, sqlAst, roots.get(0), jdbcParameters, jdbcParameterBindings);
    }

    public static class StandardRegistrationHandler
    implements RegistrationHandler {
        private final @UnknownKeyFor @NonNull @Initialized BatchFetchQueue batchFetchQueue;
        private final @UnknownKeyFor @NonNull @Initialized SelectStatement loadingSqlAst;
        private final @UnknownKeyFor @NonNull @Initialized JdbcParametersList loadingJdbcParameters;
        private final @UnknownKeyFor @NonNull @Initialized JdbcParameterBindings loadingJdbcParameterBindings;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized NavigablePath, @UnknownKeyFor @NonNull @Initialized SubselectFetch> subselectFetches = new HashMap<NavigablePath, SubselectFetch>();

        private StandardRegistrationHandler(@UnknownKeyFor @NonNull @Initialized BatchFetchQueue batchFetchQueue, @UnknownKeyFor @NonNull @Initialized SelectStatement loadingSqlAst, @UnknownKeyFor @NonNull @Initialized TableGroup ownerTableGroup, @UnknownKeyFor @NonNull @Initialized JdbcParametersList loadingJdbcParameters, @UnknownKeyFor @NonNull @Initialized JdbcParameterBindings loadingJdbcParameterBindings) {
            this.batchFetchQueue = batchFetchQueue;
            this.loadingSqlAst = loadingSqlAst;
            this.loadingJdbcParameters = loadingJdbcParameters;
            this.loadingJdbcParameterBindings = loadingJdbcParameterBindings;
        }

        @Override
        public void addKey(@UnknownKeyFor @NonNull @Initialized EntityHolder holder) {
            if (this.batchFetchQueue.getSession().getLoadQueryInfluencers().hasSubselectLoadableCollections(holder.getDescriptor())) {
                EntityInitializer<?> entityInitializer = NullnessUtil.castNonNull(holder.getEntityInitializer());
                SubselectFetch subselectFetch = this.subselectFetches.computeIfAbsent(entityInitializer.getNavigablePath(), navigablePath -> new SubselectFetch(this.loadingSqlAst.getQuerySpec(), this.loadingSqlAst.getQuerySpec().getFromClause().findTableGroup(entityInitializer.getNavigablePath()), this.loadingJdbcParameters, this.loadingJdbcParameterBindings, new HashSet<EntityKey>()));
                subselectFetch.resultingEntityKeys.add(holder.getEntityKey());
                this.batchFetchQueue.addSubselect(holder.getEntityKey(), subselectFetch);
            }
        }
    }

    public static interface RegistrationHandler {
        public void addKey(@UnknownKeyFor @NonNull @Initialized EntityHolder var1);
    }
}

