/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.EntityNotFoundException;
import java.util.Locale;

public class EntityFilterException
extends EntityNotFoundException {
    private final String entityName;
    private final Object identifier;
    private final String role;

    public EntityFilterException(String entityName, Object identifier, String role) {
        super(String.format(Locale.ROOT, "Entity `%s` with identifier value `%s` is filtered for association `%s`", entityName, identifier, role));
        this.entityName = entityName;
        this.identifier = identifier;
        this.role = role;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public String getRole() {
        return this.role;
    }
}

