/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import twitter4j.APIResourceBase;
import twitter4j.Authorization;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.ObjectFactory;
import twitter4j.RateLimitStatusEvent;
import twitter4j.TwitterException;
import twitter4j.v1.Query;
import twitter4j.v1.QueryResult;
import twitter4j.v1.SearchResource;

class SearchResourceImpl
extends APIResourceBase
implements SearchResource {
    private static final HttpParameter WITH_TWITTER_USER_ID = new HttpParameter("with_twitter_user_id", "true");

    SearchResourceImpl(HttpClient http, ObjectFactory factory, String restBaseURL, Authorization auth, boolean mbeanEnabled, HttpParameter[] IMPLICIT_PARAMS, String IMPLICIT_PARAMS_STR, List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners, List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners) {
        super(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
    }

    @Override
    public QueryResult search(Query query) throws TwitterException {
        if (query.nextPageQuery != null) {
            return this.factory.createQueryResult(this.get(this.restBaseURL + "search/tweets.json" + query.nextPageQuery), query);
        }
        return this.factory.createQueryResult(this.get(this.restBaseURL + "search/tweets.json", SearchResourceImpl.asHttpParameterArray(query)), query);
    }

    static HttpParameter[] asHttpParameterArray(Query query) {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(12);
        SearchResourceImpl.appendParameter("q", query.query, params);
        SearchResourceImpl.appendParameter("lang", query.lang, params);
        SearchResourceImpl.appendParameter("locale", query.locale, params);
        SearchResourceImpl.appendParameter("max_id", query.maxId, params);
        SearchResourceImpl.appendParameter("count", query.count, params);
        SearchResourceImpl.appendParameter("since", query.since, params);
        SearchResourceImpl.appendParameter("since_id", query.sinceId, params);
        SearchResourceImpl.appendParameter("geocode", query.geocode, params);
        SearchResourceImpl.appendParameter("until", query.until, params);
        if (query.resultType != null) {
            params.add(new HttpParameter("result_type", query.resultType.name()));
        }
        params.add(WITH_TWITTER_USER_ID);
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private static void appendParameter(String name, String value, List<HttpParameter> params) {
        if (value != null) {
            params.add(new HttpParameter(name, value));
        }
    }

    private static void appendParameter(String name, long value, List<HttpParameter> params) {
        if (0L <= value) {
            params.add(new HttpParameter(name, String.valueOf(value)));
        }
    }
}

