/*
 * Decompiled with CFR 0.152.
 */
package org.codejive.properties;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.codejive.properties.Cursor;
import org.codejive.properties.PropertiesParser;

public class Properties
extends AbstractMap<String, String> {
    private final LinkedHashMap<String, String> values;
    private final List<PropertiesParser.Token> tokens;
    private final Properties defaults;

    public Properties() {
        this(null);
    }

    public Properties(Properties defaults) {
        this.defaults = defaults;
        this.values = new LinkedHashMap();
        this.tokens = new ArrayList<PropertiesParser.Token>();
    }

    private Properties(Properties defaults, List<PropertiesParser.Token> tokens) {
        this.defaults = defaults;
        this.values = new LinkedHashMap();
        this.tokens = tokens;
        this.rawEntrySet().forEach((? super T e) -> this.values.put(PropertiesParser.unescape((String)e.getKey()), PropertiesParser.unescape((String)e.getValue())));
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        if (this.defaults != null) {
            return this.defaults.getProperty(key, defaultValue);
        }
        return defaultValue;
    }

    public List<String> getPropertyComment(String key) {
        if (this.containsKey(key)) {
            return this.getComment(key);
        }
        if (this.defaults != null) {
            return this.defaults.getPropertyComment(key);
        }
        return Collections.emptyList();
    }

    public String setProperty(String key, String value, String ... comment) {
        return this.putCommented(key, value, comment);
    }

    public Enumeration<String> propertyNames() {
        return Collections.enumeration(this.stringPropertyNames());
    }

    public Set<String> stringPropertyNames() {
        return Collections.unmodifiableSet(this.flatten().keySet());
    }

    public void list(PrintStream out) {
        try {
            this.flatten().store(out, new String[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void list(PrintWriter out) {
        try {
            this.flatten().store(out, new String[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadFromXML(InputStream in) throws IOException {
        java.util.Properties p = new java.util.Properties();
        p.loadFromXML(in);
        p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.put(Objects.toString(key), Objects.toString(value))));
    }

    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.asJUProperties().storeToXML(os, comment);
    }

    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        this.asJUProperties().storeToXML(os, comment, encoding);
    }

    @Deprecated
    public Properties flatten() {
        return this.flattened();
    }

    public Properties flattened() {
        Properties result = new Properties();
        this.flatten(result);
        return result;
    }

    private void flatten(Properties target) {
        if (this.defaults != null) {
            this.defaults.flatten(target);
        }
        target.putAll(this);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new Iterator<Map.Entry<String, String>>(){
                    private final Iterator<Map.Entry<String, String>> iter;
                    private Map.Entry<String, String> currentEntry;
                    {
                        this.iter = Properties.this.values.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        this.currentEntry = this.iter.next();
                        return this.currentEntry;
                    }

                    @Override
                    public void remove() {
                        if (this.currentEntry != null) {
                            Properties.this.removeItem(this.currentEntry.getKey());
                        }
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return Properties.this.values.entrySet().size();
            }
        };
    }

    public Set<String> rawKeySet() {
        return this.tokens.stream().filter(t -> t.type == PropertiesParser.Type.KEY).map(PropertiesParser.Token::getRaw).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Collection<String> rawValues() {
        return Properties.combined(this.tokens).filter(ts -> ((PropertiesParser.Token)ts.get((int)0)).type == PropertiesParser.Type.KEY).map(ts -> ((PropertiesParser.Token)ts.get(2)).getRaw()).collect(Collectors.toList());
    }

    public Set<Map.Entry<String, String>> rawEntrySet() {
        return Properties.combined(this.tokens).filter(ts -> ((PropertiesParser.Token)ts.get((int)0)).type == PropertiesParser.Type.KEY).map(ts -> new AbstractMap.SimpleEntry<String, String>(((PropertiesParser.Token)ts.get(0)).getRaw(), ((PropertiesParser.Token)ts.get(2)).getRaw())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public String get(Object key) {
        return this.values.get(key);
    }

    public String getRaw(String rawKey) {
        Cursor pos = this.indexOf(PropertiesParser.unescape(rawKey));
        if (pos.hasToken()) {
            this.validate(pos.nextIf(PropertiesParser.Type.KEY), pos);
            this.validate(pos.nextIf(PropertiesParser.Type.SEPARATOR), pos);
            this.validate(pos.isType(PropertiesParser.Type.VALUE), pos);
            return pos.raw();
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        String rawValue = Properties.escapeValue(value);
        if (this.values.containsKey(key)) {
            this.replaceValue(key, rawValue, value);
        } else {
            String rawKey = Properties.escapeKey(key);
            this.addNewKeyValue(rawKey, key, rawValue, value);
        }
        return this.values.put(key, value);
    }

    public String putCommented(String key, String value, String ... comment) {
        String old = this.put(key, value);
        this.setComment(key, comment);
        return old;
    }

    public String putRaw(String rawKey, String rawValue) {
        String key = PropertiesParser.unescape(rawKey);
        String value = PropertiesParser.unescape(rawValue);
        if (this.values.containsKey(key)) {
            this.replaceValue(key, rawValue, value);
        } else {
            this.addNewKeyValue(rawKey, key, rawValue, value);
        }
        return this.values.put(key, value);
    }

    private void replaceValue(String key, String rawValue, String value) {
        Cursor pos = this.indexOf(key);
        this.validate(pos.nextIf(PropertiesParser.Type.KEY), pos);
        this.validate(pos.nextIf(PropertiesParser.Type.SEPARATOR), pos);
        this.validate(pos.isType(PropertiesParser.Type.VALUE), pos);
        pos.replace(new PropertiesParser.Token(PropertiesParser.Type.VALUE, rawValue, value));
    }

    private Cursor addNewKeyValue(String rawKey, String key, String rawValue, String value) {
        Cursor pos = this.last();
        while (pos.isType(PropertiesParser.Type.WHITESPACE, PropertiesParser.Type.COMMENT)) {
            pos.prev();
        }
        this.validate(pos.atStart() || pos.isType(PropertiesParser.Type.VALUE), pos);
        if (pos.hasToken()) {
            pos.next();
            if (pos.isEol()) {
                pos.next().addEol().prev();
            } else {
                pos.addEol();
            }
        } else {
            pos = this.skipHeaderCommentLines();
            if (pos.position() > 0) {
                int eols = pos.prevCount(t -> t.isEol());
                for (int i = 0; i < 2 - eols; ++i) {
                    pos.addEol();
                }
            }
        }
        pos.add(new PropertiesParser.Token(PropertiesParser.Type.KEY, rawKey, key));
        pos.add(new PropertiesParser.Token(PropertiesParser.Type.SEPARATOR, "="));
        pos.add(new PropertiesParser.Token(PropertiesParser.Type.VALUE, rawValue, value));
        return pos;
    }

    @Override
    public String remove(Object key) {
        String skey = key.toString();
        if (this.containsKey(key)) {
            this.removeItem(skey);
            return (String)this.values.remove(skey);
        }
        return null;
    }

    private void removeItem(String skey) {
        this.setComment(skey, Collections.emptyList());
        Cursor pos = this.indexOf(skey);
        this.validate(pos.isType(PropertiesParser.Type.KEY), pos);
        pos.remove();
        this.validate(pos.isType(PropertiesParser.Type.SEPARATOR), pos);
        pos.remove();
        this.validate(pos.isType(PropertiesParser.Type.VALUE), pos);
        pos.remove();
        if (pos.isEol()) {
            pos.remove();
        }
    }

    @Override
    public void clear() {
        this.tokens.clear();
        this.values.clear();
    }

    public List<String> getComment(String key) {
        return this.getComment(this.findPropertyCommentLines(key));
    }

    private List<String> getComment(List<Integer> indices) {
        return Collections.unmodifiableList(indices.stream().map(idx -> this.tokens.get((int)idx).getText()).collect(Collectors.toList()));
    }

    public List<String> setComment(String key, String ... comments) {
        return this.setComment(key, Arrays.asList(comments));
    }

    public List<String> setComment(String key, List<String> comments) {
        Cursor pos = this.indexOf(key);
        if (!pos.hasToken()) {
            throw new NoSuchElementException("Key not found: " + key);
        }
        List<Integer> indices = this.findPropertyCommentLines(pos);
        List<String> oldcs = this.getComment(indices);
        this.setComment(indices, pos, comments);
        return oldcs;
    }

    private Cursor setComment(List<Integer> indices, Cursor pos, List<String> comments) {
        int i;
        List<String> oldcs = this.getComment(indices);
        String prefix = oldcs.isEmpty() ? "# " : this.getPrefix(oldcs.get(0));
        List<String> newcs = this.normalizeComments(comments, prefix);
        for (i = 0; i < indices.size() && i < newcs.size(); ++i) {
            int n = indices.get(i);
            this.tokens.set(n, new PropertiesParser.Token(PropertiesParser.Type.COMMENT, newcs.get(i)));
        }
        if (i < indices.size()) {
            Cursor del = this.index(indices.get(i));
            int delcnt = pos.position() - del.position();
            for (int j = 0; j < delcnt; ++j) {
                del.remove();
            }
        }
        for (int j = i; j < newcs.size(); ++j) {
            pos.add(new PropertiesParser.Token(PropertiesParser.Type.COMMENT, newcs.get(j)));
            pos.addEol();
        }
        return pos;
    }

    private List<String> normalizeComments(List<String> comments, String preferredPrefix) {
        ArrayList<String> res = new ArrayList<String>(comments.size());
        for (String c : comments) {
            if (this.getPrefix(c).isEmpty()) {
                c = preferredPrefix + c;
            } else {
                preferredPrefix = this.getPrefix(c);
            }
            res.add(c);
        }
        return res;
    }

    private String getPrefix(String comment) {
        if (comment.startsWith("# ")) {
            return "# ";
        }
        if (comment.startsWith("#")) {
            return "#";
        }
        if (comment.startsWith("! ")) {
            return "! ";
        }
        if (comment.startsWith("!")) {
            return "!";
        }
        return "";
    }

    private List<Integer> findPropertyCommentLines(String key) {
        Cursor pos = this.indexOf(key);
        if (pos.hasToken()) {
            return this.findPropertyCommentLines(pos);
        }
        return Collections.emptyList();
    }

    private List<Integer> findPropertyCommentLines(Cursor pos) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Cursor fpos = pos.copy();
        this.validate(fpos.isType(PropertiesParser.Type.KEY), pos);
        fpos.prev();
        fpos.prevIf(PropertiesParser.Token::isWs);
        fpos.prevIf(PropertiesParser.Token::isEol);
        while (fpos.prevIf(PropertiesParser.Type.COMMENT)) {
            result.add(0, fpos.position() + 1);
            fpos.prevIf(PropertiesParser.Token::isWs);
            fpos.prevIf(PropertiesParser.Token::isEol);
        }
        return Collections.unmodifiableList(result);
    }

    private Cursor indexOf(String key) {
        return this.index(this.tokens.indexOf(new PropertiesParser.Token(PropertiesParser.Type.KEY, Properties.escapeKey(key), key)));
    }

    private static String escapeValue(String value) {
        return value.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\f", "\\f");
    }

    private static String escapeKey(String key) {
        return Properties.escapeValue(key).replace(" ", "\\ ");
    }

    private static String escapeUnicode(String text) {
        return Properties.replace(text, "[^\\x{0000}-\\x{00FF}]", (Matcher m) -> "\\\\u" + String.format("%04x", m.group(0).charAt(0)));
    }

    private static String unescapeUnicode(String escape) {
        StringBuilder txt = new StringBuilder();
        for (int i = 0; i < escape.length(); ++i) {
            char ch = escape.charAt(i);
            if (ch == '\\') {
                if ((ch = escape.charAt(++i)) == 'u') {
                    String num = escape.substring(i + 1, i + 5);
                    txt.append((char)Integer.parseInt(num, 16));
                    i += 4;
                    continue;
                }
                txt.append('\\');
                txt.append(ch);
                continue;
            }
            txt.append(ch);
        }
        return txt.toString();
    }

    private static String replace(String input, String regex, Function<Matcher, String> callback) {
        return Properties.replace(input, Pattern.compile(regex), callback);
    }

    private static String replace(String input, Pattern regex, Function<Matcher, String> callback) {
        StringBuffer resultString = new StringBuffer();
        Matcher regexMatcher = regex.matcher(input);
        while (regexMatcher.find()) {
            regexMatcher.appendReplacement(resultString, callback.apply(regexMatcher));
        }
        regexMatcher.appendTail(resultString);
        return resultString.toString();
    }

    public Properties escaped() {
        return new Properties(this.defaults != null ? this.defaults.escaped() : null, Properties.escapeTokens(this.tokens));
    }

    private static List<PropertiesParser.Token> escapeTokens(List<PropertiesParser.Token> tokens) {
        return Properties.mapKeyValues(tokens, ts -> Arrays.asList(Properties.escapeToken((PropertiesParser.Token)ts.get(0)), (PropertiesParser.Token)ts.get(1), Properties.escapeToken((PropertiesParser.Token)ts.get(2))));
    }

    private static PropertiesParser.Token escapeToken(PropertiesParser.Token token) {
        String raw = Properties.escapeUnicode(token.raw);
        if (!raw.equals(token.raw)) {
            token = new PropertiesParser.Token(token.type, raw, token.text);
        }
        return token;
    }

    public Properties unescaped() {
        return new Properties(this.defaults != null ? this.defaults.unescaped() : null, Properties.unescapeTokens(this.tokens));
    }

    private static List<PropertiesParser.Token> unescapeTokens(List<PropertiesParser.Token> tokens) {
        return Properties.mapKeyValues(tokens, ts -> Arrays.asList(Properties.unescapeToken((PropertiesParser.Token)ts.get(0)), (PropertiesParser.Token)ts.get(1), Properties.unescapeToken((PropertiesParser.Token)ts.get(2))));
    }

    private static PropertiesParser.Token unescapeToken(PropertiesParser.Token token) {
        String raw = Properties.unescapeUnicode(token.raw);
        if (!raw.equals(token.raw)) {
            token = new PropertiesParser.Token(token.type, raw, token.text);
        }
        return token;
    }

    private static List<PropertiesParser.Token> mapKeyValues(List<PropertiesParser.Token> tokens, Function<List<PropertiesParser.Token>, List<PropertiesParser.Token>> mapper) {
        return Properties.combined(tokens).map(ts -> {
            if (((PropertiesParser.Token)ts.get((int)0)).type == PropertiesParser.Type.KEY) {
                return (List)mapper.apply((List<PropertiesParser.Token>)ts);
            }
            return ts;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Stream<List<PropertiesParser.Token>> combined(final List<PropertiesParser.Token> tokens) {
        Iterator<List<PropertiesParser.Token>> iter = new Iterator<List<PropertiesParser.Token>>(){
            Iterator<PropertiesParser.Token> i;
            {
                this.i = tokens.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public List<PropertiesParser.Token> next() {
                PropertiesParser.Token t = this.i.next();
                if (t.type == PropertiesParser.Type.KEY) {
                    return Arrays.asList(t, this.i.next(), this.i.next());
                }
                return Collections.singletonList(t);
            }
        };
        return StreamSupport.stream(Spliterators.spliterator(iter, (long)tokens.size(), 4), false);
    }

    public java.util.Properties asJUProperties() {
        java.util.Properties def = this.defaults != null ? this.defaults.asJUProperties() : null;
        java.util.Properties p = new java.util.Properties(def);
        p.putAll((Map<?, ?>)this);
        return p;
    }

    public void load(Path file) throws IOException {
        try (BufferedReader br = Files.newBufferedReader(file);){
            this.load(br);
        }
    }

    public void load(InputStream in) throws IOException {
        this.load(new InputStreamReader(in, StandardCharsets.ISO_8859_1));
    }

    public void load(Reader reader) throws IOException {
        this.tokens.clear();
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        List<PropertiesParser.Token> ts = PropertiesParser.tokens(br).collect(Collectors.toList());
        this.load(ts);
    }

    private Properties load(List<PropertiesParser.Token> ts) {
        this.tokens.addAll(ts);
        String key = null;
        for (PropertiesParser.Token token : this.tokens) {
            if (token.type == PropertiesParser.Type.KEY) {
                key = token.getText();
                continue;
            }
            if (token.type != PropertiesParser.Type.VALUE) continue;
            this.values.put(key, token.getText());
        }
        return this;
    }

    public static Properties loadProperties(Path file) throws IOException {
        Properties props = new Properties();
        props.load(file);
        return props;
    }

    public static Properties loadProperties(InputStream in) throws IOException {
        return Properties.loadProperties(new InputStreamReader(in, StandardCharsets.ISO_8859_1));
    }

    public static Properties loadProperties(Reader reader) throws IOException {
        Properties props = new Properties();
        props.load(reader);
        return props;
    }

    public void store(Path file, String ... comment) throws IOException {
        try (BufferedWriter bw = Files.newBufferedWriter(file, StandardOpenOption.TRUNCATE_EXISTING);){
            this.store(bw, comment);
        }
    }

    public void store(OutputStream out, String ... comment) throws IOException {
        this.store(new OutputStreamWriter(out, StandardCharsets.ISO_8859_1), comment);
    }

    public void store(Writer writer, String ... comment) throws IOException {
        Cursor pos = this.first();
        if (comment.length > 0) {
            pos = this.skipHeaderCommentLines();
            String nl = this.determineNewline();
            List<String> newcs = this.normalizeComments(Arrays.asList(comment), "# ");
            for (String c : newcs) {
                writer.write(new PropertiesParser.Token(PropertiesParser.Type.COMMENT, c).getRaw());
                writer.write(nl);
            }
            writer.write(nl);
        }
        while (pos.hasToken()) {
            writer.write(pos.raw());
            pos.next();
        }
    }

    private String determineNewline() {
        boolean lf = false;
        boolean crlf = false;
        for (PropertiesParser.Token token : this.tokens) {
            if (!token.isWs()) continue;
            if (token.raw.endsWith("/r/n")) {
                crlf = true;
                continue;
            }
            if (!token.raw.endsWith("/n")) continue;
            lf = true;
        }
        if (lf && crlf) {
            return System.lineSeparator();
        }
        if (crlf) {
            return "/r/n";
        }
        return "\n";
    }

    private Cursor skipHeaderCommentLines() {
        Cursor pos = this.first();
        pos.nextIf(PropertiesParser.Token::isWs);
        while (pos.nextIf(PropertiesParser.Type.COMMENT)) {
            pos.nextIf(PropertiesParser.Token::isEol);
            pos.nextIf(PropertiesParser.Token::isWs);
        }
        if (pos.isType(PropertiesParser.Type.KEY)) {
            return this.first();
        }
        pos.nextWhile(PropertiesParser.Token::isEol);
        return pos;
    }

    Cursor index(int index) {
        return Cursor.index(this.tokens, index);
    }

    Cursor first() {
        return Cursor.first(this.tokens);
    }

    Cursor last() {
        return Cursor.last(this.tokens);
    }

    private void validate(boolean ok, Cursor cursor) {
        if (!ok) {
            throw new IllegalStateException("Unexpected state detected at " + cursor);
        }
    }
}

