/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.statement;

import com.webauthn4j.data.SignatureAlgorithm;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.CoreRegistrationObject;
import com.webauthn4j.validator.attestation.statement.AttestationStatementValidator;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractStatementValidator<T extends AttestationStatement>
implements AttestationStatementValidator {
    private final Class<?> parameterizedTypeClass;

    protected AbstractStatementValidator() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        if (parameterizedType.getActualTypeArguments().length == 0) {
            throw new IllegalStateException("Inheriting class must extend AttestationStatement");
        }
        Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
        if (!(actualTypeArgument instanceof Class)) {
            throw new IllegalStateException("Inheriting class must extend AttestationStatement");
        }
        this.parameterizedTypeClass = (Class)actualTypeArgument;
    }

    @Override
    public boolean supports(@NonNull CoreRegistrationObject registrationObject) {
        AssertUtil.notNull((Object)registrationObject, (String)"registrationObject must not be null");
        AttestationStatement attestationStatement = registrationObject.getAttestationObject().getAttestationStatement();
        if (attestationStatement == null) {
            return false;
        }
        return this.parameterizedTypeClass.isAssignableFrom(attestationStatement.getClass());
    }

    protected String getJcaName(@NonNull COSEAlgorithmIdentifier alg) {
        String jcaName;
        try {
            SignatureAlgorithm signatureAlgorithm = alg.toSignatureAlgorithm();
            jcaName = signatureAlgorithm.getJcaName();
        }
        catch (IllegalArgumentException e) {
            throw new BadAttestationStatementException("alg is not signature algorithm", e);
        }
        return jcaName;
    }
}

