/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.builders.BaseMultiEmitter;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.nio.BufferOverflowException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class BufferItemMultiEmitter<T>
extends BaseMultiEmitter<T> {
    private final Queue<T> queue;
    private final int overflowBufferSize;
    private Throwable failure;
    private volatile boolean done;
    private final AtomicInteger wip = new AtomicInteger();
    private final AtomicInteger strictBoundCounter = new AtomicInteger();

    BufferItemMultiEmitter(MultiSubscriber<? super T> actual, Queue<T> queue, int overflowBufferSize) {
        super(actual);
        this.queue = queue;
        this.overflowBufferSize = overflowBufferSize;
    }

    @Override
    public MultiEmitter<T> emit(T t) {
        if (this.done || this.isCancelled()) {
            return this;
        }
        if (t == null) {
            this.fail(new NullPointerException("`emit` called with `null`."));
            return this;
        }
        if (this.queue.offer(t) && (this.overflowBufferSize == -1 || this.strictBoundCounter.incrementAndGet() < this.overflowBufferSize)) {
            this.drain();
        } else {
            this.fail(new EmitterBufferOverflowException());
        }
        return this;
    }

    @Override
    protected void cleanup() {
        this.queue.clear();
        super.cleanup();
    }

    @Override
    public void failed(Throwable failure) {
        if (this.done || this.isCancelled()) {
            return;
        }
        if (failure == null) {
            failure = new NullPointerException("onError called with null.");
        }
        this.failure = failure;
        this.done = true;
        this.drain();
    }

    @Override
    public void completion() {
        this.done = true;
        this.drain();
    }

    @Override
    void onRequested() {
        this.drain();
    }

    @Override
    void onUnsubscribed() {
        if (this.wip.getAndIncrement() == 0) {
            this.queue.clear();
        }
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        do {
            boolean d;
            long emitted;
            long pending = this.requested.get();
            for (emitted = 0L; emitted != pending; ++emitted) {
                boolean empty;
                if (this.isCancelled()) {
                    this.queue.clear();
                    return;
                }
                d = this.done;
                T o = this.queue.poll();
                boolean bl = empty = o == null;
                if (d && empty) {
                    if (this.failure != null) {
                        super.failed(this.failure);
                    } else {
                        super.completion();
                    }
                    return;
                }
                if (empty) break;
                try {
                    if (this.overflowBufferSize != -1) {
                        this.strictBoundCounter.decrementAndGet();
                    }
                    this.downstream.onItem(o);
                    continue;
                }
                catch (Throwable x) {
                    this.cancel();
                }
            }
            if (emitted == pending) {
                if (this.isCancelled()) {
                    this.queue.clear();
                    return;
                }
                d = this.done;
                boolean empty = this.queue.isEmpty();
                if (d && empty) {
                    if (this.failure != null) {
                        super.failed(this.failure);
                    } else {
                        super.completion();
                    }
                    return;
                }
            }
            if (emitted == 0L) continue;
            Subscriptions.produced(this.requested, emitted);
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    public static class EmitterBufferOverflowException
    extends BufferOverflowException {
        @Override
        public String getMessage() {
            return "The buffer used by the emitter is full, because the downstream consumer did not request enough items.";
        }
    }
}

