/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.CredentialRegistrator;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.Profile;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.RecoveryAuthnCodesCredentialModel;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.utils.CredentialHelper;

public class RecoveryAuthnCodesAction
implements RequiredActionProvider,
RequiredActionFactory,
EnvironmentDependentProviderFactory,
CredentialRegistrator {
    private static final String FIELD_GENERATED_RECOVERY_AUTHN_CODES_HIDDEN = "generatedRecoveryAuthnCodes";
    private static final String FIELD_GENERATED_AT_HIDDEN = "generatedAt";
    private static final String FIELD_USER_LABEL_HIDDEN = "userLabel";
    public static final String PROVIDER_ID = UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES.name();
    private static final RecoveryAuthnCodesAction INSTANCE = new RecoveryAuthnCodesAction();

    public String getId() {
        return PROVIDER_ID;
    }

    public String getCredentialType(KeycloakSession session, AuthenticationSessionModel authenticationSession) {
        return "recovery-authn-codes";
    }

    public String getDisplayText() {
        return "Recovery Authentication Codes";
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return INSTANCE;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public boolean isOneTimeAction() {
        return true;
    }

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().createResponse(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext reqActionContext) {
        EventBuilder event = reqActionContext.getEvent();
        event.event(EventType.UPDATE_CREDENTIAL);
        event.detail("credential_type", "recovery-authn-codes");
        MultivaluedMap httpReqParamsMap = reqActionContext.getHttpRequest().getDecodedFormParameters();
        String generatedCodesString = (String)httpReqParamsMap.getFirst((Object)FIELD_GENERATED_RECOVERY_AUTHN_CODES_HIDDEN);
        String generatedAtTimeString = (String)httpReqParamsMap.getFirst((Object)FIELD_GENERATED_AT_HIDDEN);
        String generatedUserLabel = (String)httpReqParamsMap.getFirst((Object)FIELD_USER_LABEL_HIDDEN);
        if (!generatedAtTimeString.equals(reqActionContext.getAuthenticationSession().getAuthNote("RecoveryAuthnCodes.generatedAt")) || !generatedCodesString.equals(reqActionContext.getAuthenticationSession().getAuthNote("RecoveryAuthnCodes.generatedRecoveryAuthnCodes"))) {
            this.requiredActionChallenge(reqActionContext);
            return;
        }
        reqActionContext.getAuthenticationSession().removeAuthNote("RecoveryAuthnCodes.generatedAt");
        reqActionContext.getAuthenticationSession().removeAuthNote("RecoveryAuthnCodes.generatedRecoveryAuthnCodes");
        List<String> generatedCodes = Arrays.asList(generatedCodesString.split(","));
        RecoveryAuthnCodesCredentialModel credentialModel = this.createFromValues(generatedCodes, Long.valueOf(generatedAtTimeString), generatedUserLabel);
        if ("on".equals(httpReqParamsMap.getFirst((Object)"logout-sessions"))) {
            AuthenticatorUtil.logoutOtherSessions(reqActionContext);
        }
        CredentialHelper.createRecoveryCodesCredential((KeycloakSession)reqActionContext.getSession(), (RealmModel)reqActionContext.getRealm(), (UserModel)reqActionContext.getUser(), (RecoveryAuthnCodesCredentialModel)credentialModel, generatedCodes);
        reqActionContext.success();
    }

    protected RecoveryAuthnCodesCredentialModel createFromValues(List<String> generatedCodes, Long generatedAtTime, String generatedUserLabel) {
        return RecoveryAuthnCodesCredentialModel.createFromValues(generatedCodes, (long)generatedAtTime, (String)generatedUserLabel);
    }

    public void close() {
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.RECOVERY_CODES);
    }
}

