/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.version;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.version.AbstractVersionIterator;
import io.smallrye.common.version.Messages;
import io.smallrye.common.version.VersionSyntaxException;
import java.util.NoSuchElementException;

final class BasicVersionIterator
extends AbstractVersionIterator {
    BasicVersionIterator(String string) {
        super(string);
    }

    int getSeparatorMagnitude() {
        if (this.isEmptySeparator()) {
            return 0;
        }
        int scp = this.getSeparatorCodePoint();
        switch (scp) {
            case 43: {
                return 1;
            }
            case 45: {
                return 2;
            }
            case 95: {
                return 3;
            }
            case 46: {
                return 4;
            }
        }
        throw Assert.impossibleSwitchCase((int)scp);
    }

    void skipTrailer(long mark) {
        int sm = this.getSeparatorMagnitude();
        this.next();
        if (this.isNumberPart() && this.numberPartEquals(0)) {
            assert (this.hasNext());
            this.next();
            if (this.getSeparatorMagnitude() > sm) {
                this.skipTrailer(this.mark());
                return;
            }
        } else {
            this.reset(mark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        AbstractVersionIterator.TokenType pt = this.currentType();
        if (!super.hasNext()) {
            if (pt == AbstractVersionIterator.TokenType.SEP || pt == AbstractVersionIterator.TokenType.SEP_EMPTY) {
                throw Messages.msg.unexpectedEnd();
            }
            return false;
        }
        long mark = this.mark();
        try {
            super.next();
            AbstractVersionIterator.TokenType ct = this.currentType();
            if (!(pt != AbstractVersionIterator.TokenType.INITIAL && pt != AbstractVersionIterator.TokenType.SEP && pt != AbstractVersionIterator.TokenType.SEP_EMPTY || ct != AbstractVersionIterator.TokenType.SEP && ct != AbstractVersionIterator.TokenType.SEP_EMPTY)) {
                throw Messages.msg.invalidCodePoint(new String(Character.toChars(this.getSeparatorCodePoint())), this.getStartIndex(), this.string);
            }
            if (ct == AbstractVersionIterator.TokenType.PART_ALPHA) {
                boolean bl = true;
                return bl;
            }
            if (ct == AbstractVersionIterator.TokenType.PART_NUMBER && !this.numberPartEquals(0)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.hasNext();
            return bl;
        }
        finally {
            this.reset(mark);
        }
    }

    @Override
    public void next() throws NoSuchElementException, VersionSyntaxException {
        AbstractVersionIterator.TokenType pt = this.currentType();
        super.next();
        AbstractVersionIterator.TokenType ct = this.currentType();
        if (!(pt != AbstractVersionIterator.TokenType.INITIAL && pt != AbstractVersionIterator.TokenType.SEP && pt != AbstractVersionIterator.TokenType.SEP_EMPTY || ct != AbstractVersionIterator.TokenType.SEP && ct != AbstractVersionIterator.TokenType.SEP_EMPTY)) {
            throw Messages.msg.invalidCodePoint(new String(Character.toChars(this.getSeparatorCodePoint())), this.getStartIndex(), this.string);
        }
        if (this.isSeparator()) {
            long mark = this.mark();
            try {
                this.skipTrailer(mark);
            }
            catch (Throwable t) {
                this.reset(mark);
                throw t;
            }
        }
    }
}

