/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization;

import java.lang.invoke.LambdaMetafactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.Realm;

public class FGAPEvaluation
implements Evaluation {
    private final Evaluation evaluation;
    private final Map<Scope, Set<Resource>> scopesGrantedByResource;

    public FGAPEvaluation(Evaluation evaluation, Map<Scope, Set<Resource>> scopesGrantedByResource) {
        this.evaluation = evaluation;
        this.scopesGrantedByResource = scopesGrantedByResource;
    }

    @Override
    public boolean isGranted(Policy grantedPolicy, Scope grantedScope) {
        ResourcePermission permission = this.getPermission();
        String resourceType = permission.getResourceType();
        if (resourceType == null) {
            return false;
        }
        Set<Scope> policyScopes = grantedPolicy.getScopes();
        if (this.isForResourceType(grantedPolicy, resourceType) && policyScopes.contains(grantedScope)) {
            this.scopesGrantedByResource.computeIfAbsent(grantedScope, k -> new HashSet()).addAll(grantedPolicy.getResources());
            return true;
        }
        Set<String> aliases = AdminPermissionsSchema.SCHEMA.getScopeAliases(resourceType, grantedScope);
        if (aliases.isEmpty()) {
            return false;
        }
        boolean granted = policyScopes.stream().map(Scope::getName).anyMatch(aliases::contains);
        if (granted) {
            this.scopesGrantedByResource.computeIfAbsent(grantedScope, k -> new HashSet()).addAll(grantedPolicy.getResources());
        }
        return granted;
    }

    @Override
    public boolean isDenied(Policy deniedPolicy, Scope deniedScope) {
        ResourcePermission permission = this.getPermission();
        String resourceType = permission.getResourceType();
        if (resourceType == null) {
            return false;
        }
        if (this.isForSpecificResource(deniedPolicy)) {
            return true;
        }
        if (this.isForResourceType(deniedPolicy, resourceType)) {
            return !this.isGranted(permission.getResource(), deniedScope);
        }
        Set<String> aliases = AdminPermissionsSchema.SCHEMA.getScopeAliases(resourceType, deniedScope);
        if (aliases.isEmpty()) {
            return false;
        }
        for (Scope scope : deniedPolicy.getScopes()) {
            if (!aliases.contains(scope.getName())) continue;
            return !this.isGranted(deniedScope);
        }
        return false;
    }

    @Override
    public ResourcePermission getPermission() {
        return this.evaluation.getPermission();
    }

    @Override
    public EvaluationContext getContext() {
        return this.evaluation.getContext();
    }

    @Override
    public Policy getPolicy() {
        return this.evaluation.getPolicy();
    }

    @Override
    public Realm getRealm() {
        return this.evaluation.getRealm();
    }

    @Override
    public AuthorizationProvider getAuthorizationProvider() {
        return this.evaluation.getAuthorizationProvider();
    }

    @Override
    public void grant() {
        this.evaluation.grant();
    }

    @Override
    public void deny() {
        this.evaluation.deny();
    }

    @Override
    public void denyIfNoEffect() {
        this.evaluation.denyIfNoEffect();
    }

    @Override
    public Policy getParentPolicy() {
        return this.evaluation.getParentPolicy();
    }

    @Override
    public Decision.Effect getEffect() {
        return this.evaluation.getEffect();
    }

    @Override
    public void setEffect(Decision.Effect effect) {
        this.evaluation.setEffect(effect);
    }

    private boolean isForResourceType(Policy policy, String resourceType) {
        return policy.getResourceType().equals(resourceType);
    }

    private boolean isForSpecificResource(Policy policy) {
        return !policy.getResources().contains(this.getResourceTypeResource(policy, policy.getResourceType()));
    }

    private boolean isGranted(Resource resource, Scope scope) {
        return this.scopesGrantedByResource.getOrDefault(scope, Set.of()).stream().anyMatch((Predicate<Resource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/keycloak/authorization/model/Resource;)Z)((Resource)resource));
    }

    private boolean isGranted(Scope scope) {
        return !this.scopesGrantedByResource.getOrDefault(scope, Set.of()).isEmpty();
    }

    private Resource getResourceTypeResource(Policy policy, String resourceType) {
        return AdminPermissionsSchema.SCHEMA.getResourceTypeResource(this.getAuthorizationProvider().getKeycloakSession(), policy.getResourceServer(), resourceType);
    }
}

