/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import org.infinispan.protostream.descriptors.FileDescriptor;

public enum Label {
    OPTIONAL,
    REPEATED,
    REQUIRED,
    ONE_OF;


    public static Label fromString(String label, FileDescriptor.Syntax syntax) {
        switch (label) {
            case "repeated": {
                return REPEATED;
            }
            case "optional": {
                return OPTIONAL;
            }
            case "oneof": {
                return ONE_OF;
            }
            case "required": {
                if (syntax != FileDescriptor.Syntax.PROTO2) {
                    throw new IllegalArgumentException("'required' fields are not allowed with syntax " + syntax);
                }
                return REQUIRED;
            }
        }
        throw new IllegalArgumentException(label);
    }
}

