/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.MembershipMetadata;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.jpa.entities.GroupEntity;
import org.keycloak.models.jpa.entities.OrganizationEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserGroupMembershipEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.jpa.OrganizationAdapter;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.representations.idm.MembershipType;
import org.keycloak.storage.StorageId;
import org.keycloak.utils.ReservedCharValidator;
import org.keycloak.utils.StreamsUtil;
import org.keycloak.utils.StringUtil;

public class JpaOrganizationProvider
implements OrganizationProvider {
    private final EntityManager em;
    private final GroupProvider groupProvider;
    private final UserProvider userProvider;
    private final KeycloakSession session;

    public JpaOrganizationProvider(KeycloakSession session) {
        this.session = session;
        this.em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        this.groupProvider = session.groups();
        this.userProvider = session.users();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationModel create(String id, String name, String alias) {
        if (StringUtil.isBlank((String)name)) {
            throw new ModelValidationException("Name can not be null");
        }
        if (StringUtil.isBlank((String)alias)) {
            try {
                ReservedCharValidator.validateNoSpace((String)name);
            }
            catch (ReservedCharValidator.ReservedCharException e) {
                throw new ModelValidationException("Name contains a reserved character and cannot be used as alias");
            }
            alias = name;
        }
        if (this.getByName(name) != null) {
            throw new ModelDuplicateException("A organization with the same name already exists.");
        }
        if (this.getAllStream(Map.of("alias", alias), -1, -1).findAny().isPresent()) {
            throw new ModelDuplicateException("A organization with the same alias already exists");
        }
        OrganizationEntity entity = new OrganizationEntity();
        entity.setId(id != null ? id : KeycloakModelUtils.generateId());
        entity.setRealmId(this.getRealm().getId());
        OrganizationAdapter adapter = new OrganizationAdapter(this.session, this.getRealm(), entity, this);
        try {
            this.session.getContext().setOrganization((OrganizationModel)adapter);
            GroupModel group = this.createOrganizationGroup(adapter.getId());
            adapter.setGroupId(group.getId());
            adapter.setName(name);
            adapter.setAlias(alias);
            adapter.setEnabled(true);
            this.em.persist((Object)adapter.getEntity());
        }
        finally {
            this.session.getContext().setOrganization(null);
        }
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(OrganizationModel organization) {
        OrganizationEntity entity = this.getEntity(organization.getId());
        try {
            this.session.getContext().setOrganization(organization);
            RealmModel realm = this.session.realms().getRealm(this.getRealm().getId());
            if (realm != null) {
                GroupModel group = this.getOrganizationGroup(entity);
                if (group != null) {
                    OrganizationProvider provider = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
                    this.userProvider.getGroupMembersStream(realm, group).forEach(userModel -> provider.removeMember(organization, userModel));
                    this.groupProvider.removeGroup(realm, group);
                }
                organization.getIdentityProviders().forEach(model -> this.removeIdentityProvider(organization, (IdentityProviderModel)model));
            }
            this.em.remove((Object)entity);
        }
        finally {
            this.session.getContext().setOrganization(null);
        }
        return true;
    }

    public void removeAll() {
        this.getAllStream().forEach(this::remove);
    }

    public boolean addManagedMember(OrganizationModel organization, UserModel user) {
        return this.addMember(organization, user, new MembershipMetadata(MembershipType.MANAGED));
    }

    public boolean addMember(OrganizationModel organization, UserModel user) {
        return this.addMember(organization, user, new MembershipMetadata(MembershipType.UNMANAGED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMember(OrganizationModel organization, UserModel user, MembershipMetadata metadata) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        this.throwExceptionIfObjectIsNull(user, "User");
        OrganizationEntity entity = this.getEntity(organization.getId());
        OrganizationModel current = Organizations.resolveOrganization((KeycloakSession)this.session);
        if (this.session.users().getUserById(this.session.realms().getRealm(entity.getRealmId()), user.getId()) == null) {
            return false;
        }
        if (current == null) {
            this.session.getContext().setOrganization(organization);
        }
        try {
            GroupModel group = this.getOrganizationGroup(entity);
            if (user.isMemberOf(group)) {
                boolean bl = false;
                return bl;
            }
            user.joinGroup(group, metadata);
            OrganizationModel.OrganizationMemberJoinEvent.fire((OrganizationModel)organization, (UserModel)user, (KeycloakSession)this.session);
        }
        finally {
            if (current == null) {
                this.session.getContext().setOrganization(null);
            }
        }
        return true;
    }

    public OrganizationModel getById(String id) {
        OrganizationEntity entity = this.getEntity(id, false);
        return entity == null ? null : new OrganizationAdapter(this.session, this.getRealm(), entity, this);
    }

    public OrganizationModel getByDomainName(String domain) {
        TypedQuery query = this.em.createNamedQuery("getByDomainName", OrganizationEntity.class);
        RealmModel realm = this.getRealm();
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("name", (Object)domain.toLowerCase());
        try {
            OrganizationEntity entity = (OrganizationEntity)query.getSingleResult();
            return new OrganizationAdapter(this.session, realm, entity, this);
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public Stream<OrganizationModel> getAllStream(String search, Boolean exact, Integer first, Integer max) {
        TypedQuery query;
        if (StringUtil.isBlank((String)search)) {
            query = this.em.createNamedQuery("getByRealm", OrganizationEntity.class);
        } else if (Boolean.TRUE.equals(exact)) {
            query = this.em.createNamedQuery("getByNameOrDomain", OrganizationEntity.class);
            query.setParameter("search", (Object)search);
        } else {
            query = this.em.createNamedQuery("getByNameOrDomainContained", OrganizationEntity.class);
            query.setParameter("search", (Object)search.toLowerCase());
        }
        RealmModel realm = this.getRealm();
        query.setParameter("realmId", (Object)realm.getId());
        return StreamsUtil.closing(PaginationUtils.paginateQuery((TypedQuery)query, (Integer)first, (Integer)max).getResultStream().map(entity -> new OrganizationAdapter(this.session, realm, (OrganizationEntity)entity, this)));
    }

    public Stream<OrganizationModel> getAllStream(Map<String, String> attributes, Integer first, Integer max) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(OrganizationEntity.class);
        Root org = query.from(OrganizationEntity.class);
        Root group = query.from(GroupEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        RealmModel realm = this.getRealm();
        predicates.add(builder.equal((Expression)org.get("realmId"), (Object)realm.getId()));
        predicates.add(builder.equal((Expression)org.get("groupId"), (Expression)group.get("id")));
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (StringUtil.isBlank((String)entry.getKey())) continue;
            if ("alias".equals(entry.getKey())) {
                predicates.add(builder.equal((Expression)org.get("alias"), (Object)entry.getValue()));
                continue;
            }
            Join groupJoin = group.join("attributes");
            Predicate attrNamePredicate = builder.equal((Expression)groupJoin.get("name"), (Object)entry.getKey());
            Predicate attrValuePredicate = builder.equal((Expression)groupJoin.get("value"), (Object)entry.getValue());
            predicates.add(builder.and((Expression)attrNamePredicate, (Expression)attrValuePredicate));
        }
        Predicate finalPredicate = builder.and(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.em.createQuery(query.select((Selection)org).where((Expression)finalPredicate));
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)typedQuery, (Integer)first, (Integer)max).getResultStream()).map(entity -> new OrganizationAdapter(this.session, realm, (OrganizationEntity)entity, this));
    }

    public Stream<UserModel> getMembersStream(OrganizationModel organization, String search, Boolean exact, Integer first, Integer max) {
        return this.getMembersStream(organization, Map.of("keycloak.session.realm.users.query.search", search), exact, first, max);
    }

    public Stream<UserModel> getMembersStream(OrganizationModel organization, Map<String, String> filters, Boolean exact, Integer first, Integer max) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root groupMembership = queryBuilder.from(UserGroupMembershipEntity.class);
        queryBuilder.select((Selection)groupMembership.get("user").get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        GroupModel group = this.getOrganizationGroup(organization);
        predicates.add(builder.equal((Expression)groupMembership.get("groupId"), (Object)group.getId()));
        Join userJoin = groupMembership.join("user");
        for (Map.Entry filter : Optional.ofNullable(filters).orElse(Map.of()).entrySet()) {
            switch ((String)filter.getKey()) {
                case "keycloak.session.realm.users.query.search": {
                    predicates.add(builder.or(this.getSearchOptionPredicateArray((String)filter.getValue(), Optional.ofNullable(exact).orElse(false), builder, (From<?, UserEntity>)userJoin)));
                    break;
                }
                case "membershipType": {
                    predicates.add(builder.equal((Expression)groupMembership.get("membershipType"), (Object)((String)filter.getValue()).toUpperCase()));
                }
            }
        }
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        queryBuilder.orderBy(new Order[]{builder.asc((Expression)userJoin.get("username"))});
        return StreamsUtil.closing(PaginationUtils.paginateQuery((TypedQuery)this.em.createQuery(queryBuilder), (Integer)first, (Integer)max).getResultStream().map(id -> {
            UserModel user = this.userProvider.getUserById(this.getRealm(), id);
            if (Organizations.isReadOnlyOrganizationMember((KeycloakSession)this.session, (UserModel)user)) {
                return new /* Unavailable Anonymous Inner Class!! */;
            }
            return user;
        }));
    }

    private Predicate[] getSearchOptionPredicateArray(String value, boolean exact, CriteriaBuilder builder, From<?, UserEntity> from) {
        value = ((String)value).toLowerCase();
        ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
        if (exact) {
            orPredicates.add(builder.equal((Expression)from.get("username"), value));
            orPredicates.add(builder.equal((Expression)from.get("email"), value));
            orPredicates.add(builder.equal(builder.lower((Expression)from.get("firstName")), value));
            orPredicates.add(builder.equal(builder.lower((Expression)from.get("lastName")), value));
        } else {
            value = "%" + (String)value + "%";
            orPredicates.add(builder.like((Expression)from.get("username"), (String)value));
            orPredicates.add(builder.like((Expression)from.get("email"), (String)value));
            orPredicates.add(builder.like(builder.lower((Expression)from.get("firstName")), (String)value));
            orPredicates.add(builder.like(builder.lower((Expression)from.get("lastName")), (String)value));
        }
        return (Predicate[])orPredicates.toArray(Predicate[]::new);
    }

    public long getMembersCount(OrganizationModel organization) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        String groupId = this.getOrganizationGroup(organization).getId();
        return this.userProvider.getUsersCount(this.getRealm(), Set.of(groupId));
    }

    public UserModel getMemberById(OrganizationModel organization, String id) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        UserModel user = this.userProvider.getUserById(this.getRealm(), id);
        if (user == null) {
            return null;
        }
        if (this.getByMember(user).anyMatch(arg_0 -> ((OrganizationModel)organization).equals(arg_0))) {
            return user;
        }
        return null;
    }

    public Stream<OrganizationModel> getByMember(UserModel member) {
        this.throwExceptionIfObjectIsNull(member, "User");
        TypedQuery query = StorageId.isLocalStorage((String)member.getId()) ? this.em.createNamedQuery("getGroupsByMember", String.class) : this.em.createNamedQuery("getGroupsByFederatedMember", String.class);
        query.setParameter("userId", (Object)member.getId());
        OrganizationProvider organizations = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
        GroupProvider groups = this.session.groups();
        return StreamsUtil.closing((Stream)query.getResultStream()).map(id -> groups.getGroupById(this.getRealm(), id)).map(g -> organizations.getById(g.getName())).filter(Objects::nonNull);
    }

    public boolean addIdentityProvider(OrganizationModel organization, IdentityProviderModel identityProvider) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        this.throwExceptionIfObjectIsNull(identityProvider, "Identity provider");
        OrganizationEntity organizationEntity = this.getEntity(organization.getId());
        if (!this.checkOrgIdpAndRealm(organizationEntity, identityProvider)) {
            return false;
        }
        String orgId = identityProvider.getOrganizationId();
        if (organizationEntity.getId().equals(orgId)) {
            return false;
        }
        if (orgId != null) {
            throw new ModelValidationException("Identity provider already associated with a different organization");
        }
        identityProvider.setOrganizationId(organizationEntity.getId());
        this.session.identityProviders().update(identityProvider);
        return true;
    }

    public Stream<IdentityProviderModel> getIdentityProviders(OrganizationModel organization) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        this.throwExceptionIfObjectIsNull(organization.getId(), "Organization ID");
        OrganizationEntity organizationEntity = this.getEntity(organization.getId());
        return this.session.identityProviders().getByOrganization(organizationEntity.getId(), null, null);
    }

    public boolean removeIdentityProvider(OrganizationModel organization, IdentityProviderModel identityProvider) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        OrganizationEntity organizationEntity = this.getEntity(organization.getId());
        if (!organizationEntity.getId().equals(identityProvider.getOrganizationId())) {
            return false;
        }
        identityProvider.setOrganizationId(null);
        identityProvider.getConfig().remove("kc.org.domain");
        this.session.identityProviders().update(identityProvider);
        return true;
    }

    public boolean isManagedMember(OrganizationModel organization, UserModel member) {
        this.throwExceptionIfObjectIsNull(organization, "organization");
        if (member == null) {
            return false;
        }
        UserEntity userEntity = (UserEntity)this.em.find(UserEntity.class, (Object)member.getId());
        if (userEntity == null) {
            return false;
        }
        GroupModel organizationGroup = this.getOrganizationGroup(organization);
        try {
            UserGroupMembershipEntity membership = (UserGroupMembershipEntity)this.em.createNamedQuery("userMemberOf", UserGroupMembershipEntity.class).setParameter("user", (Object)userEntity).setParameter("groupId", (Object)organizationGroup.getId()).getSingleResult();
            this.em.detach((Object)membership);
            return MembershipType.MANAGED.equals((Object)membership.getMembershipType());
        }
        catch (NoResultException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMember(OrganizationModel organization, UserModel member) {
        this.throwExceptionIfObjectIsNull(organization, "organization");
        this.throwExceptionIfObjectIsNull(member, "member");
        OrganizationModel userOrg = this.getByMember(member).filter(arg_0 -> ((OrganizationModel)organization).equals(arg_0)).findAny().orElse(null);
        if (userOrg == null || !userOrg.equals((Object)organization)) {
            return false;
        }
        if (this.isManagedMember(organization, member)) {
            this.userProvider.removeUser(this.getRealm(), member);
        } else {
            OrganizationModel current = Organizations.resolveOrganization((KeycloakSession)this.session);
            if (current == null) {
                this.session.getContext().setOrganization(organization);
            }
            try {
                member.leaveGroup(this.getOrganizationGroup(organization));
            }
            finally {
                if (current == null) {
                    this.session.getContext().setOrganization(null);
                }
            }
        }
        OrganizationModel.OrganizationMemberLeaveEvent.fire((OrganizationModel)organization, (UserModel)member, (KeycloakSession)this.session);
        return true;
    }

    public long count() {
        TypedQuery query = this.em.createNamedQuery("getCount", Long.class);
        query.setParameter("realmId", (Object)this.getRealm().getId());
        return (Long)query.getSingleResult();
    }

    public boolean isEnabled() {
        return this.getRealm().isOrganizationsEnabled();
    }

    public void close() {
    }

    private OrganizationEntity getEntity(String id) {
        return this.getEntity(id, true);
    }

    private OrganizationEntity getEntity(String id, boolean failIfNotFound) {
        OrganizationEntity entity = (OrganizationEntity)this.em.find(OrganizationEntity.class, (Object)id);
        if (entity == null) {
            if (failIfNotFound) {
                throw new ModelException("Organization [" + id + "] does not exist");
            }
            return null;
        }
        RealmModel realm = this.getRealm();
        if (!realm.getId().equals(entity.getRealmId())) {
            throw new ModelException("Organization [" + entity.getId() + "] does not belong to realm [" + realm.getId() + "]");
        }
        return entity;
    }

    private GroupModel createOrganizationGroup(String orgId) {
        return this.groupProvider.createGroup(this.getRealm(), null, GroupModel.Type.ORGANIZATION, orgId, null);
    }

    private GroupModel getOrganizationGroup(OrganizationModel organization) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        OrganizationEntity entity = this.getEntity(organization.getId());
        GroupModel group = this.getOrganizationGroup(entity);
        if (group == null) {
            throw new ModelException("Organization group " + entity.getGroupId() + " not found");
        }
        return group;
    }

    private GroupModel getOrganizationGroup(OrganizationEntity entity) {
        return this.groupProvider.getGroupById(this.getRealm(), entity.getGroupId());
    }

    private void throwExceptionIfObjectIsNull(Object object, String objectName) {
        if (object == null) {
            throw new ModelException(String.format("%s cannot be null", objectName));
        }
    }

    private OrganizationEntity getByName(String name) {
        TypedQuery query = this.em.createNamedQuery("getByOrgName", OrganizationEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realmId", (Object)this.getRealm().getId());
        try {
            return (OrganizationEntity)query.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    private boolean checkOrgIdpAndRealm(OrganizationEntity orgEntity, IdentityProviderModel idp) {
        IdentityProviderModel orgIdpByAlias = this.session.identityProviders().getByAlias(idp.getAlias());
        return orgIdpByAlias != null && orgIdpByAlias.getInternalId().equals(idp.getInternalId());
    }

    private RealmModel getRealm() {
        RealmModel realm = this.session.getContext().getRealm();
        if (realm == null) {
            throw new IllegalArgumentException("Session not bound to a realm");
        }
        return realm;
    }
}

