/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.github;

import java.util.List;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProviderFactory;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.social.github.GitHubIdentityProvider;

public class GitHubIdentityProviderFactory
extends AbstractIdentityProviderFactory<GitHubIdentityProvider>
implements SocialIdentityProviderFactory<GitHubIdentityProvider> {
    public static final String PROVIDER_ID = "github";

    public String getName() {
        return "GitHub";
    }

    public GitHubIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new GitHubIdentityProvider(session, new OAuth2IdentityProviderConfig(model));
    }

    public OAuth2IdentityProviderConfig createConfig() {
        return new OAuth2IdentityProviderConfig();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name("baseUrl").label("Base URL").helpText("Override the default Base URL for this identity provider.").type("String").add().property().name("apiUrl").label("API URL").helpText("Override the default API URL for this identity provider.").type("String").add().build();
    }
}

