/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;

public class PropertyAccessStrategyIndexBackRefImpl
implements PropertyAccessStrategy {
    private final @UnknownKeyFor @NonNull @Initialized String entityName;
    private final @UnknownKeyFor @NonNull @Initialized String propertyName;

    public PropertyAccessStrategyIndexBackRefImpl(@UnknownKeyFor @NonNull @Initialized String collectionRole, @UnknownKeyFor @NonNull @Initialized String entityName) {
        this.entityName = entityName;
        this.propertyName = collectionRole.substring(entityName.length() + 1);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PropertyAccess buildPropertyAccess(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerJavaType, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized boolean setterRequired) {
        return new PropertyAccessIndexBackRefImpl(this);
    }

    private static class SetterImpl
    implements Setter {
        public static final @UnknownKeyFor @NonNull @Initialized SetterImpl INSTANCE = new SetterImpl();

        private SetterImpl() {
        }

        @Override
        public void set(@UnknownKeyFor @NonNull @Initialized Object target, @Nullable @UnknownKeyFor @Initialized Object value) {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String getMethodName() {
            return null;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Method getMethod() {
            return null;
        }
    }

    private static class GetterImpl
    implements Getter {
        private final @UnknownKeyFor @NonNull @Initialized String entityName;
        private final @UnknownKeyFor @NonNull @Initialized String propertyName;

        public GetterImpl(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String propertyName) {
            this.entityName = entityName;
            this.propertyName = propertyName;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object get(@UnknownKeyFor @NonNull @Initialized Object owner) {
            return PropertyAccessStrategyBackRefImpl.UNKNOWN;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object getForInsert(@UnknownKeyFor @NonNull @Initialized Object owner, @UnknownKeyFor @NonNull @Initialized Map mergeMap, @UnknownKeyFor @NonNull @Initialized SharedSessionContractImplementor session) {
            return session.getPersistenceContextInternal().getIndexInOwner(this.entityName, this.propertyName, owner, mergeMap);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getReturnTypeClass() {
            return Object.class;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Type getReturnType() {
            return Object.class;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Member getMember() {
            return null;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String getMethodName() {
            return null;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Method getMethod() {
            return null;
        }
    }

    private static class PropertyAccessIndexBackRefImpl
    implements PropertyAccess {
        private final @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategyIndexBackRefImpl strategy;
        private final @UnknownKeyFor @NonNull @Initialized GetterImpl getter;

        public PropertyAccessIndexBackRefImpl(@UnknownKeyFor @NonNull @Initialized PropertyAccessStrategyIndexBackRefImpl strategy) {
            this.strategy = strategy;
            this.getter = new GetterImpl(strategy.entityName, strategy.propertyName);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy getPropertyAccessStrategy() {
            return this.strategy;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Getter getGetter() {
            return this.getter;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Setter getSetter() {
            return SetterImpl.INSTANCE;
        }
    }
}

