/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class BeginQuorumEpochRequestDataJsonConverter {
    public static BeginQuorumEpochRequestData read(JsonNode _node, short _version) {
        BeginQuorumEpochRequestData _object = new BeginQuorumEpochRequestData();
        JsonNode _clusterIdNode = _node.get("clusterId");
        if (_clusterIdNode == null) {
            throw new RuntimeException("BeginQuorumEpochRequestData: unable to locate field 'clusterId', which is mandatory in version " + _version);
        }
        if (_clusterIdNode.isNull()) {
            _object.clusterId = null;
        } else {
            if (!_clusterIdNode.isTextual()) {
                throw new RuntimeException("BeginQuorumEpochRequestData expected a string type, but got " + _node.getNodeType());
            }
            _object.clusterId = _clusterIdNode.asText();
        }
        JsonNode _voterIdNode = _node.get("voterId");
        if (_voterIdNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("BeginQuorumEpochRequestData: unable to locate field 'voterId', which is mandatory in version " + _version);
            }
            _object.voterId = -1;
        } else {
            _object.voterId = MessageUtil.jsonNodeToInt(_voterIdNode, "BeginQuorumEpochRequestData");
        }
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("BeginQuorumEpochRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("BeginQuorumEpochRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<BeginQuorumEpochRequestData.TopicData> _collection = new ArrayList<BeginQuorumEpochRequestData.TopicData>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(TopicDataJsonConverter.read(_element, _version));
        }
        JsonNode _leaderEndpointsNode = _node.get("leaderEndpoints");
        if (_leaderEndpointsNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("BeginQuorumEpochRequestData: unable to locate field 'leaderEndpoints', which is mandatory in version " + _version);
            }
            _object.leaderEndpoints = new BeginQuorumEpochRequestData.LeaderEndpointCollection(0);
        } else {
            BeginQuorumEpochRequestData.LeaderEndpointCollection _collection2;
            if (!_leaderEndpointsNode.isArray()) {
                throw new RuntimeException("BeginQuorumEpochRequestData expected a JSON array, but got " + _node.getNodeType());
            }
            _object.leaderEndpoints = _collection2 = new BeginQuorumEpochRequestData.LeaderEndpointCollection(_leaderEndpointsNode.size());
            for (JsonNode _element : _leaderEndpointsNode) {
                _collection2.add(LeaderEndpointJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }

    public static JsonNode write(BeginQuorumEpochRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_object.clusterId == null) {
            _node.set("clusterId", (JsonNode)NullNode.instance);
        } else {
            _node.set("clusterId", (JsonNode)new TextNode(_object.clusterId));
        }
        if (_version >= 1) {
            _node.set("voterId", (JsonNode)new IntNode(_object.voterId));
        }
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (BeginQuorumEpochRequestData.TopicData _element : _object.topics) {
            _topicsArray.add(TopicDataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        if (_version >= 1) {
            ArrayNode _leaderEndpointsArray = new ArrayNode(JsonNodeFactory.instance);
            for (BeginQuorumEpochRequestData.LeaderEndpoint _element : _object.leaderEndpoints) {
                _leaderEndpointsArray.add(LeaderEndpointJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("leaderEndpoints", (JsonNode)_leaderEndpointsArray);
        }
        return _node;
    }

    public static JsonNode write(BeginQuorumEpochRequestData _object, short _version) {
        return BeginQuorumEpochRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class TopicDataJsonConverter {
        public static BeginQuorumEpochRequestData.TopicData read(JsonNode _node, short _version) {
            BeginQuorumEpochRequestData.TopicData _object = new BeginQuorumEpochRequestData.TopicData();
            JsonNode _topicNameNode = _node.get("topicName");
            if (_topicNameNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'topicName', which is mandatory in version " + _version);
            }
            if (!_topicNameNode.isTextual()) {
                throw new RuntimeException("TopicData expected a string type, but got " + _node.getNodeType());
            }
            _object.topicName = _topicNameNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("TopicData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<BeginQuorumEpochRequestData.PartitionData> _collection = new ArrayList<BeginQuorumEpochRequestData.PartitionData>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(PartitionDataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(BeginQuorumEpochRequestData.TopicData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicName", (JsonNode)new TextNode(_object.topicName));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (BeginQuorumEpochRequestData.PartitionData _element : _object.partitions) {
                _partitionsArray.add(PartitionDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(BeginQuorumEpochRequestData.TopicData _object, short _version) {
            return TopicDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class LeaderEndpointJsonConverter {
        public static BeginQuorumEpochRequestData.LeaderEndpoint read(JsonNode _node, short _version) {
            BeginQuorumEpochRequestData.LeaderEndpoint _object = new BeginQuorumEpochRequestData.LeaderEndpoint();
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderEndpoint");
            }
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("LeaderEndpoint: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("LeaderEndpoint expected a string type, but got " + _node.getNodeType());
            }
            _object.name = _nameNode.asText();
            JsonNode _hostNode = _node.get("host");
            if (_hostNode == null) {
                throw new RuntimeException("LeaderEndpoint: unable to locate field 'host', which is mandatory in version " + _version);
            }
            if (!_hostNode.isTextual()) {
                throw new RuntimeException("LeaderEndpoint expected a string type, but got " + _node.getNodeType());
            }
            _object.host = _hostNode.asText();
            JsonNode _portNode = _node.get("port");
            if (_portNode == null) {
                throw new RuntimeException("LeaderEndpoint: unable to locate field 'port', which is mandatory in version " + _version);
            }
            _object.port = MessageUtil.jsonNodeToUnsignedShort(_portNode, "LeaderEndpoint");
            return _object;
        }

        public static JsonNode write(BeginQuorumEpochRequestData.LeaderEndpoint _object, short _version, boolean _serializeRecords) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderEndpoint");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            _node.set("host", (JsonNode)new TextNode(_object.host));
            _node.set("port", (JsonNode)new IntNode(_object.port));
            return _node;
        }

        public static JsonNode write(BeginQuorumEpochRequestData.LeaderEndpoint _object, short _version) {
            return LeaderEndpointJsonConverter.write(_object, _version, true);
        }
    }

    public static class PartitionDataJsonConverter {
        public static BeginQuorumEpochRequestData.PartitionData read(JsonNode _node, short _version) {
            BeginQuorumEpochRequestData.PartitionData _object = new BeginQuorumEpochRequestData.PartitionData();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "PartitionData");
            JsonNode _voterDirectoryIdNode = _node.get("voterDirectoryId");
            if (_voterDirectoryIdNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("PartitionData: unable to locate field 'voterDirectoryId', which is mandatory in version " + _version);
                }
                _object.voterDirectoryId = Uuid.ZERO_UUID;
            } else {
                if (!_voterDirectoryIdNode.isTextual()) {
                    throw new RuntimeException("PartitionData expected a JSON string type, but got " + _node.getNodeType());
                }
                _object.voterDirectoryId = Uuid.fromString(_voterDirectoryIdNode.asText());
            }
            JsonNode _leaderIdNode = _node.get("leaderId");
            if (_leaderIdNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'leaderId', which is mandatory in version " + _version);
            }
            _object.leaderId = MessageUtil.jsonNodeToInt(_leaderIdNode, "PartitionData");
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
            }
            _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "PartitionData");
            return _object;
        }

        public static JsonNode write(BeginQuorumEpochRequestData.PartitionData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            if (_version >= 1) {
                _node.set("voterDirectoryId", (JsonNode)new TextNode(_object.voterDirectoryId.toString()));
            }
            _node.set("leaderId", (JsonNode)new IntNode(_object.leaderId));
            _node.set("leaderEpoch", (JsonNode)new IntNode(_object.leaderEpoch));
            return _node;
        }

        public static JsonNode write(BeginQuorumEpochRequestData.PartitionData _object, short _version) {
            return PartitionDataJsonConverter.write(_object, _version, true);
        }
    }
}

