/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.internals.FetchBuffer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.WakeupException;

public class WakeupTrigger {
    private final AtomicReference<Wakeupable> pendingTask = new AtomicReference<Object>(null);

    public void wakeup() {
        this.pendingTask.getAndUpdate(task -> {
            if (task == null) {
                return new WakeupFuture();
            }
            if (task instanceof ActiveFuture) {
                ActiveFuture active = (ActiveFuture)task;
                boolean wasTriggered = active.future().completeExceptionally(new WakeupException());
                return wasTriggered ? null : new WakeupFuture();
            }
            if (task instanceof FetchAction) {
                FetchAction fetchAction = (FetchAction)task;
                fetchAction.fetchBuffer().wakeup();
                return new WakeupFuture();
            }
            return task;
        });
    }

    public <T> CompletableFuture<T> setActiveTask(CompletableFuture<T> currentTask) {
        Objects.requireNonNull(currentTask, "currentTask cannot be null");
        this.pendingTask.getAndUpdate(task -> {
            if (task == null) {
                return new ActiveFuture(currentTask);
            }
            if (task instanceof WakeupFuture) {
                currentTask.completeExceptionally(new WakeupException());
                return null;
            }
            if (task instanceof DisabledWakeups) {
                return task;
            }
            throw new KafkaException("Last active task is still active");
        });
        return currentTask;
    }

    public void setFetchAction(FetchBuffer fetchBuffer) {
        AtomicBoolean throwWakeupException = new AtomicBoolean(false);
        this.pendingTask.getAndUpdate(task -> {
            if (task == null) {
                return new FetchAction(fetchBuffer);
            }
            if (task instanceof WakeupFuture) {
                throwWakeupException.set(true);
                return null;
            }
            if (task instanceof DisabledWakeups) {
                return task;
            }
            throw new IllegalStateException("Last active task is still active");
        });
        if (throwWakeupException.get()) {
            throw new WakeupException();
        }
    }

    public void disableWakeups() {
        this.pendingTask.set(new DisabledWakeups());
    }

    public void clearTask() {
        this.pendingTask.getAndUpdate(task -> {
            if (task == null) {
                return null;
            }
            if (task instanceof ActiveFuture || task instanceof FetchAction) {
                return null;
            }
            return task;
        });
    }

    public void maybeTriggerWakeup() {
        AtomicBoolean throwWakeupException = new AtomicBoolean(false);
        this.pendingTask.getAndUpdate(task -> {
            if (task == null) {
                return null;
            }
            if (task instanceof WakeupFuture) {
                throwWakeupException.set(true);
                return null;
            }
            return task;
        });
        if (throwWakeupException.get()) {
            throw new WakeupException();
        }
    }

    Wakeupable getPendingTask() {
        return this.pendingTask.get();
    }

    static class DisabledWakeups
    implements Wakeupable {
        DisabledWakeups() {
        }
    }

    static interface Wakeupable {
    }

    static class WakeupFuture
    implements Wakeupable {
        WakeupFuture() {
        }
    }

    static class ActiveFuture
    implements Wakeupable {
        private final CompletableFuture<?> future;

        public ActiveFuture(CompletableFuture<?> future) {
            this.future = future;
        }

        public CompletableFuture<?> future() {
            return this.future;
        }
    }

    static class FetchAction
    implements Wakeupable {
        private final FetchBuffer fetchBuffer;

        public FetchAction(FetchBuffer fetchBuffer) {
            this.fetchBuffer = fetchBuffer;
        }

        public FetchBuffer fetchBuffer() {
            return this.fetchBuffer;
        }
    }
}

