/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.zk.KafkaZkClient;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CheckOp;
import kafka.zookeeper.CreateOp;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteOp;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.MultiRequest;
import kafka.zookeeper.MultiResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.SetDataOp;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.ZkOp;
import kafka.zookeeper.ZkOpResult;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import scala.Option;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class KafkaZkClient$ {
    public static final KafkaZkClient$ MODULE$ = new KafkaZkClient$();

    public KafkaZkClient apply(String connectString, boolean isSecure, int sessionTimeoutMs, int connectionTimeoutMs, int maxInFlightRequests, Time time, String name, ZKClientConfig zkClientConfig, String metricGroup, String metricType, boolean createChrootIfNecessary, boolean enableEntityConfigControllerCheck) {
        int chrootIndex;
        if (zkClientConfig.getProperty("jute.maxbuffer") == null) {
            zkClientConfig.setProperty("jute.maxbuffer", Integer.toString(0x400000));
        }
        if (createChrootIfNecessary && (chrootIndex = connectString.indexOf("/")) > 0) {
            String zkConnWithoutChrootForChrootCreation = connectString.substring(0, chrootIndex);
            try (KafkaZkClient zkClientForChrootCreation = this.apply(zkConnWithoutChrootForChrootCreation, isSecure, sessionTimeoutMs, connectionTimeoutMs, maxInFlightRequests, time, name, zkClientConfig, metricGroup, metricType, false, true);){
                String chroot = connectString.substring(chrootIndex);
                if (!zkClientForChrootCreation.pathExists(chroot)) {
                    zkClientForChrootCreation.makeSurePersistentPathExists(chroot);
                }
            }
        }
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(connectString, sessionTimeoutMs, connectionTimeoutMs, maxInFlightRequests, time, metricGroup, metricType, zkClientConfig, name);
        return new KafkaZkClient(zooKeeperClient, isSecure, time, enableEntityConfigControllerCheck);
    }

    public String apply$default$9() {
        return "kafka.server";
    }

    public String apply$default$10() {
        return "SessionExpireListener";
    }

    public boolean apply$default$11() {
        return false;
    }

    public boolean apply$default$12() {
        return true;
    }

    public MultiRequest kafka$zk$KafkaZkClient$$wrapRequestWithControllerEpochCheck(AsyncRequest request, int expectedControllerZkVersion) {
        CheckOp checkOp = new CheckOp("/controller_epoch", expectedControllerZkVersion);
        if (request instanceof CreateRequest) {
            CreateRequest createRequest = (CreateRequest)request;
            String path = createRequest.path();
            byte[] data = createRequest.data();
            Seq<ACL> acl = createRequest.acl();
            CreateMode createMode = createRequest.createMode();
            Option<Object> ctx = createRequest.ctx();
            return new MultiRequest((Seq<ZkOp>)new .colon.colon((Object)checkOp, (List)new .colon.colon((Object)new CreateOp(path, data, acl, createMode), (List)Nil$.MODULE$)), ctx);
        }
        if (request instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest)request;
            String path = deleteRequest.path();
            int version = deleteRequest.version();
            Option<Object> ctx = deleteRequest.ctx();
            return new MultiRequest((Seq<ZkOp>)new .colon.colon((Object)checkOp, (List)new .colon.colon((Object)new DeleteOp(path, version), (List)Nil$.MODULE$)), ctx);
        }
        if (request instanceof SetDataRequest) {
            SetDataRequest setDataRequest = (SetDataRequest)request;
            String path = setDataRequest.path();
            byte[] data = setDataRequest.data();
            int version = setDataRequest.version();
            Option<Object> ctx = setDataRequest.ctx();
            return new MultiRequest((Seq<ZkOp>)new .colon.colon((Object)checkOp, (List)new .colon.colon((Object)new SetDataOp(path, data, version), (List)Nil$.MODULE$)), ctx);
        }
        throw new IllegalStateException(new StringBuilder(37).append(request).append(" does not need controller epoch check").toString());
    }

    public void kafka$zk$KafkaZkClient$$handleUnwrappedCheckOp(CheckOp checkOp, OpResult checkOpResult) {
        if (checkOpResult instanceof OpResult.ErrorResult) {
            OpResult.ErrorResult errorResult = (OpResult.ErrorResult)checkOpResult;
            if (checkOp.path().equals("/controller_epoch")) {
                KeeperException.Code errorCode;
                KeeperException.Code code = errorCode = KeeperException.Code.get((int)errorResult.getErr());
                KeeperException.Code code2 = KeeperException.Code.BADVERSION;
                if (!(code != null ? !code.equals(code2) : code2 != null)) {
                    throw new ControllerMovedException(new StringBuilder(61).append("Controller epoch zkVersion check fails. Expected zkVersion = ").append(checkOp.version()).toString());
                }
                KeeperException.Code code3 = errorCode;
                KeeperException.Code code4 = KeeperException.Code.OK;
                if (code3 == null ? code4 != null : !code3.equals(code4)) {
                    throw KeeperException.create((KeeperException.Code)errorCode, (String)checkOp.path());
                }
                return;
            }
            return;
        }
    }

    public AsyncResponse kafka$zk$KafkaZkClient$$handleUnwrappedZkOp(ZkOpResult zkOpResult, KeeperException.Code resultCode, Option<Object> ctx, ResponseMetadata responseMetadata) {
        OpResult rawOpResult = zkOpResult.rawOpResult();
        ZkOp zkOp = zkOpResult.zkOp();
        if (zkOp instanceof CreateOp) {
            CreateOp createOp = (CreateOp)zkOp;
            String name = rawOpResult instanceof OpResult.CreateResult ? ((OpResult.CreateResult)rawOpResult).getPath() : null;
            return new CreateResponse(resultCode, createOp.path(), ctx, name, responseMetadata);
        }
        if (zkOp instanceof DeleteOp) {
            DeleteOp deleteOp = (DeleteOp)zkOp;
            return new DeleteResponse(resultCode, deleteOp.path(), ctx, responseMetadata);
        }
        if (zkOp instanceof SetDataOp) {
            SetDataOp setDataOp = (SetDataOp)zkOp;
            Stat stat = rawOpResult instanceof OpResult.SetDataResult ? ((OpResult.SetDataResult)rawOpResult).getStat() : null;
            return new SetDataResponse(resultCode, setDataOp.path(), ctx, stat, responseMetadata);
        }
        throw new IllegalStateException(new StringBuilder(17).append("Unexpected zkOp: ").append(zkOp).toString());
    }

    public AsyncResponse kafka$zk$KafkaZkClient$$unwrapResponseWithControllerEpochCheck(AsyncResponse response) {
        if (response instanceof MultiResponse) {
            SeqOps seqOps;
            MultiResponse multiResponse = (MultiResponse)response;
            KeeperException.Code resultCode = multiResponse.resultCode();
            Option<Object> ctx = multiResponse.ctx();
            Seq<ZkOpResult> zkOpResults = multiResponse.zkOpResults();
            ResponseMetadata responseMetadata = multiResponse.metadata();
            if (zkOpResults != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq(zkOpResults))) {
                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                    ZkOpResult zkOpResult = (ZkOpResult)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    ZkOpResult zkOpResult2 = (ZkOpResult)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                    if (zkOpResult != null) {
                        ZkOp checkOp = zkOpResult.zkOp();
                        OpResult checkOpResult = zkOpResult.rawOpResult();
                        if (checkOp instanceof CheckOp) {
                            CheckOp checkOp2 = (CheckOp)checkOp;
                            this.kafka$zk$KafkaZkClient$$handleUnwrappedCheckOp(checkOp2, checkOpResult);
                            return this.kafka$zk$KafkaZkClient$$handleUnwrappedZkOp(zkOpResult2, resultCode, ctx, responseMetadata);
                        }
                    }
                }
            }
            if (zkOpResults == null) {
                throw KeeperException.create((KeeperException.Code)resultCode);
            }
            throw new IllegalStateException(new StringBuilder(86).append("Cannot unwrap ").append(response).append(" because the first zookeeper op is not check op in original MultiRequest").toString());
        }
        throw new IllegalStateException(new StringBuilder(48).append("Cannot unwrap ").append(response).append(" because it is not a MultiResponse").toString());
    }

    public KafkaZkClient createZkClient(String name, Time time, KafkaConfig config, ZKClientConfig zkClientConfig) {
        boolean isZkSecurityEnabled;
        boolean secureAclsEnabled = config.zkEnableSecureAcls();
        boolean bl = isZkSecurityEnabled = JaasUtils.isZkSaslEnabled() || KafkaConfig$.MODULE$.zkTlsClientAuthEnabled(zkClientConfig);
        if (secureAclsEnabled && !isZkSecurityEnabled) {
            throw new SecurityException(new StringBuilder(247).append("zookeeper.set.acl is true, but ZooKeeper client TLS configuration identifying at least zookeeper.ssl.client.enable, zookeeper.clientCnxnSocket, and zookeeper.ssl.keystore.location was not present and the verification of the JAAS login file failed ").append(JaasUtils.zkSecuritySysConfigString()).toString());
        }
        String x$1 = config.zkConnect();
        int x$3 = config.zkSessionTimeoutMs();
        int x$4 = config.zkConnectionTimeoutMs();
        int x$5 = config.zkMaxInFlightRequests();
        String x$10 = "kafka.server";
        String x$11 = "SessionExpireListener";
        boolean x$12 = true;
        return this.apply(x$1, secureAclsEnabled, x$3, x$4, x$5, time, name, zkClientConfig, x$10, x$11, true, x$12);
    }

    private KafkaZkClient$() {
    }
}

