/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import kafka.server.CachedControllerId;
import kafka.server.KRaftCachedControllerId$;
import kafka.server.MetadataCache;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015h\u0001B\u001b7\u0001uB\u0001B\u0015\u0001\u0003\u0006\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0011)A\u0005)\"A\u0001\f\u0001BC\u0002\u0013\u0005\u0011\f\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003[\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001d1\b\u00011A\u0005\n]DqA \u0001A\u0002\u0013%q\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0015\u0002=\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA-\u0001\u0011%\u00111\f\u0005\b\u0003\u0003\u0004A\u0011BAb\u0011\u001d\ti\u000f\u0001C\u0005\u0003_DqAa\u0001\u0001\t\u0013\u0011)\u0001C\u0004\u0003\u0016\u0001!IAa\u0006\t\u000f\tu\u0001\u0001\"\u0003\u0003 !9!1\u0007\u0001\u0005B\tU\u0002\"\u0003B-\u0001E\u0005I\u0011\u0001B.\u0011%\u0011\t\bAI\u0001\n\u0003\u0011Y\u0006C\u0004\u0003t\u0001!\tA!\u001e\t\u000f\t]\u0005\u0001\"\u0011\u0003\u001a\"9!1\u0014\u0001\u0005B\tu\u0005b\u0002BU\u0001\u0011\u0005#1\u0016\u0005\b\u0005k\u0003A\u0011\tB\\\u0011\u001d\u0011y\f\u0001C!\u0005\u0003DqA!2\u0001\t\u0003\u00119\rC\u0004\u0003L\u0002!\tA!4\t\u000f\tE\u0007\u0001\"\u0011\u0003T\"9!\u0011\u001b\u0001\u0005\n\t\u001d\bb\u0002Bv\u0001\u0011\u0005#Q\u001e\u0005\b\u0005g\u0004A\u0011\tB{\u0011\u001d\u0011Y\u0010\u0001C!\u0005{Dqa!\u0006\u0001\t\u0003\u001a9\u0002C\u0004\u0004\u001e\u0001!\tea\b\t\u000f\r\u001d\u0002\u0001\"\u0011\u0004*!91Q\u0006\u0001\u0005B\r=\u0002bBB\u001a\u0001\u0011\u00053Q\u0007\u0005\b\u0007{\u0001A\u0011IB \u0011\u001d\u0019Y\u0005\u0001C!\u0007\u001bBqaa\u0016\u0001\t\u0003\u001aI\u0006C\u0004\u0004\\\u0001!Ia!\u0018\t\u000f\r\u0005\u0004\u0001\"\u0001\u0004d!91q\u000e\u0001\u0005B\rE\u0004bBB@\u0001\u0011\u00053\u0011\u0011\u0005\b\u0007\u007f\u0002A\u0011IBC\u0011\u001d\u0019I\t\u0001C\u0001\u0007\u0017Cqa!%\u0001\t\u0003\t9\u0006C\u0004\u0004\u0014\u0002!\te!&\t\u000f\r-\u0006\u0001\"\u0001\u0004.\"91q\u0018\u0001\u0005\u0002\r\u0005\u0007bBBi\u0001\u0011\u000531\u001b\u0005\b\u00077\u0004A\u0011IBo\u0005IY%+\u00194u\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u000b\u0005]B\u0014\u0001C7fi\u0006$\u0017\r^1\u000b\u0005eR\u0014AB:feZ,'OC\u0001<\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019R\u0001\u0001 E\u0011:\u0003\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013a!\u00118z%\u00164\u0007CA#G\u001b\u0005A\u0014BA$9\u00055iU\r^1eCR\f7)Y2iKB\u0011\u0011\nT\u0007\u0002\u0015*\u00111JO\u0001\u0006kRLGn]\u0005\u0003\u001b*\u0013q\u0001T8hO&tw\r\u0005\u0002P!6\ta'\u0003\u0002Rm\t\u00012i\u001c8gS\u001e\u0014V\r]8tSR|'/_\u0001\tEJ|7.\u001a:JIV\tA\u000b\u0005\u0002@+&\u0011a\u000b\u0011\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003QY'/\u00194u-\u0016\u00148/[8o'V\u0004\b\u000f\\5feV\t!\fE\u0002\\E\u0012l\u0011\u0001\u0018\u0006\u0003;z\u000b\u0001BZ;oGRLwN\u001c\u0006\u0003?\u0002\fA!\u001e;jY*\t\u0011-\u0001\u0003kCZ\f\u0017BA2]\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\bCA3o\u001b\u00051'BA4i\u0003\u0019\u0019w.\\7p]*\u0011\u0011(\u001b\u0006\u0003w)T!a\u001b7\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0017aA8sO&\u0011qN\u001a\u0002\r\u0017J\u000bg\r\u001e,feNLwN\\\u0001\u0016WJ\fg\r\u001e,feNLwN\\*vaBd\u0017.\u001a:!\u0003\u0019a\u0014N\\5u}Q\u00191\u000f^;\u0011\u0005=\u0003\u0001\"\u0002*\u0006\u0001\u0004!\u0006\"\u0002-\u0006\u0001\u0004Q\u0016!D0dkJ\u0014XM\u001c;J[\u0006<W-F\u0001y!\tIH0D\u0001{\u0015\tY\u0018.A\u0003j[\u0006<W-\u0003\u0002~u\niQ*\u001a;bI\u0006$\u0018-S7bO\u0016\f\u0011cX2veJ,g\u000e^%nC\u001e,w\fJ3r)\u0011\t\t!a\u0002\u0011\u0007}\n\u0019!C\u0002\u0002\u0006\u0001\u0013A!\u00168ji\"A\u0011\u0011B\u0004\u0002\u0002\u0003\u0007\u00010A\u0002yIE\nabX2veJ,g\u000e^%nC\u001e,\u0007\u0005K\u0002\t\u0003\u001f\u00012aPA\t\u0013\r\t\u0019\u0002\u0011\u0002\tm>d\u0017\r^5mK\u0006AR.Y=cK\u001aKG\u000e^3s\u00032Lg/\u001a*fa2L7-Y:\u0015\u0015\u0005e\u0011QFA\u0018\u0003s\tY\u0005\u0005\u0004\u0002\u001c\u0005u\u0011\u0011E\u0007\u0002=&\u0019\u0011q\u00040\u0003\t1K7\u000f\u001e\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u00051\u0002\t1\fgnZ\u0005\u0005\u0003W\t)CA\u0004J]R,w-\u001a:\t\u000bmL\u0001\u0019\u0001=\t\u000f\u0005E\u0012\u00021\u0001\u00024\u00059!M]8lKJ\u001c\b\u0003B \u00026QK1!a\u000eA\u0005\u0015\t%O]1z\u0011\u001d\tY$\u0003a\u0001\u0003{\tA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B!a\u0010\u0002H5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0004oKR<xN]6\u000b\u0005\u001dL\u0017\u0002BA%\u0003\u0003\u0012A\u0002T5ti\u0016tWM\u001d(b[\u0016Dq!!\u0014\n\u0001\u0004\ty%\u0001\u000egS2$XM]+oCZ\f\u0017\u000e\\1cY\u0016,e\u000e\u001a9pS:$8\u000fE\u0002@\u0003#J1!a\u0015A\u0005\u001d\u0011un\u001c7fC:\fAbY;se\u0016tG/S7bO\u0016$\u0012\u0001_\u0001\u0015O\u0016$\b+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u0015\u0019\u0005u\u0013\u0011UAR\u0003o\u000bI,!0\u0011\u000b}\ny&a\u0019\n\u0007\u0005\u0005\u0004I\u0001\u0004PaRLwN\u001c\t\u0007\u0003K\n)(a\u001f\u000f\t\u0005\u001d\u0014\u0011\u000f\b\u0005\u0003S\ny'\u0004\u0002\u0002l)\u0019\u0011Q\u000e\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0015bAA:\u0001\u00069\u0001/Y2lC\u001e,\u0017\u0002BA<\u0003s\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003g\u0002\u0005\u0003BA?\u00037sA!a \u0002\u0016:!\u0011\u0011QAI\u001d\u0011\t\u0019)a$\u000f\t\u0005\u0015\u0015Q\u0012\b\u0005\u0003\u000f\u000bYI\u0004\u0003\u0002j\u0005%\u0015\"A7\n\u0005-d\u0017BA\u001ek\u0013\t9\u0017.\u0003\u0003\u0002\u0014\u0006\u0015\u0013aB7fgN\fw-Z\u0005\u0005\u0003/\u000bI*\u0001\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u0003'\u000b)%\u0003\u0003\u0002\u001e\u0006}%!G'fi\u0006$\u0017\r^1SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:TA!a&\u0002\u001a\")1p\u0003a\u0001q\"9\u0011QU\u0006A\u0002\u0005\u001d\u0016!\u0003;pa&\u001cg*Y7f!\u0011\tI+!-\u000f\t\u0005-\u0016Q\u0016\t\u0004\u0003S\u0002\u0015bAAX\u0001\u00061\u0001K]3eK\u001aLA!a-\u00026\n11\u000b\u001e:j]\u001eT1!a,A\u0011\u001d\tYd\u0003a\u0001\u0003{Aq!a/\f\u0001\u0004\ty%A\rfeJ|'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bbBA`\u0017\u0001\u0007\u0011qJ\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148/\u0001\u0017hKR\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019$pe\u0012+7o\u0019:jE\u0016$v\u000e]5d%\u0016\u001c\bo\u001c8tKRa\u0011QYAp\u0003C\f\u0019/!:\u0002jB1q(a2\u0002LRK1!!3A\u0005\u0019!V\u000f\u001d7feA)q(a\u0018\u0002NB1\u0011QMAh\u0003#LA!a\b\u0002zA!\u00111[Am\u001d\u0011\ty(!6\n\t\u0005]\u0017\u0011T\u0001$\t\u0016\u001c8M]5cKR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\tY.!8\u0003Q\u0011+7o\u0019:jE\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c(+Z:q_:\u001cX\rU1si&$\u0018n\u001c8\u000b\t\u0005]\u0017\u0011\u0014\u0005\u0006w2\u0001\r\u0001\u001f\u0005\b\u0003Kc\u0001\u0019AAT\u0011\u001d\tY\u0004\u0004a\u0001\u0003{Aa!a:\r\u0001\u0004!\u0016AC:uCJ$\u0018J\u001c3fq\"1\u00111\u001e\u0007A\u0002Q\u000b\u0001\"\\1y\u0007>,h\u000e^\u0001\u0013O\u0016$xJ\u001a4mS:,'+\u001a9mS\u000e\f7\u000f\u0006\u0005\u0002\u001a\u0005E\u00181\u001fB\u0001\u0011\u0015YX\u00021\u0001y\u0011\u001d\t)0\u0004a\u0001\u0003o\f\u0011\u0002]1si&$\u0018n\u001c8\u0011\t\u0005e\u0018Q`\u0007\u0003\u0003wT!aN5\n\t\u0005}\u00181 \u0002\u0016!\u0006\u0014H/\u001b;j_:\u0014VmZ5tiJ\fG/[8o\u0011\u001d\tY$\u0004a\u0001\u0003{\t\u0001#[:SKBd\u0017nY1PM\u001ad\u0017N\\3\u0015\u0011\u0005=#q\u0001B\u0005\u0005\u0017Aq!!>\u000f\u0001\u0004\t9\u0010C\u0004\u0002<9\u0001\r!!\u0010\t\u000f\t5a\u00021\u0001\u0003\u0010\u00051!M]8lKJ\u0004B!!?\u0003\u0012%!!1CA~\u0005I\u0011%o\\6feJ+w-[:ue\u0006$\u0018n\u001c8\u0002+%\u001c(+\u001a9mS\u000e\f\u0017J\\(gM2Lg.\u001a#jeR1\u0011q\nB\r\u00057AqA!\u0004\u0010\u0001\u0004\u0011y\u0001C\u0004\u0002v>\u0001\r!a>\u0002!\u001d,G/\u00117jm\u0016,e\u000e\u001a9pS:$H\u0003\u0003B\u0011\u0005W\u0011iC!\r\u0011\u000b}\nyFa\t\u0011\t\t\u0015\"qE\u0007\u0003\u0003\u000bJAA!\u000b\u0002F\t!aj\u001c3f\u0011\u0015Y\b\u00031\u0001y\u0011\u0019\u0011y\u0003\u0005a\u0001)\u0006\u0011\u0011\u000e\u001a\u0005\b\u0003w\u0001\u0002\u0019AA\u001f\u0003A9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\u0006\u0006\u00038\t%#1\u000bB+\u0005/\u0002bA!\u000f\u0003@\t\rSB\u0001B\u001e\u0015\r\u0011i\u0004Q\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B!\u0005w\u00111aU3r!\u0011\tiH!\u0012\n\t\t\u001d\u0013q\u0014\u0002\u0016\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016$v\u000e]5d\u0011\u001d\u0011Y%\u0005a\u0001\u0005\u001b\na\u0001^8qS\u000e\u001c\bC\u0002B\u001d\u0005\u001f\n9+\u0003\u0003\u0003R\tm\"aA*fi\"9\u00111H\tA\u0002\u0005u\u0002\"CA^#A\u0005\t\u0019AA(\u0011%\ty,\u0005I\u0001\u0002\u0004\ty%\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$3'\u0006\u0002\u0003^)\"\u0011q\nB0W\t\u0011\t\u0007\u0005\u0003\u0003d\t5TB\u0001B3\u0015\u0011\u00119G!\u001b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B6\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=$Q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AG4fiR{\u0007/[2NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\"\u0014\u0001K4fiR{\u0007/[2NKR\fG-\u0019;b\r>\u0014H)Z:de&\u0014W\rV8qS\u000e\u0014Vm\u001d9p]N,G\u0003\u0004B<\u0005\u007f\u0012\u0019I!\"\u0003\u0010\nM\u0005\u0003\u0002B=\u0005wj!!!'\n\t\tu\u0014\u0011\u0014\u0002$\t\u0016\u001c8M]5cKR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u001d\u0011Y\u0005\u0006a\u0001\u0005\u0003\u0003b!!\u001a\u0002v\u0005\u001d\u0006bBA\u001e)\u0001\u0007\u0011Q\b\u0005\b\u0005\u000f#\u0002\u0019\u0001BE\u0003a!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cF/\u0019:u\u0013:$W\r\u001f\t\u0007\u007f\t-\u0015q\u0015+\n\u0007\t5\u0005IA\u0005Gk:\u001cG/[8oc!1!\u0011\u0013\u000bA\u0002Q\u000b\u0011$\\1yS6,XNT;nE\u0016\u0014xJ\u001a)beRLG/[8og\"9!Q\u0013\u000bA\u0002\u0005=\u0013AG5h]>\u0014X\rV8qS\u000e\u001cx+\u001b;i\u000bb\u001cW\r\u001d;j_:\u001c\u0018\u0001D4fi\u0006cG\u000eV8qS\u000e\u001cHC\u0001B'\u0003I9W\r\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0015\t\t}%q\u0015\t\u0007\u0005s\u0011yE!)\u0011\t\t\u0015\"1U\u0005\u0005\u0005K\u000b)E\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005\u0015f\u00031\u0001\u0002(\u0006Qq-\u001a;U_BL7-\u00133\u0015\t\t5&1\u0017\t\u0005\u0005K\u0011y+\u0003\u0003\u00032\u0006\u0015#\u0001B+vS\u0012Dq!!*\u0018\u0001\u0004\t9+\u0001\u0007hKR$v\u000e]5d\u001d\u0006lW\r\u0006\u0003\u0003:\nm\u0006#B \u0002`\u0005\u001d\u0006b\u0002B_1\u0001\u0007!QV\u0001\bi>\u0004\u0018nY%e\u00039A\u0017m]!mSZ,'I]8lKJ$B!a\u0014\u0003D\")!+\u0007a\u0001)\u0006q\u0011n\u001d\"s_.,'OR3oG\u0016$G\u0003BA(\u0005\u0013DQA\u0015\u000eA\u0002Q\u000bA#[:Ce>\\WM]*ikR$\u0018N\\4E_^tG\u0003BA(\u0005\u001fDQAU\u000eA\u0002Q\u000bqbZ3u\u00032Lg/\u001a\"s_.,'o\u001d\u000b\u0003\u0005+\u0004b!!\u001a\u0003X\nm\u0017\u0002\u0002Bm\u0003s\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0005\u0005;\u0014\u0019/\u0004\u0002\u0003`*\u0019!\u0011]5\u0002\u000b\u0005$W.\u001b8\n\t\t\u0015(q\u001c\u0002\u000f\u0005J|7.\u001a:NKR\fG-\u0019;b)\u0011\u0011)N!;\t\u000bml\u0002\u0019\u0001=\u0002%\u001d,G/\u00117jm\u0016\u0014%o\\6fe:{G-\u001a\u000b\u0007\u0005C\u0011yO!=\t\u000bIs\u0002\u0019\u0001+\t\u000f\u0005mb\u00041\u0001\u0002>\u0005\u0019r-\u001a;BY&4XM\u0011:pW\u0016\u0014hj\u001c3fgR!!q\u001fB}!\u0019\u0011IDa\u0010\u0003$!9\u00111H\u0010A\u0002\u0005u\u0012\u0001E4fiB\u000b'\u000f^5uS>t\u0017J\u001c4p)\u0019\u0011ypa\u0004\u0004\u0012A)q(a\u0018\u0004\u0002A!11AB\u0005\u001d\u0011\tyh!\u0002\n\t\r\u001d\u0011\u0011T\u0001\u001a+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0004\f\r5!\u0001H+qI\u0006$X-T3uC\u0012\fG/\u0019)beRLG/[8o'R\fG/\u001a\u0006\u0005\u0007\u000f\tI\nC\u0004\u0002&\u0002\u0002\r!a*\t\r\rM\u0001\u00051\u0001U\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t)\u0011\u0019Iba\u0007\u0011\t}\ny\u0006\u0016\u0005\b\u0003K\u000b\u0003\u0019AAT\u0003=!x\u000e]5d\u001d\u0006lWm\u001d+p\u0013\u0012\u001cHCAB\u0011!!\tYba\t\u0002(\n5\u0016bAB\u0013=\n\u0019Q*\u00199\u0002\u001fQ|\u0007/[2JIN$vNT1nKN$\"aa\u000b\u0011\u0011\u0005m11\u0005BW\u0003O\u000b1\u0002^8qS\u000eLE-\u00138g_R\u00111\u0011\u0007\t\b\u007f\u0005\u001d7\u0011EB\u0016\u0003i9W\r\u001e)beRLG/[8o\u0019\u0016\fG-\u001a:F]\u0012\u0004x.\u001b8u)!\u0011\tca\u000e\u0004:\rm\u0002bBASK\u0001\u0007\u0011q\u0015\u0005\u0007\u0007')\u0003\u0019\u0001+\t\u000f\u0005mR\u00051\u0001\u0002>\u0005ar-\u001a;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0016sG\r]8j]R\u001cHCBB!\u0007\u000b\u001aI\u0005E\u0004\u0003:\r\rCKa\t\n\t\r\u0015\"1\b\u0005\b\u0007\u000f2\u0003\u0019\u0001BQ\u0003\t!\b\u000fC\u0004\u0002<\u0019\u0002\r!!\u0010\u0002\u001f\u001d,GoQ8oiJ|G\u000e\\3s\u0013\u0012,\"aa\u0014\u0011\u000b}\nyf!\u0015\u0011\u0007\u0015\u001b\u0019&C\u0002\u0004Va\u0012!cQ1dQ\u0016$7i\u001c8ue>dG.\u001a:JI\u00061r-\u001a;SC:$w.\\!mSZ,'I]8lKJLE-\u0006\u0002\u0004\u001a\u0005!r-\u001a;SC:$w.\\!mSZ,'I]8lKJ$Ba!\u0007\u0004`!)10\u000ba\u0001q\u0006\u0019r-\u001a;BY&4XM\u0011:pW\u0016\u0014X\t]8dQR!1QMB7!\u0015y\u0014qLB4!\ry4\u0011N\u0005\u0004\u0007W\u0002%\u0001\u0002'p]\u001eDQA\u0015\u0016A\u0002Q\u000b!cZ3u\u00072,8\u000f^3s\u001b\u0016$\u0018\rZ1uCR111OB=\u0007{\u0002BA!\n\u0004v%!1qOA#\u0005\u001d\u0019E.^:uKJDqaa\u001f,\u0001\u0004\t9+A\u0005dYV\u001cH/\u001a:JI\"9\u00111H\u0016A\u0002\u0005u\u0012\u0001C2p]R\f\u0017N\\:\u0015\t\u0005=31\u0011\u0005\b\u0003Kc\u0003\u0019AAT)\u0011\tyea\"\t\u000f\r\u001dS\u00061\u0001\u0003\"\u0006A1/\u001a;J[\u0006<W\r\u0006\u0003\u0002\u0002\r5\u0005BBBH]\u0001\u0007\u00010\u0001\u0005oK^LU.Y4f\u0003!9W\r^%nC\u001e,\u0017AB2p]\u001aLw\r\u0006\u0003\u0004\u0018\u000eu\u0005\u0003BA\u000e\u00073K1aa'_\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0007?\u0003\u0004\u0019ABQ\u00039\u0019wN\u001c4jOJ+7o\\;sG\u0016\u0004Baa)\u0004(6\u00111Q\u0015\u0006\u0005\u0007'\u000b)%\u0003\u0003\u0004*\u000e\u0015&AD\"p]\u001aLwMU3t_V\u00148-Z\u0001\u0015I\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:\u0015\t\r=6Q\u0017\t\u0005\u0005s\u001a\t,\u0003\u0003\u00044\u0006e%\u0001\t#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7OU3ta>t7/\u001a#bi\u0006Dqaa.2\u0001\u0004\u0019I,A\u0004sKF,Xm\u001d;\u0011\t\te41X\u0005\u0005\u0007{\u000bIJA\u0010EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d*fcV,7\u000f\u001e#bi\u0006\f\u0001\u0004Z3tGJL'-Z*de\u0006l7I]3eK:$\u0018.\u00197t)\u0011\u0019\u0019m!3\u0011\t\te4QY\u0005\u0005\u0007\u000f\fIJ\u0001\u0015EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0004\u00048J\u0002\raa3\u0011\t\te4QZ\u0005\u0005\u0007\u001f\fIJA\u0014EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;ECR\f\u0017aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0015\u0005\rU\u0007cA3\u0004X&\u00191\u0011\u001c4\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\f\u0001BZ3biV\u0014Xm\u001d\u000b\u0003\u0007?\u00042!ZBq\u0013\r\u0019\u0019O\u001a\u0002\u0012\r&t\u0017\r\\5{K\u00124U-\u0019;ve\u0016\u001c\b")
public class KRaftMetadataCache
implements MetadataCache,
Logging,
ConfigRepository {
    private final int brokerId;
    private final Supplier<KRaftVersion> kraftVersionSupplier;
    private volatile MetadataImage _currentImage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Supplier<KRaftVersion> kraftVersionSupplier() {
        return this.kraftVersionSupplier;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), (Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return new Some((Object)((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1 & Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition$1.leader).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            })).iterator());
        }
        throw new MatchError((Object)option);
    }

    private Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> getPartitionMetadataForDescribeTopicResponse(MetadataImage image, String topicName, ListenerName listenerName, int startIndex, int maxCount) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            ListBuffer result = new ListBuffer();
            java.util.Set partitions = topic.partitions().keySet();
            int upperIndex = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(topic.partitions().size()), startIndex + maxCount);
            int nextIndex = upperIndex < partitions.size() ? upperIndex : -1;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startIndex), upperIndex).foreach((Function1 & Serializable)partitionId -> KRaftMetadataCache.$anonfun$getPartitionMetadataForDescribeTopicResponse$1(this, topic, image, listenerName, result, topicName, BoxesRunTime.unboxToInt((Object)partitionId)));
            return new Tuple2((Object)new Some((Object)result.toList()), (Object)BoxesRunTime.boxToInteger((int)nextIndex));
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(this, image, offlineReplicas, partition, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private boolean isReplicaOffline(PartitionRegistration partition, ListenerName listenerName, BrokerRegistration broker) {
        return broker.fenced() || !broker.listeners().containsKey(listenerName.value()) || this.isReplicaInOfflineDir(broker, partition);
    }

    private boolean isReplicaInOfflineDir(BrokerRegistration broker, PartitionRegistration partition) {
        return !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    public DescribeTopicPartitionsResponseData getTopicMetadataForDescribeTopicResponse(Iterator<String> topics, ListenerName listenerName, Function1<String, Object> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        MetadataImage image = this._currentImage();
        IntRef remaining = IntRef.create((int)maximumNumberOfPartitions);
        DescribeTopicPartitionsResponseData result = new DescribeTopicPartitionsResponseData();
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> topics.foreach((Function1 & Serializable)topicName -> {
            if (remaining$1.elem > 0) {
                void var9_9;
                Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> tuple2 = this.getPartitionMetadataForDescribeTopicResponse(image, (String)topicName, listenerName, BoxesRunTime.unboxToInt((Object)topicPartitionStartIndex.apply(topicName)), remaining$1.elem);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Option partitionResponse = (Option)tuple2._1();
                int n = tuple2._2$mcI$sp();
                var9_9.map((Function1 & Serializable)partitions -> {
                    KRaftMetadataCache.$anonfun$getTopicMetadataForDescribeTopicResponse$3(topicName, image, result, n, remaining, partitions);
                    return BoxedUnit.UNIT;
                });
                if (!ignoreTopicsWithExceptions && var9_9.isEmpty()) {
                    Errors errors;
                    try {
                        Topic.validate((String)topicName);
                        errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                    }
                    catch (InvalidTopicException invalidTopicException) {
                        errors = Errors.INVALID_TOPIC_EXCEPTION;
                    }
                    Errors error = errors;
                    return BoxesRunTime.boxToBoolean((boolean)result.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(error.code()).setName(topicName).setTopicId(this.getTopicId((String)topicName)).setIsInternal(Topic.isInternal((String)topicName))));
                }
                return BoxedUnit.UNIT;
            }
            if (remaining$1.elem == 0) {
                result.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName).setPartitionIndex(0));
                throw Breaks$.MODULE$.break();
            }
            return BoxedUnit.UNIT;
        }));
        return result;
    }

    @Override
    public Set<String> getAllTopics() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByName().keySet()).asScala();
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return (Set)Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return (Set)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().keySet()).asScala().map((Function1 & Serializable)x$3 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$3)));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this._currentImage().topics().topicsByName()).asScala().get((Object)topicName).map((Function1 & Serializable)x$4 -> x$4.id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this._currentImage().topics().topicsById()).asScala().get((Object)topicId).map((Function1 & Serializable)x$5 -> x$5.name());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$6))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.fenced()))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), b.rack()));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.fenced())).flatMap((Function1 & Serializable)x$11 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$11.node(listenerName.value()))));
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.fenced()))).flatMap((Function1 & Serializable)x$13 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$13.node(listenerName.value()))))).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch).setReplicas(Replicas.toList((int[])partition.replicas))));
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some((Object)Node.noNode());
                }
                if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    return new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(image, listenerName, result, topic);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage()).map((Function1)KRaftCachedControllerId$.MODULE$);
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply((int)ThreadLocalRandom.current().nextInt((int)aliveBrokers.size()))).id));
    }

    public Option<Object> getAliveBrokerEpoch(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.fenced())).map((Function1 & Serializable)brokerRegistration -> BoxesRunTime.boxToLong((long)brokerRegistration.epoch()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().forEach((key, value) -> {
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(key), KRaftMetadataCache.node$1(value.leader, nodes), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(value.replicas), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(value.isr), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getOfflineReplicas(image, (PartitionRegistration)value, listenerName)).asScala().map((Function1 & Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey((Object)topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    public MetadataImage getImage() {
        return this._currentImage();
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersion();
    }

    @Override
    public FinalizedFeatures features() {
        MetadataImage image = this._currentImage();
        HashMap<String, Short> finalizedFeatures = new HashMap<String, Short>(image.features().finalizedVersions());
        finalizedFeatures.put("kraft.version", Predef$.MODULE$.short2Short(this.kraftVersionSupplier().get().featureLevel()));
        return new FinalizedFeatures(image.features().metadataVersion(), finalizedFeatures, image.highestOffsetAndEpoch().offset(), true);
    }

    public static final /* synthetic */ Object $anonfun$getPartitionMetadataForDescribeTopicResponse$1(KRaftMetadataCache $this, TopicImage topic$1, MetadataImage image$3, ListenerName listenerName$3, ListBuffer result$1, String topicName$2, int partitionId) {
        PartitionRegistration partitionRegistration = (PartitionRegistration)topic$1.partitions().get(BoxesRunTime.boxToInteger((int)partitionId));
        if (partitionRegistration != null) {
            java.util.List<Integer> filteredReplicas = $this.maybeFilterAliveReplicas(image$3, partitionRegistration.replicas, listenerName$3, false);
            java.util.List<Integer> filteredIsr = $this.maybeFilterAliveReplicas(image$3, partitionRegistration.isr, listenerName$3, false);
            java.util.List<Integer> offlineReplicas = $this.getOfflineReplicas(image$3, partitionRegistration, listenerName$3);
            Option<Node> maybeLeader = $this.getAliveEndpoint(image$3, partitionRegistration.leader, listenerName$3);
            if (None$.MODULE$.equals(maybeLeader)) {
                return (ListBuffer)result$1.append((Object)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(-1).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr)));
            }
            if (maybeLeader instanceof Some) {
                Node leader = (Node)((Some)maybeLeader).value();
                return (ListBuffer)result$1.append((Object)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(leader.id()).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr)));
            }
            throw new MatchError(maybeLeader);
        }
        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("The partition ").append(partitionId).append(" does not exist for ").append(topicName$2).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(KRaftMetadataCache $this, MetadataImage image$4, ArrayList offlineReplicas$1, PartitionRegistration partition$2, ListenerName listenerName$4, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$4.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if ($this.isReplicaOffline(partition$2, listenerName$4, broker)) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadataForDescribeTopicResponse$3(String topicName$3, MetadataImage image$6, DescribeTopicPartitionsResponseData result$2, int nextPartition$1, IntRef remaining$1, List partitions) {
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic response = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicName$3).setTopicId((Uuid)Option$.MODULE$.apply((Object)image$6.topics().getTopic(topicName$3).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topicName$3)).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitions).asJava());
        result$2.topics().add((ImplicitLinkedHashCollection.Element)response);
        if (nextPartition$1 != -1) {
            result$2.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName$3).setPartitionIndex(nextPartition$1));
            throw Breaks$.MODULE$.break();
        }
        remaining$1.elem -= partitions.size();
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$6) {
        return !x$6.fenced();
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(MetadataImage image$7, ListenerName listenerName$10, scala.collection.mutable.HashMap result$3, TopicImage topic) {
        topic.partitions().values().forEach(partition -> ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1)(JFunction1.mcVI.sp & Serializable)replicaId -> {
            BrokerRegistration broker = image$7.cluster().broker(replicaId);
            if (broker != null && !broker.fenced()) {
                broker.node(listenerName$10.value()).ifPresent(node -> {
                    if (!node.isEmpty()) {
                        result$3.put((Object)BoxesRunTime.boxToInteger((int)replicaId), node);
                        return;
                    }
                });
                return;
            }
        }));
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable)() -> Node.noNode());
    }

    public KRaftMetadataCache(int brokerId, Supplier<KRaftVersion> kraftVersionSupplier) {
        this.brokerId = brokerId;
        this.kraftVersionSupplier = kraftVersionSupplier;
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
    }
}

