/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.api.Interface;
import javajs.util.BS;
import javajs.util.CifDataParser;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.V3;
import org.jmol.adapter.readers.cif.MSCifParser;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.XtalSymmetry;
import org.jmol.api.JmolAdapter;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Vibration;

public class CifReader
extends AtomSetCollectionReader {
    Parser subParser;
    private static final String titleRecords = "__citation_title__publ_section_title__active_magnetic_irreps_details__";
    private MSCifParser modr;
    GenericCifDataParser cifParser;
    private boolean isAFLOW;
    private boolean filterAssembly;
    private boolean allowRotations = true;
    private boolean readIdeal = true;
    private int configurationPtr = Integer.MIN_VALUE;
    protected boolean useAuthorChainID = true;
    protected String thisDataSetName = "";
    protected String lastDataSetName;
    private String chemicalName = "";
    private String thisStructuralFormula = "";
    private String thisFormula = "";
    protected boolean iHaveDesiredModel;
    protected boolean isMMCIF;
    protected boolean isLigand;
    protected boolean isMagCIF;
    protected boolean isSpinCIF;
    boolean haveHAtoms;
    private String molecularType = "GEOM_BOND default";
    private char lastAltLoc = '\u0000';
    private boolean haveAromatic;
    private int conformationIndex;
    private int nMolecular = 0;
    private String appendedData;
    protected boolean skipping;
    protected int nAtoms;
    protected int ac;
    private boolean haveMagneticMoments;
    private String auditBlockCode;
    private String lastSpaceGroupName;
    private boolean modulated;
    protected boolean isCourseGrained;
    boolean haveCellWaveVector;
    private boolean haveSpinReferences;
    protected Map<String, String> htGroup1;
    protected int nAtoms0;
    private int titleAtomSet = 1;
    private boolean addAtomLabelNumbers;
    private boolean ignoreGeomBonds;
    private boolean allowWyckoff = true;
    private boolean stopOn_SHELX_HKL;
    private String spinFrame;
    private String spinFrameExt;
    private boolean spinFrameSetByFILTER;
    private boolean spinOnly;
    private int maxOps = -1;
    private int nops;
    private boolean noLattice;
    static final String CAT_ENTRY = "_entry";
    private Map<String, String> htCellTypes;
    public Map<String, Integer> modelMap;
    private boolean haveGlobalDummy;
    private Hashtable<String, Object> htAudit;
    public Lst<String> symops;
    protected String pdbID;
    private Lst<String> lstSpinLattices;
    private Map<String, String> mapSpinIdToUVW;
    private byte newAtomSetLabel = (byte)-1;
    protected static final String CAT_CELL = "_cell";
    private static final String[] TransformFields = new String[]{"x[1][1]", "x[1][2]", "x[1][3]", "r[1]", "x[2][1]", "x[2][2]", "x[2][3]", "r[2]", "x[3][1]", "x[3][2]", "x[3][3]", "r[3]"};
    protected static final String CAT_ATOM_SITES = "_atom_sites";
    private Map<String, float[]> htOxStates;
    private Lst<Object[]> bondTypes = new Lst();
    private String disorderAssembly = ".";
    private String lastDisorderAssembly;
    private Lst<float[]> lattvecs;
    private Lst<String> magCenterings;
    protected int maxSerial;
    private static final byte ATOM_TYPE_SYMBOL = 0;
    private static final byte ATOM_TYPE_OXIDATION_NUMBER = 1;
    private static final byte ATOM_TYPE_RADIUS_BOND = 2;
    protected static final String CAT_ATOM_TYPE = "_atom_type";
    private static final String[] atomTypeFields = new String[]{"_atom_type_symbol", "_atom_type_oxidation_number", "_atom_type_radius_bond"};
    private static final byte JMOL_ATOM_NAME = 1;
    private static final byte JMOL_ATOM_SITE_LABEL = 2;
    private static final String[] jmolAtomFields = new String[]{"_jmol_atom_index", "_jmol_atom_name", "_jmol_atom_site_label"};
    private Map<String, String> htJmolNames;
    protected static final byte EMPTY = -2;
    protected static final byte NONE = -1;
    private static final byte TYPE_SYMBOL = 0;
    private static final byte LABEL = 1;
    private static final byte AUTH_ATOM_ID = 2;
    private static final byte FRACT_X = 3;
    private static final byte FRACT_Y = 4;
    private static final byte FRACT_Z = 5;
    private static final byte CARTN_X = 6;
    private static final byte CARTN_Y = 7;
    private static final byte CARTN_Z = 8;
    private static final byte OCCUPANCY = 9;
    private static final byte B_ISO = 10;
    private static final byte AUTH_COMP_ID = 11;
    private static final byte AUTH_ASYM_ID = 12;
    private static final byte AUTH_SEQ_ID = 13;
    private static final byte INS_CODE = 14;
    private static final byte ALT_ID = 15;
    private static final byte GROUP_PDB = 16;
    private static final byte MODEL_NO = 17;
    private static final byte DUMMY_ATOM = 18;
    private static final byte DISORDER_GROUP = 19;
    private static final byte ANISO_LABEL = 20;
    private static final byte ANISO_MMCIF_ID = 21;
    private static final byte ANISO_U11 = 22;
    private static final byte ANISO_U22 = 23;
    private static final byte ANISO_U33 = 24;
    private static final byte ANISO_U12 = 25;
    private static final byte ANISO_U13 = 26;
    private static final byte ANISO_U23 = 27;
    private static final byte ANISO_MMCIF_U11 = 28;
    private static final byte ANISO_MMCIF_U22 = 29;
    private static final byte ANISO_MMCIF_U33 = 30;
    private static final byte ANISO_MMCIF_U12 = 31;
    private static final byte ANISO_MMCIF_U13 = 32;
    private static final byte ANISO_MMCIF_U23 = 33;
    private static final byte U_ISO_OR_EQUIV = 34;
    private static final byte ANISO_B11 = 35;
    private static final byte ANISO_B22 = 36;
    private static final byte ANISO_B33 = 37;
    private static final byte ANISO_B12 = 38;
    private static final byte ANISO_B13 = 39;
    private static final byte ANISO_B23 = 40;
    private static final byte ANISO_BETA_11 = 41;
    private static final byte ANISO_BETA_22 = 42;
    private static final byte ANISO_BETA_33 = 43;
    private static final byte ANISO_BETA_12 = 44;
    private static final byte ANISO_BETA_13 = 45;
    private static final byte ANISO_BETA_23 = 46;
    private static final byte ADP_TYPE = 47;
    private static final byte CC_COMP_ID = 48;
    private static final byte CC_ATOM_ID = 49;
    private static final byte CC_ATOM_SYM = 50;
    private static final byte CC_ATOM_CHARGE = 51;
    private static final byte CC_ATOM_X = 52;
    private static final byte CC_ATOM_Y = 53;
    private static final byte CC_ATOM_Z = 54;
    private static final byte CC_ATOM_X_IDEAL = 55;
    private static final byte CC_ATOM_Y_IDEAL = 56;
    private static final byte CC_ATOM_Z_IDEAL = 57;
    private static final byte DISORDER_ASSEMBLY = 58;
    private static final byte LABEL_ASYM_ID = 59;
    private static final byte SUBSYS_ID = 60;
    private static final byte SYMMETRY_MULT = 61;
    private static final byte THERMAL_TYPE = 62;
    private static final byte MOMENT_LABEL = 63;
    private static final byte MOMENT_PRELIM_X = 64;
    private static final byte MOMENT_PRELIM_Y = 65;
    private static final byte MOMENT_PRELIM_Z = 66;
    private static final byte MOMENT_X = 67;
    private static final byte MOMENT_Y = 68;
    private static final byte MOMENT_Z = 69;
    private static final byte ATOM_ID = 70;
    private static final byte LABEL_SEQ_ID = 71;
    private static final byte LABEL_COMP_ID = 72;
    private static final byte LABEL_ATOM_ID = 73;
    private static final byte WYCKOFF_LABEL = 74;
    private static final byte SITE_SYMMETRY_MULTIPLICITY = 75;
    private static final byte SPIN_U_PRELIM = 76;
    private static final byte SPIN_V_PRELIM = 77;
    private static final byte SPIN_W_PRELIM = 78;
    private static final byte spin_moment_label = 79;
    private static final byte spin_moment_axis_u = 80;
    private static final byte spin_moment_axis_v = 81;
    private static final byte spin_moment_axis_w = 82;
    private static final byte spin_moment_symmform_uvw = 83;
    private static final byte spin_moment_magnitude = 84;
    private static final byte spin_moment_spherical_azimuthal = 85;
    private static final byte spin_moment_spherical_polar = 86;
    protected static final String CAT_ATOM_SITE = "_atom_site";
    private static final String[] atomFields = new String[]{"*_type_symbol", "*_label", "*_auth_atom_id", "*_fract_x", "*_fract_y", "*_fract_z", "*_cartn_x", "*_cartn_y", "*_cartn_z", "*_occupancy", "*_b_iso_or_equiv", "*_auth_comp_id", "*_auth_asym_id", "*_auth_seq_id", "*_pdbx_pdb_ins_code", "*_label_alt_id", "*_group_pdb", "*_pdbx_pdb_model_num", "*_calc_flag", "*_disorder_group", "*_aniso_label", "*_anisotrop_id", "*_aniso_u_11", "*_aniso_u_22", "*_aniso_u_33", "*_aniso_u_12", "*_aniso_u_13", "*_aniso_u_23", "*_anisotrop_u[1][1]", "*_anisotrop_u[2][2]", "*_anisotrop_u[3][3]", "*_anisotrop_u[1][2]", "*_anisotrop_u[1][3]", "*_anisotrop_u[2][3]", "*_u_iso_or_equiv", "*_aniso_b_11", "*_aniso_b_22", "*_aniso_b_33", "*_aniso_b_12", "*_aniso_b_13", "*_aniso_b_23", "*_aniso_beta_11", "*_aniso_beta_22", "*_aniso_beta_33", "*_aniso_beta_12", "*_aniso_beta_13", "*_aniso_beta_23", "*_adp_type", "_chem_comp_atom_comp_id", "_chem_comp_atom_atom_id", "_chem_comp_atom_type_symbol", "_chem_comp_atom_charge", "_chem_comp_atom_model_cartn_x", "_chem_comp_atom_model_cartn_y", "_chem_comp_atom_model_cartn_z", "_chem_comp_atom_pdbx_model_cartn_x_ideal", "_chem_comp_atom_pdbx_model_cartn_y_ideal", "_chem_comp_atom_pdbx_model_cartn_z_ideal", "*_disorder_assembly", "*_label_asym_id", "*_subsystem_code", "*_symmetry_multiplicity", "*_thermal_displace_type", "*_moment_label", "*_moment_crystalaxis_mx", "*_moment_crystalaxis_my", "*_moment_crystalaxis_mz", "*_moment_crystalaxis_x", "*_moment_crystalaxis_y", "*_moment_crystalaxis_z", "*_id", "*_label_seq_id", "*_label_comp_id", "*_label_atom_id", "*_wyckoff_label", "*_site_symmetry_multiplicity", "*_moment_spinaxis_u", "*_moment_spinaxis_v", "*_moment_spinaxis_w", "*_spin_moment_label", "*_spin_moment_axis_u", "*_spin_moment_axis_v", "*_spin_moment_axis_w", "*_spin_moment_symmform_uvw", "*_spin_moment_magnitude", "*_spin_moment_spherical_azimuthal", "*_spin_moment_spherical_polar"};
    private static final byte CITATION_TITLE = 0;
    private static final String[] citationFields = new String[]{"_citation_title"};
    private static final byte SYM_XYZ = 0;
    private static final byte SYM_MAGN_XYZ = 1;
    private static final byte SYM_SSG_ALG = 2;
    private static final byte SYM_MAGN_SSG_ALG = 3;
    private static final byte SYM_EQ_XYZ = 4;
    private static final byte SYM_SSG_EQ_XYZ = 5;
    private static final byte SYM_MAGN_REV = 7;
    private static final byte SYM_MAGN_SSG_REV = 8;
    private static final byte SYM_MAGN_REV_PRELIM = 6;
    private static final byte SYM_MAGN_CENTERING = 9;
    private static final byte SYM_MAGN_SSG_CENTERING = 10;
    private static final byte SYM_MAGN_SSG_CENT_XYZ = 11;
    private static final byte SYM_SPIN_LATTICE_XYZT = 12;
    private static final byte SYM_SPIN_LATTICE_UVW = 13;
    private static final byte SYM_SPIN_LATTICE_UVW_ID = 14;
    private static final byte SYM_SPIN_OP_XYZT = 15;
    private static final byte SYM_SPIN_OP_UVW = 16;
    private static final byte SYM_SPIN_OP_UVW_ID = 17;
    private static final byte SYM_SPIN_UPART_ID = 18;
    private static final byte SYM_SPIN_UPART_UVW = 19;
    private static final String CAT_SGOP = "_space_group_symop";
    private static final String[] symmetryOperationsFields = new String[]{"*_operation_xyz", "*_magn_operation_xyz", "*_ssg_operation_algebraic", "*_magn_ssg_operation_algebraic", "_symmetry_equiv_pos_as_xyz", "_symmetry_ssg_equiv_pos_as_xyz", "*_magn_operation_timereversal", "*_magn_ssg_operation_timereversal", "*_operation_timereversal", "*_magn_centering_xyz", "*_magn_ssg_centering_algebraic", "*_magn_ssg_centering_xyz", "*_spin_lattice_xyzt", "*_spin_lattice_uvw", "*_spin_lattice_uvw_id", "*_spin_operation_xyzt", "*_spin_operation_uvw", "*_spin_operation_uvw_id", "*_spin_upart_id", "*_spin_upart_uvw"};
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 0;
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 1;
    private static final byte GEOM_BOND_DISTANCE = 2;
    private static final byte CCDC_GEOM_BOND_TYPE = 3;
    private static final String[] geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2", "_geom_bond_distance", "_ccdc_geom_bond_type"};
    private float[] atomRadius;
    private BS[] bsConnected;
    private BS[] bsSets;
    private final P3 ptOffset = new P3();
    private BS bsMolecule;
    private BS bsExclude;
    private int firstAtom;
    private Atom[] atoms;
    private BS bsBondDuplicates;
    String key;
    String key0;
    Object field;
    protected boolean isLoop;
    int[] col2key = new int[100];
    int[] key2col = new int[100];
    protected char firstChar = '\u0000';

    @Override
    public void initializeReader() throws Exception {
        this.initSubclass();
        this.stopOn_SHELX_HKL = this.checkFilterKey("STOPONSHELXHKL");
        this.allowPDBFilter = true;
        this.appendedData = (String)this.htParams.get("appendedData");
        this.spinOnly = this.checkFilterKey("SPINONLY");
        this.noLattice = this.checkFilterKey("NOLATTICE");
        String conf = this.getFilter("CONF ");
        if (conf != null) {
            this.configurationPtr = this.parseIntStr(conf);
        }
        if (this.filterCased != null && this.filterCased.toLowerCase().startsWith("spinframe=")) {
            this.spinFrame = this.filterCased.substring(10).trim();
            int pt = this.spinFrame.indexOf(";");
            if (pt >= 0) {
                this.spinFrame = this.spinFrame.substring(0, pt);
            }
            this.spinFrameSetByFILTER = true;
        }
        this.isMolecular = this.checkFilterKey("MOLECUL") && !this.checkFilterKey("BIOMOLECULE");
        this.ignoreGeomBonds = this.checkFilterKey("IGNOREGEOMBOND") || this.checkFilterKey("IGNOREBOND");
        this.isPrimitive = this.checkFilterKey("PRIMITIVE");
        this.readIdeal = !this.checkFilterKey("NOIDEAL");
        this.allowWyckoff = !this.checkFilterKey("NOWYCKOFF");
        this.filterAssembly = this.checkFilterKey("$");
        boolean bl = this.useAuthorChainID = !this.checkFilterKey("NOAUTHORCHAINS");
        if (this.isMolecular) {
            this.forceSymmetry(false);
            this.molecularType = "filter \"MOLECULAR\"";
        }
        this.checkNearAtoms = !this.checkFilterKey("NOSPECIAL");
        boolean bl2 = this.allowRotations = !this.checkFilterKey("NOSYM");
        if (this.binaryDoc != null) {
            return;
        }
        this.readCifData();
        this.continuing = false;
    }

    protected void initSubclass() {
    }

    private void readCifData() throws Exception {
        block2: {
            this.cifParser = this.getCifDataParser();
            this.line = "";
            this.cifParser.peekToken();
            this.addAtomLabelNumbers = this.cifParser.getFileHeader().startsWith("# primitive CIF file created by Jmol");
            while (this.continueWith(this.key = (String)this.cifParser.peekToken()) && this.readEntryOrLoopData()) {
            }
            if (this.appendedData == null) break block2;
            this.cifParser = ((GenericCifDataParser)this.getInterface("javajs.util.CifDataParser")).set(null, Rdr.getBR(this.appendedData), this.debugging);
            while ((this.key = (String)this.cifParser.peekToken()) != null && this.readEntryOrLoopData()) {
            }
        }
    }

    private boolean continueWith(String key) {
        boolean ret;
        boolean isHKL = false;
        boolean bl = ret = key != null && (!this.stopOn_SHELX_HKL || this.ac == 0 || !key.equals("_shelx_hkl_file"));
        if (ret && isHKL) {
            System.err.println("CIFReader reading _shelx_hkl_file; use FILTER 'StopOnShelxHKL' to stop reading when this is found");
        }
        return ret;
    }

    protected GenericCifDataParser getCifDataParser() {
        return new CifDataParser().set(this, null, this.debugging);
    }

    private boolean readEntryOrLoopData() throws Exception {
        if (this.key.startsWith("data_")) {
            return this.newData();
        }
        if (this.skipping && this.key.equals("_audit_block_code")) {
            this.iHaveDesiredModel = false;
            this.skipping = false;
        }
        this.isLoop = this.isLoopKey();
        if (this.isLoop) {
            if (this.skipping && !this.isMMCIF) {
                this.cifParser.getTokenPeeked();
                this.skipLoop(false);
            } else {
                this.processLoopBlock();
            }
            return true;
        }
        if (this.key.indexOf("_") != 0) {
            Logger.warn(this.key.startsWith("save_") ? "CIF reader ignoring save_" : "CIF ERROR ? should be an underscore: " + this.key);
            this.cifParser.getTokenPeeked();
        } else if (!this.getData()) {
            return true;
        }
        if (!this.skipping) {
            this.key0 = this.key;
            this.key = this.cifParser.fixKey(this.key0);
            if (this.key.startsWith("_chemical_name") || this.key.equals("_chem_comp_name")) {
                this.processChemicalInfo("name");
            } else if (this.key.startsWith("_chemical_formula_structural")) {
                this.processChemicalInfo("structuralFormula");
            } else if (this.key.startsWith("_chemical_formula_sum") || this.key.equals("_chem_comp_formula")) {
                this.processChemicalInfo("formula");
            } else if (this.key.equals("_cell_modulation_dimension")) {
                this.modDim = this.parseIntField();
                if (this.modr != null) {
                    this.modr.setModDim(this.modDim);
                }
            } else if (!this.skipKey(this.key)) {
                if (this.key.startsWith(CAT_CELL) && this.key.indexOf("_commen_") < 0) {
                    this.processCellParameter();
                } else if (this.key.startsWith("_atom_sites_fract_tran")) {
                    this.processUnitCellTransformMatrix();
                } else if (this.key.startsWith("_audit")) {
                    if (this.key.equals("_audit_block_code")) {
                        this.auditBlockCode = CifReader.fullTrim(this.field).toUpperCase();
                        this.appendLoadNote(this.auditBlockCode);
                        if (this.htAudit != null && this.auditBlockCode.contains("_MOD_")) {
                            String key = PT.rep(this.auditBlockCode, "_MOD_", "_REFRNCE_");
                            if (this.asc.setSymmetryFromAuditBlock((XtalSymmetry.FileSymmetry)this.htAudit.get(key)) != null) {
                                this.unitCellParams = this.asc.getSymmetry().getUnitCellParams();
                                this.iHaveUnitCell = true;
                            }
                        } else if (this.htAudit != null && this.symops != null) {
                            for (int i = 0; i < this.symops.size(); ++i) {
                                this.setSymmetryOperator((String)this.symops.get(i));
                            }
                        }
                        if (this.lastSpaceGroupName != null) {
                            this.setSpaceGroupName(this.lastSpaceGroupName);
                        }
                    } else if (this.key.equals("_audit_creation_date")) {
                        this.symmetry = null;
                    }
                } else if (this.key.startsWith("_chem_comp_atom") || this.key.startsWith("_atom")) {
                    this.processLoopBlock();
                } else if (this.key.startsWith("_symmetry_space_group_name_h-m") || this.key.equals("_space_group_it_number") || this.key.startsWith("_symmetry_space_group_name_hall") || this.key.startsWith("_space_group_name") || this.key.contains("_ssg_name") || this.key.contains("_magn_name") || this.key.contains("_bns_name") || this.key.contains("_spin_number_")) {
                    this.processSymmetrySpaceGroupName();
                } else if (this.key.startsWith("_space_group_transform") || this.key.startsWith("_parent_space_group") || this.key.startsWith("_space_group_magn_transform") || this.key.contains("_space_group_spin")) {
                    this.processUnitCellTransform();
                } else if (this.key.contains("_database_code")) {
                    this.addModelTitle("ID");
                } else if (titleRecords.contains("_" + this.key + "__")) {
                    this.addModelTitle("TITLE");
                } else if (this.key.startsWith("_aflow_")) {
                    this.isAFLOW = true;
                } else if (this.key.equals("_symmetry_int_tables_number")) {
                    int intTableNo = this.parseIntStr((String)this.field);
                    this.rotateHexCell = this.isAFLOW && intTableNo >= 143 && intTableNo <= 194;
                } else if (this.key.equals("_entry_id")) {
                    this.pdbID = (String)this.field;
                } else if (this.key.startsWith("_topol_")) {
                    this.getTopologyParser().ProcessRecord(this.key, (String)this.field);
                } else {
                    this.processSubclassEntry();
                }
            }
        }
        return true;
    }

    @Override
    public int setSymmetryOperator(String xyz) {
        if (this.maxOps >= 0 && this.nops++ > this.maxOps) {
            return 0;
        }
        return super.setSymmetryOperator(xyz);
    }

    private boolean newData() throws Exception {
        if (!this.spinFrameSetByFILTER) {
            this.spinFrame = null;
        }
        this.spinFrameExt = null;
        this.isLigand = false;
        if (this.asc.atomSetCount == 0) {
            this.iHaveDesiredModel = false;
        }
        if (this.iHaveDesiredModel) {
            return false;
        }
        if (this.desiredModelNumber != Integer.MIN_VALUE) {
            this.appendLoadNote(null);
        }
        this.newModel(-1);
        this.haveCellWaveVector = false;
        if (this.auditBlockCode == null) {
            this.modulated = false;
        }
        if (!this.skipping) {
            this.nAtoms0 = this.asc.ac;
            this.processDataParameter();
            this.nAtoms = this.asc.ac;
        }
        return true;
    }

    private boolean skipKey(String key) {
        return key.startsWith("_shelx_") || key.startsWith("_reflns_") || key.startsWith("_diffrn_");
    }

    private void addModelTitle(String key) {
        if (this.asc.atomSetCount > this.titleAtomSet) {
            this.titleAtomSet = this.asc.atomSetCount;
            this.appendLoadNote("\nMODEL: " + this.titleAtomSet);
        }
        this.appendLoadNote(key + ": " + CifReader.fullTrim(this.field));
    }

    protected void processSubclassEntry() throws Exception {
        if (this.modDim > 0) {
            this.getModulationReader().processEntry();
        }
    }

    private void processUnitCellTransform() {
        this.field = PT.replaceAllCharacters((String)this.field, " ", "");
        if (this.key.startsWith("_space_group_spin_")) {
            this.processSpinSpaceGroup();
        } else if (this.key.contains("_from_parent") || this.key.contains("child_transform")) {
            this.addCellType("parent", (String)this.field, true);
        } else if (this.key.contains("_to_standard") || this.key.contains("transform_bns_pp_abc")) {
            this.addCellType("standard", (String)this.field, false);
        }
        this.appendLoadNote(this.key + ": " + this.field);
    }

    private void processSpinSpaceGroup() {
        String tag;
        switch (tag = this.key.substring(18)) {
            case "number_spsg_chen": {
                tag = "ssg_number";
                break;
            }
            case "name_spsg_chen": {
                tag = "ssg_name";
                break;
            }
            case "transform_spinframe_p_matrix": 
            case "transform_spinframe_p_abc": {
                String sf = this.parseUvwMath((String)this.field);
                if (this.spinFrameSetByFILTER) {
                    System.out.println("CifReader spinFrame set by user to " + this.spinFrame + " file setting ignored: " + this.field);
                } else {
                    System.out.println("CifReader spinFrame set to " + this.field + "; use load ... FILTER \"spinframe xxxxx\" to modify");
                    this.spinFrame = sf;
                }
                if (this.spinFrame.charAt(0) == '[') {
                    M4 m4 = M4.newM4(null);
                    m4.setRotationScale((M3)Escape.unescapeMatrix(this.spinFrame));
                    this.spinFrame = SymmetryOperation.getTransformABC(m4, false);
                }
                this.addCellType("spin", this.spinFrame, false);
                this.field = this.spinFrame;
                tag = "ssg_spinFrame";
                break;
            }
            case "rotation_axis_cartn": {
                this.field = this.addSpinFrameExt("axis", false);
                return;
            }
            case "rotation_axis_xyz": {
                this.field = this.addSpinFrameExt("axis", true);
                return;
            }
            case "rotation_angle": {
                this.field = this.addSpinFrameExt("angle", false);
                return;
            }
            case "collinear_direction": {
                break;
            }
            case "coplanar_perp_uvw": {
                break;
            }
            case "g0_number": {
                tag = "ssg_G0";
                break;
            }
            case "l0_number": {
                tag = "ssg_L0";
                break;
            }
            case "it": {
                tag = "ssg_it";
                break;
            }
            case "ik": {
                tag = "ssg_ik";
                break;
            }
            case "spin_part_point_group": {
                tag = "ssg_SPG";
                break;
            }
            case "transform_to_input_pp": {
                this.addCellType("input", "!" + this.field, true);
                tag = null;
                break;
            }
            case "transform_to_magnetic_primitive_pp": {
                this.addCellType("magneticprimitive", "!" + this.field, true);
                tag = null;
                break;
            }
            case "transform_to_l0std_pp": {
                this.addCellType("l0", "!" + this.field, true);
                tag = null;
                break;
            }
            case "transform_to_g0std_pp": {
                this.addCellType("g0", "!" + this.field, true);
                tag = null;
                break;
            }
            default: {
                System.err.println("CIFReader unrecognized spin key " + this.key);
                return;
            }
        }
        if (tag != null) {
            this.addMoreUnitCellInfo(tag + "=" + this.field);
        }
    }

    private String addSpinFrameExt(String name, boolean doClean) {
        String val = this.field.toString();
        if (doClean) {
            val = PT.replaceAllCharacters(val, "[]\"", "");
        }
        if (this.spinFrameExt == null) {
            this.spinFrameExt = "";
        }
        this.spinFrameExt = this.spinFrameExt + ";" + name + "=" + val + ";";
        return val;
    }

    private void addCellType(String type, String data, boolean isFrom) {
        if (this.htCellTypes == null) {
            this.htCellTypes = new Hashtable<String, String>();
        }
        if (data.startsWith("!")) {
            data = data.substring(1);
            isFrom = !isFrom;
        }
        String cell = (isFrom ? "!" : "") + data;
        this.htCellTypes.put(type, cell);
        if (type.equalsIgnoreCase(this.strSupercell)) {
            this.strSupercell = cell;
            this.htCellTypes.put("super", (isFrom ? "!" : "") + data);
            this.htCellTypes.put("conventional", (isFrom ? "" : "!") + data);
        }
    }

    private MSCifParser getModulationReader() throws Exception {
        return this.modr == null ? this.initializeMSCIF() : this.modr;
    }

    private MSCifParser initializeMSCIF() throws Exception {
        if (this.modr == null) {
            this.modr = (MSCifParser)this.getInterface("org.jmol.adapter.readers.cif.MSCifParser");
            this.ms = this.modr;
        }
        this.modulated = this.modr.initialize(this, this.modDim) > 0;
        return this.modr;
    }

    protected void newModel(int modelNo) throws Exception {
        if (modelNo < 0) {
            if (this.modelNumber == 1 && this.asc.ac == 0 && this.nAtoms == 0 && !this.haveGlobalDummy && !this.skipping) {
                this.modelNumber = 0;
                this.haveModel = false;
                this.haveGlobalDummy = true;
                this.asc.removeCurrentAtomSet();
            }
            modelNo = ++this.modelNumber;
        }
        boolean bl = this.skipping = !this.doGetModel(this.modelNumber = modelNo, null);
        if (this.skipping) {
            if (!this.isMMCIF) {
                this.cifParser.getTokenPeeked();
            }
            return;
        }
        this.chemicalName = "";
        this.thisStructuralFormula = "";
        this.thisFormula = "";
        this.iHaveDesiredModel = this.isLastModel(this.modelNumber);
        if (this.isCourseGrained) {
            this.asc.setCurrentModelInfo("courseGrained", Boolean.TRUE);
        }
        if (this.nAtoms0 > 0 && this.nAtoms0 == this.asc.ac) {
            --this.modelNumber;
            this.haveModel = false;
            this.asc.removeCurrentAtomSet();
        } else if (this.asc.iSet >= 0) {
            this.applySymmetryAndSetTrajectory();
        }
        this.isMolecular = false;
        if (this.auditBlockCode == null) {
            this.modDim = 0;
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        if (this.htOxStates != null) {
            this.setOxidationStates();
        }
        if (this.htJmolNames != null) {
            this.setJmolNames();
        }
        if (this.asc.iSet > 0 && this.asc.getAtomSetAtomCount(this.asc.iSet) == 0) {
            --this.asc.atomSetCount;
        } else if (!this.finalizeSubclass()) {
            this.applySymmetryAndSetTrajectory();
        }
        int n = this.asc.atomSetCount;
        if (n > 1) {
            this.asc.setCollectionName("<collection of " + n + " models>");
        }
        if (this.pdbID != null) {
            this.asc.setCurrentModelInfo("pdbID", this.pdbID);
        }
        this.finalizeReaderASCR();
        this.addHeader();
        if (this.haveAromatic) {
            this.addJmolScript("calculate aromatic");
        }
        if (!this.isMMCIF && this.asc.xtalSymmetry != null) {
            this.asc.xtalSymmetry.setPartProperty();
        }
    }

    private void setOxidationStates() {
        int i = this.asc.ac;
        while (--i >= 0) {
            float[] data;
            Atom a = this.asc.atoms[i];
            String sym = a.typeSymbol;
            if (sym == null || (data = this.htOxStates.get(sym)) == null) continue;
            float charge = data[0];
            float radius = data[1];
            if (!Float.isNaN(charge)) {
                a.formalCharge = Math.round(charge);
            }
            if (Float.isNaN(radius)) continue;
            a.bondingRadius = radius;
        }
    }

    protected void addHeader() {
        String header = this.cifParser.getFileHeader();
        if (header.length() > 0) {
            String s = this.setLoadNote();
            this.appendLoadNote(null);
            this.appendLoadNote(header);
            this.appendLoadNote(s);
            this.setLoadNote();
            this.asc.setInfo("fileHeader", header);
        }
    }

    protected boolean finalizeSubclass() throws Exception {
        return this.subParser == null ? false : this.subParser.finalizeReader();
    }

    @Override
    public void doPreSymmetry(boolean doApplySymmetry) throws Exception {
        Lst<String> lst;
        if (this.mapSpinIdToUVW != null) {
            this.asc.getSymmetry().mapSpins(this.mapSpinIdToUVW);
        } else if (this.haveSpinReferences) {
            this.lstSpinLattices = null;
            this.appendLoadNote("Warning: CIF FILE contains _space_group_symop_spin_lattice_R.uvw_id but not _space_group_symop_spin_operation_U.uvw!");
        }
        if (this.magCenterings != null || this.lstSpinLattices != null) {
            this.addLatticeVectors();
        }
        if (this.modDim > 0) {
            this.getModulationReader().setModulation(false, null);
        }
        if (this.isMagCIF || this.isSpinCIF) {
            if (!this.haveMagneticMoments) {
                this.isSpinCIF = false;
                this.isMagCIF = false;
            } else {
                this.asc.getXSymmetry().finalizeMoments(this.spinFrame, this.spinFrameExt);
                this.vibsFractional = true;
            }
        }
        if (this.isSpinCIF && (lst = this.asc.getSymmetry().setSpinList(null)) != null) {
            this.asc.setCurrentModelInfo("spinList", lst);
            this.appendLoadNote(lst.size() + " spin operations -- see _M.spinList" + (doApplySymmetry ? " and atom.spin" : ""));
        }
    }

    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        boolean doCheckBonding;
        if (this.isMMCIF) {
            this.checkNearAtoms = false;
        }
        boolean bl = doCheckBonding = this.doCheckUnitCell && !this.isMMCIF;
        if (this.isMMCIF && this.asc.iSet >= 0) {
            int modelIndex = this.asc.iSet;
            this.asc.setCurrentModelInfo("PDB_CONECT_firstAtom_count_max", new int[]{this.asc.getAtomSetAtomIndex(modelIndex), this.asc.getAtomSetAtomCount(modelIndex), this.maxSerial});
        }
        if (this.htCellTypes != null) {
            for (Map.Entry<String, String> e : this.htCellTypes.entrySet()) {
                this.asc.setCurrentModelInfo("unitcell_" + e.getKey(), e.getValue());
                this.appendLoadNote("unitcell_" + e.getKey() + " = " + e.getValue());
            }
            this.htCellTypes = null;
        }
        if (!this.haveCellWaveVector) {
            this.modDim = 0;
        }
        if (this.doApplySymmetry && !this.iHaveFractionalCoordinates) {
            this.fractionalizeCoordinates(true);
        }
        if (!this.haveCellWaveVector) {
            this.modDim = 0;
        }
        if (this.spinOnly) {
            BS bs = this.asc.getBSAtoms(-1);
            for (int i = this.asc.getAtomSetAtomIndex(this.asc.iSet); i < this.asc.ac; ++i) {
                bs.setBitTo(i, this.asc.atoms[i].vib != null && this.asc.atoms[i].vib.lengthSquared() > 0.0f);
            }
        }
        this.applySymTrajASCR();
        if (!this.haveCellWaveVector && !this.isMolecular) {
            this.asc.setBSAtomsForSet(-1);
        }
        if (doCheckBonding && (this.bondTypes.size() > 0 || this.isMolecular)) {
            this.setBondingAndMolecules();
        }
        this.asc.setCurrentModelInfo("fileHasUnitCell", Boolean.TRUE);
        this.asc.xtalSymmetry = null;
    }

    @Override
    protected void finalizeSubclassSymmetry(boolean haveSymmetry) throws Exception {
        XtalSymmetry.FileSymmetry sym;
        XtalSymmetry.FileSymmetry fileSymmetry = sym = haveSymmetry ? this.asc.getXSymmetry().getBaseSymmetry() : null;
        if (sym != null && sym.getSpaceGroup() == null) {
            if (!this.isBinary && !this.isMMCIF) {
                this.appendLoadNote("Invalid or missing space group operations!");
            }
            sym = null;
        }
        if (this.modDim > 0 && sym != null) {
            this.addLatticeVectors();
            this.asc.setTensors();
            this.getModulationReader().setModulation(true, sym);
            this.modr.finalizeModulation();
        }
        if (sym != null && this.auditBlockCode != null && this.auditBlockCode.contains("REFRNCE")) {
            if (this.htAudit == null) {
                this.htAudit = new Hashtable();
            }
            this.htAudit.put(this.auditBlockCode, sym);
        }
        if (this.subParser != null) {
            this.subParser.finalizeSymmetry(haveSymmetry);
        }
        if (sym != null && (this.isMagCIF || this.isSpinCIF)) {
            this.finalizeMagneticMoments();
        }
    }

    private void finalizeMagneticMoments() {
        if (this.asc.xtalSymmetry == null) {
            return;
        }
        this.asc.setNoAutoBond();
        this.addJmolScript("vectors on;vectors 0.15;");
        int n = this.asc.xtalSymmetry.setMagneticMoments(false);
        this.appendLoadNote(n + " magnetic moments - use VECTORS ON/OFF or VECTOR MAX x.x or SELECT VXYZ>0");
    }

    private void processDataParameter() {
        this.bondTypes.clear();
        this.cifParser.getTokenPeeked();
        String string = this.thisDataSetName = this.key.length() < 6 ? "" : this.key.substring(5);
        if (this.thisDataSetName.length() > 0) {
            this.nextAtomSet();
        }
        if (this.debugging) {
            Logger.debug(this.key);
        }
    }

    protected void nextAtomSet() {
        this.newAtomSetLabel = (byte)-1;
        this.asc.setCurrentModelInfo("isCIF", Boolean.TRUE);
        if (this.asc.iSet >= 0) {
            if (this.isMMCIF) {
                this.setModelPDB(true);
                if (this.pdbID != null) {
                    this.asc.setCurrentModelInfo("pdbID", this.pdbID);
                }
            }
            this.asc.newAtomSet();
            if (this.isMMCIF) {
                this.setModelPDB(true);
                if (this.pdbID != null) {
                    this.asc.setCurrentModelInfo("pdbID", this.pdbID);
                }
            }
        } else {
            this.asc.setCollectionName(this.thisDataSetName);
        }
    }

    private String processChemicalInfo(String type) throws Exception {
        String field = (String)this.field;
        if (type.equals("name")) {
            this.chemicalName = field = CifReader.fullTrim(field);
            this.appendLoadNote(this.chemicalName);
            if (!field.equals("?")) {
                this.asc.setInfo("modelLoadNote", field);
            }
        } else if (type.equals("structuralFormula")) {
            this.thisStructuralFormula = field = CifReader.fullTrim(field);
        } else if (type.equals("formula")) {
            this.thisFormula = field = CifReader.fullTrim(field);
            if (this.thisFormula.length() > 1) {
                this.appendLoadNote(this.thisFormula);
            }
        }
        if (this.debugging) {
            Logger.debug(type + " = " + field);
        }
        return field;
    }

    private void processSymmetrySpaceGroupName() throws Exception {
        if (this.key.indexOf("_ssg_name") >= 0) {
            this.modulated = true;
            this.latticeType = ((String)this.field).substring(0, 1);
        } else if (this.modulated) {
            return;
        }
        String s = this.cifParser.toUnicode((String)this.field);
        this.lastSpaceGroupName = (this.key.indexOf("h-m") > 0 ? "HM:" : (this.modulated ? "SSG:" : (this.key.indexOf("spin") > 0 ? "spinSG:" : (this.key.indexOf("bns") >= 0 ? "BNS:" : (this.key.indexOf("hall") >= 0 ? "Hall:" : ""))))) + s;
        this.setSpaceGroupName(this.lastSpaceGroupName);
    }

    private void addLatticeVectors() {
        int i2;
        if (this.lstSpinLattices != null && !this.noLattice) {
            this.asc.getSymmetry().addSpinLattice(this.lstSpinLattices, this.mapSpinIdToUVW);
        }
        if (this.noLattice) {
            return;
        }
        this.lattvecs = null;
        if (this.magCenterings != null) {
            this.latticeType = "Magnetic";
            this.lattvecs = new Lst();
            for (i2 = 0; i2 < this.magCenterings.size(); ++i2) {
                String s = (String)this.magCenterings.get(i2);
                float[] f = new float[this.modDim + 4];
                if (s.indexOf("x1") >= 0) {
                    for (int j = 1; j <= this.modDim + 3; ++j) {
                        s = PT.rep(s, "x" + j, "");
                    }
                }
                String[] tokens = PT.split(PT.replaceAllCharacters(s, "xyz+", ""), ",");
                int n = 0;
                for (int j = 0; j < tokens.length; ++j) {
                    s = tokens[j].trim();
                    if (s.length() == 0 || (f[j] = PT.parseFloatFraction(s)) == 0.0f) continue;
                    ++n;
                }
                if (n < 2) continue;
                this.lattvecs.addLast(f);
            }
            this.magCenterings = null;
        } else if (this.latticeType != null && "ABCFI".indexOf(this.latticeType) >= 0) {
            this.lattvecs = new Lst();
            try {
                this.ms.addLatticeVector(this.lattvecs, this.latticeType);
            }
            catch (Exception i2) {
                // empty catch block
            }
        }
        if (this.lattvecs != null && this.lattvecs.size() > 0 && this.asc.getSymmetry().addMagLatticeVectors(this.lattvecs)) {
            this.appendLoadNote("Note! " + this.lattvecs.size() + " symmetry operators added for lattice centering " + this.latticeType);
            for (i2 = 0; i2 < this.lattvecs.size(); ++i2) {
                this.appendLoadNote(PT.toJSON(null, this.lattvecs.get(i2)));
            }
        }
        this.latticeType = null;
    }

    protected void processCellParameter() throws Exception {
        int i = 6;
        while (--i >= 0) {
            if (!this.key.equals(JmolAdapter.cellParamNames[i])) continue;
            float p = this.parseFloatField();
            if (this.rotateHexCell && i == 5 && p == 120.0f) {
                p = -1.0f;
            }
            this.setUnitCellItem(i, p);
            return;
        }
    }

    protected void processUnitCellTransformMatrix() throws Exception {
        float v = this.parseFloatField();
        if (Float.isNaN(v)) {
            return;
        }
        for (int i = 0; i < TransformFields.length; ++i) {
            if (this.key.indexOf(TransformFields[i]) < 0) continue;
            this.setUnitCellItem(6 + i, v);
            return;
        }
    }

    protected void processLoopBlock() throws Exception {
        if (this.isLoop) {
            this.skipLoopKeyword();
            this.key = (String)this.cifParser.peekToken();
            if (this.key == null) {
                return;
            }
            this.key0 = this.key;
            this.key = this.cifParser.fixKey(this.key0);
        }
        if (this.modDim > 0) {
            switch (this.getModulationReader().processLoopBlock()) {
                case 0: {
                    break;
                }
                case -1: {
                    this.skipLoop(false);
                }
                case 1: {
                    return;
                }
            }
        }
        boolean isLigand = false;
        if (this.key.startsWith(CAT_ATOM_SITE) || (isLigand = this.key.startsWith("_chem_comp_atom_"))) {
            if (!this.processAtomSiteLoopBlock(isLigand)) {
                return;
            }
            if (this.thisDataSetName.equals("global")) {
                this.thisDataSetName = this.chemicalName;
                this.asc.setCollectionName(this.thisDataSetName);
            }
            if (!this.thisDataSetName.equals(this.lastDataSetName)) {
                this.asc.setAtomSetName(this.thisDataSetName);
                this.lastDataSetName = this.thisDataSetName;
            }
            this.asc.setCurrentModelInfo("chemicalName", this.chemicalName);
            this.asc.setCurrentModelInfo("structuralFormula", this.thisStructuralFormula);
            this.asc.setCurrentModelInfo("formula", this.thisFormula);
            return;
        }
        if (this.key.startsWith(CAT_SGOP) || this.key.startsWith("_symmetry_equiv_pos") || this.key.startsWith("_symmetry_ssg_equiv")) {
            if (this.ignoreFileSymmetryOperators || this.modDim > 0 && this.key.indexOf("ssg") < 0) {
                Logger.warn("ignoring file-based symmetry operators");
                this.skipLoop(false);
            } else {
                this.processSymmetryOperationsLoopBlock();
            }
            return;
        }
        if (this.key.startsWith("_citation")) {
            this.processCitationListBlock();
            return;
        }
        if (this.key.startsWith(CAT_ATOM_TYPE)) {
            this.processAtomTypeLoopBlock();
            return;
        }
        if (this.key.startsWith("_geom_bond")) {
            this.processGeomBondLoopBlock();
            return;
        }
        if (this.key.startsWith("_jmol")) {
            this.processJmolBlock();
            return;
        }
        if (this.processSubclassLoopBlock()) {
            return;
        }
        if (this.key.equals("_propagation_vector_seq_id")) {
            this.addMore();
            return;
        }
        this.skipLoop(false);
    }

    protected boolean processSubclassLoopBlock() throws Exception {
        if (this.key.startsWith("_topol_")) {
            return this.getTopologyParser().processBlock(this.key);
        }
        return false;
    }

    private Parser getTopologyParser() {
        if (this.subParser == null) {
            this.subParser = (Parser)Interface.getInterface("org.jmol.adapter.readers.cif.TopoCifParser");
            this.subParser = this.subParser.setReader(this);
        }
        return this.subParser;
    }

    private void addMore() {
        int n = 0;
        try {
            String str;
            while ((str = (String)this.cifParser.peekToken()) != null && str.charAt(0) == '_') {
                this.cifParser.getTokenPeeked();
                ++n;
            }
            int m = 0;
            String s = "";
            while ((str = (String)this.cifParser.getNextDataToken()) != null) {
                s = s + str + (m % n == 0 ? "=" : " ");
                if (++m % n != 0) continue;
                this.addMoreUnitCellInfo(s.trim());
                s = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disableField(int fieldIndex) {
        int i = this.key2col[fieldIndex];
        if (i != -1) {
            this.col2key[i] = -1;
        }
    }

    protected boolean processAtomTypeLoopBlock() throws Exception {
        this.parseLoopParameters(atomTypeFields);
        while (this.cifParser.getData()) {
            String sym = this.getFieldString((byte)0);
            if (sym == null) continue;
            float oxno = this.parseFloatStr(this.getFieldString((byte)1));
            float radius = this.parseFloatStr(this.getFieldString((byte)2));
            if (Float.isNaN(oxno) && Float.isNaN(radius)) continue;
            if (this.htOxStates == null) {
                this.htOxStates = new Hashtable<String, float[]>();
            }
            this.htOxStates.put(sym, new float[]{oxno, radius});
        }
        return true;
    }

    private void processJmolBlock() throws Exception {
        this.htJmolNames = new Hashtable<String, String>();
        this.parseLoopParameters(jmolAtomFields);
        while (this.cifParser.getData()) {
            String jmolName = this.getFieldString((byte)1);
            String cifName = this.getFieldString((byte)2);
            if (jmolName == null || cifName == null) continue;
            this.htJmolNames.put(cifName, jmolName);
        }
    }

    private void setJmolNames() {
        int n = this.asc.ac;
        for (int i = 0; i < n; ++i) {
            Atom a = this.asc.atoms[i];
            String name = this.htJmolNames.get(a.atomName);
            if (name == null) continue;
            a.atomName = name;
        }
    }

    void parseLoopParametersFor(String key, String[] fieldNames) throws Exception {
        if (fieldNames[0].charAt(0) == '*') {
            int i = fieldNames.length;
            while (--i >= 0) {
                if (fieldNames[i].charAt(0) != '*') continue;
                fieldNames[i] = key + fieldNames[i].substring(1);
            }
        }
        this.parseLoopParameters(fieldNames);
    }

    protected int fieldProperty(int col) {
        int k;
        int n = k = col < 0 ? -1 : this.col2key[col];
        if (k == -1) {
            return -1;
        }
        this.field = this.cifParser.getColumnData(col);
        return col >= 0 && this.isFieldValid() ? this.col2key[col] : -1;
    }

    boolean processAtomSiteLoopBlock(boolean isLigand) throws Exception {
        String atomLabels;
        this.isLigand = isLigand;
        int pdbModelNo = -1;
        boolean haveCoord = true;
        boolean noPreviousReferences = this.asc.atomSymbolicMap.isEmpty();
        this.parseLoopParametersFor(CAT_ATOM_SITE, atomFields);
        if (this.key2col[55] != -1) {
            this.setFractionalCoordinates(false);
        } else if (this.key2col[6] != -1 || this.key2col[52] != -1) {
            this.setFractionalCoordinates(false);
            this.disableField(3);
            this.disableField(4);
            this.disableField(5);
            if (this.key2col[16] != -1 && !this.isMMCIF) {
                this.setIsPDB();
                this.isMMCIF = true;
            }
        } else if (this.key2col[3] != -1) {
            this.setFractionalCoordinates(true);
            this.disableField(6);
            this.disableField(7);
            this.disableField(8);
        } else if (this.key2col[20] != -1 || this.key2col[21] != -1 || this.key2col[63] != -1 || this.key2col[79] != -1) {
            haveCoord = false;
        } else {
            this.skipLoop(false);
            return false;
        }
        if (this.key2col[76] != -1 || this.key2col[80] != -1) {
            this.disableField(67);
            this.disableField(68);
            this.disableField(69);
        }
        int modelField = this.key2col[17];
        int siteMult = 0;
        String string = atomLabels = this.isMMCIF ? null : "";
        while (this.cifParser.getData()) {
            String atomName;
            Atom atom;
            block95: {
                int label;
                int fNewAtomSet;
                block103: {
                    int f0;
                    block97: {
                        block102: {
                            block101: {
                                block100: {
                                    block99: {
                                        block98: {
                                            block96: {
                                                block94: {
                                                    if (modelField >= 0) {
                                                        if ((pdbModelNo = this.checkPDBModelField(modelField, pdbModelNo)) < 0) break;
                                                        if (this.skipping) continue;
                                                    }
                                                    atom = null;
                                                    atomName = null;
                                                    if (!this.isMMCIF) break block94;
                                                    if (haveCoord) {
                                                        atom = new Atom();
                                                    } else if (this.fieldProperty(this.key2col[20]) == -1 && this.fieldProperty(this.key2col[21]) == -1 && this.fieldProperty(this.key2col[63]) == -1 || (atom = this.asc.getAtomFromName((String)this.field)) == null) {
                                                        continue;
                                                    }
                                                    break block95;
                                                }
                                                fNewAtomSet = -1;
                                                f0 = -1;
                                                label = -1;
                                                f0 = fNewAtomSet = this.fieldProperty(this.key2col[1]);
                                                if (fNewAtomSet == -1) break block96;
                                                label = 1;
                                                if (1 != -1) break block97;
                                            }
                                            if ((fNewAtomSet = this.fieldProperty(this.key2col[49])) == -1) break block98;
                                            label = 49;
                                            if (49 != -1) break block97;
                                        }
                                        if ((fNewAtomSet = this.fieldProperty(this.key2col[73])) == -1) break block99;
                                        label = 73;
                                        if (73 != -1) break block97;
                                    }
                                    f0 = fNewAtomSet = this.fieldProperty(this.key2col[20]);
                                    if (fNewAtomSet == -1) break block100;
                                    label = 20;
                                    if (20 != -1) break block97;
                                }
                                if ((fNewAtomSet = this.fieldProperty(this.key2col[21])) == -1) break block101;
                                label = 21;
                                if (21 != -1) break block97;
                            }
                            f0 = fNewAtomSet = this.fieldProperty(this.key2col[63]);
                            if (fNewAtomSet == -1) break block102;
                            label = 63;
                            if (63 != -1) break block97;
                        }
                        f0 = fNewAtomSet = this.fieldProperty(this.key2col[79]);
                        if (fNewAtomSet == -1) break block103;
                        label = 79;
                        if (79 == -1) break block103;
                    }
                    if (f0 != -1 && atomLabels != null) {
                        atom = this.asc.getAtomFromName((String)this.field);
                        if (this.addAtomLabelNumbers || atom != null) {
                            String key = ";" + this.field + ";";
                            if (noPreviousReferences) {
                                atomLabels = atomLabels + key;
                            }
                            if (atomLabels.indexOf(key) < 0) {
                                atomLabels = atomLabels + key;
                            } else {
                                atomName = (String)this.field + (this.asc.ac + 1);
                                this.field = atomName;
                                System.err.println("CifReader found duplicate atom_site_label! New label is " + this.field);
                                atom = null;
                            }
                        }
                    }
                }
                String field = (String)this.field;
                if (atom == null) {
                    atom = new Atom();
                    if (fNewAtomSet != -1) {
                        if (this.asc.iSet < 0 && this.newAtomSetLabel == -1) {
                            this.nextAtomSet();
                            this.asc.newAtomSet();
                            this.newAtomSetLabel = (byte)label;
                        }
                        this.asc.atomSymbolicMap.put(field, atom);
                    }
                }
            }
            String componentId = null;
            String id = null;
            String authAtom = null;
            String authComp = null;
            int authSeq = Integer.MIN_VALUE;
            String authAsym = null;
            String wyckoff = null;
            boolean haveAuth = false;
            int seqID = 0;
            int n = this.cifParser.getColumnCount();
            block46: for (int i = 0; i < n; ++i) {
                int tok = this.fieldProperty(i);
                String field = (String)this.field;
                block0 : switch (tok) {
                    case -1: {
                        continue block46;
                    }
                    case 70: {
                        id = field;
                        continue block46;
                    }
                    case 0: 
                    case 50: {
                        String elementSymbol;
                        if (field.length() < 2) {
                            elementSymbol = field;
                        } else {
                            char ch1 = Character.toLowerCase(field.charAt(1));
                            if (Atom.isValidSym2(this.firstChar, ch1)) {
                                elementSymbol = "" + this.firstChar + ch1;
                            } else {
                                elementSymbol = "" + this.firstChar;
                                if (!this.haveHAtoms && this.firstChar == 'H') {
                                    this.haveHAtoms = true;
                                }
                            }
                        }
                        atom.elementSymbol = elementSymbol;
                        atom.typeSymbol = field;
                        continue block46;
                    }
                    case 1: 
                    case 49: 
                    case 73: {
                        atom.atomName = atomName == null ? field : atomName;
                        continue block46;
                    }
                    case 2: {
                        haveAuth = true;
                        authAtom = field;
                        continue block46;
                    }
                    case 48: 
                    case 72: {
                        atom.group3 = field;
                        continue block46;
                    }
                    case 11: {
                        authComp = field;
                        haveAuth = true;
                        continue block46;
                    }
                    case 59: {
                        componentId = field;
                        continue block46;
                    }
                    case 12: {
                        authAsym = field;
                        haveAuth = true;
                        continue block46;
                    }
                    case 71: {
                        atom.sequenceNumber = seqID = this.parseIntField();
                        continue block46;
                    }
                    case 74: {
                        if (!this.allowWyckoff) continue block46;
                        wyckoff = field;
                        continue block46;
                    }
                    case 13: {
                        haveAuth = true;
                        authSeq = this.parseIntField();
                        continue block46;
                    }
                    case 55: {
                        float x = this.parseFloatField();
                        if (!this.readIdeal || Float.isNaN(x)) continue block46;
                        atom.x = x;
                        continue block46;
                    }
                    case 56: {
                        float y = this.parseFloatField();
                        if (!this.readIdeal || Float.isNaN(y)) continue block46;
                        atom.y = y;
                        continue block46;
                    }
                    case 57: {
                        float z = this.parseFloatField();
                        if (!this.readIdeal || Float.isNaN(z)) continue block46;
                        atom.z = z;
                        continue block46;
                    }
                    case 3: {
                        atom.x = this.parsePrecision(field);
                        continue block46;
                    }
                    case 6: 
                    case 52: {
                        atom.x = this.parseCartesianField();
                        continue block46;
                    }
                    case 4: {
                        atom.y = this.parsePrecision(field);
                        continue block46;
                    }
                    case 7: 
                    case 53: {
                        atom.y = this.parseCartesianField();
                        continue block46;
                    }
                    case 5: {
                        atom.z = this.parsePrecision(field);
                        continue block46;
                    }
                    case 8: 
                    case 54: {
                        atom.z = this.parseCartesianField();
                        continue block46;
                    }
                    case 51: {
                        atom.formalCharge = this.parseIntStr(field);
                        continue block46;
                    }
                    case 9: {
                        float floatOccupancy = this.parseFloatField();
                        if (Float.isNaN(floatOccupancy)) continue block46;
                        atom.foccupancy = floatOccupancy;
                        continue block46;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloatField() * (this.isMMCIF ? 1.0f : 100.0f);
                        continue block46;
                    }
                    case 14: {
                        atom.insertionCode = this.firstChar;
                        continue block46;
                    }
                    case 15: 
                    case 60: {
                        atom.altLoc = this.firstChar;
                        continue block46;
                    }
                    case 58: {
                        this.disorderAssembly = field;
                        continue block46;
                    }
                    case 19: {
                        if (!this.isMMCIF) {
                            atom.part = PT.parseInt(field);
                        }
                        atom.altLoc = atom.part < 0 ? field.charAt(1) : this.firstChar;
                        continue block46;
                    }
                    case 16: {
                        if (!"HETATM".equals(field)) continue block46;
                        atom.isHetero = true;
                        continue block46;
                    }
                    case 18: {
                        if (!"dum".equals(field)) continue block46;
                        atom.x = Float.NaN;
                        continue block46;
                    }
                    case 61: 
                    case 75: {
                        siteMult = this.parseIntField();
                        continue block46;
                    }
                    case 47: 
                    case 62: {
                        int j;
                        if (!field.equalsIgnoreCase("Uiso") || (j = this.key2col[34]) == -1) continue block46;
                        this.asc.setU(atom, 7, this.getFloatColumnData(j));
                        continue block46;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        this.asc.setU(atom, (this.col2key[i] - 22) % 6, this.parseFloatField());
                        continue block46;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        this.asc.setU(atom, 6, 4.0f);
                        this.asc.setU(atom, (this.col2key[i] - 35) % 6, this.parseFloatField());
                        continue block46;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        this.asc.setU(atom, 6, 0.0f);
                        this.asc.setU(atom, (this.col2key[i] - 41) % 6, this.parseFloatField());
                        continue block46;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: {
                        this.haveMagneticMoments = true;
                        Vibration pt = (Vibration)atom.vib;
                        if (pt == null) {
                            pt = new Vibration().setType(-2);
                            atom.vib = pt;
                        }
                        float v = this.parseFloatField();
                        switch (tok) {
                            case 84: {
                                pt.magMoment = v;
                                break block0;
                            }
                            case 83: {
                                pt.symmform = field;
                                break block0;
                            }
                            case 64: 
                            case 67: 
                            case 76: 
                            case 80: {
                                pt.x = v;
                                this.appendLoadNote("magnetic moment: " + this.line);
                                break block0;
                            }
                            case 65: 
                            case 68: 
                            case 77: 
                            case 81: {
                                pt.y = v;
                                break block0;
                            }
                            case 66: 
                            case 69: 
                            case 78: 
                            case 82: {
                                pt.z = v;
                                if (pt.length() == 0.0f && this.modDim == 0) {
                                    atom.vib = null;
                                    break block0;
                                }
                                pt.isFractional = true;
                            }
                        }
                    }
                }
            }
            if (!haveCoord) continue;
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            if (siteMult > 0 && wyckoff != null && wyckoff.length() > 0) {
                seqID = (siteMult << 16) + wyckoff.charAt(0);
            }
            String strChain = componentId;
            if (haveAuth) {
                if (authAtom != null) {
                    atom.atomName = authAtom;
                }
                if (authComp != null) {
                    atom.group3 = authComp;
                }
                if (authSeq != Integer.MIN_VALUE) {
                    atom.sequenceNumber = authSeq;
                }
                if (authAsym != null && this.useAuthorChainID) {
                    strChain = authAsym;
                }
            }
            if (strChain != null) {
                this.setChainID(atom, strChain);
            }
            if (this.maxSerial != Integer.MIN_VALUE) {
                this.maxSerial = Math.max(this.maxSerial, atom.sequenceNumber);
            }
            if (!this.addCifAtom(atom, id, componentId, strChain)) continue;
            if ((id != null || wyckoff != null) && seqID > 0) {
                V3 pt = atom.vib;
                if (pt == null) {
                    pt = this.asc.addVibrationVector(atom.index, 0.0f, Float.NaN, 1.0947133E9f);
                }
                pt.x = seqID;
            }
            if (this.modDim <= 0 || siteMult == 0) continue;
            atom.vib = V3.new3(siteMult, 0.0f, Float.NaN);
        }
        this.asc.setCurrentModelInfo("isCIF", Boolean.TRUE);
        if (this.isMMCIF) {
            this.setModelPDB(true);
        }
        if (this.isMMCIF && this.skipping) {
            this.skipping = false;
        }
        return true;
    }

    protected float parseCartesianField() {
        return this.parseFloatField();
    }

    protected boolean addCifAtom(Atom atom, String id, String componentId, String strChain) {
        if (atom.elementSymbol == null && atom.atomName != null) {
            atom.getElementSymbol();
        }
        if (!this.filterCIFAtom(atom, componentId)) {
            return false;
        }
        this.setAtomCoord(atom);
        if (this.isMMCIF && !this.processSubclassAtom(atom, componentId, strChain)) {
            return false;
        }
        if (this.asc.iSet < 0) {
            this.nextAtomSet();
        }
        this.asc.addAtomWithMappedName(atom);
        if (id != null) {
            this.asc.atomSymbolicMap.put(id, atom);
        }
        ++this.ac;
        return true;
    }

    protected int checkPDBModelField(int modelField, int currentModelNo) throws Exception {
        return 0;
    }

    protected boolean processSubclassAtom(Atom atom, String assemblyId, String strChain) {
        return true;
    }

    protected boolean filterCIFAtom(Atom atom, String componentId) {
        if (!this.filterAtom(atom, -1)) {
            return false;
        }
        if (this.filterAssembly && this.filterReject(this.filter, "$", componentId)) {
            return false;
        }
        if (this.configurationPtr > 0) {
            if (!this.disorderAssembly.equals(this.lastDisorderAssembly)) {
                this.lastDisorderAssembly = this.disorderAssembly;
                this.lastAltLoc = '\u0000';
                this.conformationIndex = this.configurationPtr;
            }
            if (atom.altLoc != '\u0000') {
                if (this.conformationIndex >= 0 && atom.altLoc != this.lastAltLoc) {
                    this.lastAltLoc = atom.altLoc;
                    --this.conformationIndex;
                }
                if (this.conformationIndex != 0) {
                    Logger.info("ignoring " + atom.atomName);
                    return false;
                }
            }
        }
        return true;
    }

    protected void processCitationListBlock() throws Exception {
        this.parseLoopParameters(citationFields);
        while (this.cifParser.getData()) {
            String title = this.getFieldString((byte)0);
            if (this.isNull(title)) continue;
            this.appendLoadNote("TITLE: " + this.cifParser.toUnicode(title));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processSymmetryOperationsLoopBlock() throws Exception {
        this.parseLoopParametersFor(CAT_SGOP, symmetryOperationsFields);
        this.symops = new Lst();
        int n = symmetryOperationsFields.length;
        while (--n >= 0 && this.key2col[n] == -1) {
        }
        if (n < 0) {
            Logger.warn("required _space_group_symop key not found");
            this.skipLoop(false);
            return;
        }
        n = 0;
        boolean isMag = false;
        String sxyz = null;
        String suvw = null;
        String suvwMapped = null;
        String suvwId = null;
        while (true) {
            int timeRev;
            int nn;
            String ouvw;
            String oxyz;
            boolean ssgop;
            if (this.cifParser.getData()) {
                ssgop = false;
                oxyz = null;
                ouvw = null;
                nn = this.cifParser.getColumnCount();
                int n2 = this.fieldProperty(this.key2col[7]) == -1 && this.fieldProperty(this.key2col[8]) == -1 && this.fieldProperty(this.key2col[6]) == -1 ? 0 : (timeRev = ((String)this.field).equals("-1") ? -1 : 1);
                if (timeRev != 0) {
                    this.isMagCIF = true;
                }
            } else {
                if (this.ms != null && !isMag) {
                    this.addLatticeVectors();
                }
                return;
            }
            block19: for (int i = 0; i < nn; ++i) {
                int tok = this.fieldProperty(i);
                String field = (String)this.field;
                switch (tok) {
                    case 5: {
                        if (field.indexOf(126) >= 0) {
                            field = PT.rep(field, "~", "");
                        }
                    }
                    case 2: 
                    case 3: {
                        this.modulated = true;
                        ssgop = true;
                    }
                    case 0: 
                    case 1: 
                    case 4: 
                    case 15: 
                    case 16: 
                    case 17: {
                        if (!this.allowRotations && timeRev == 0 && ++n != 1 || this.modulated && !ssgop) continue block19;
                        switch (tok) {
                            case 1: 
                            case 3: {
                                this.isMagCIF = true;
                                isMag = true;
                                timeRev = this.getTimeReversal(field);
                                if (timeRev == 0) break;
                                field = (String)this.field;
                                break;
                            }
                            case 15: {
                                this.isSpinCIF = true;
                                timeRev = this.getTimeReversal(field);
                                if (timeRev != 0) {
                                    field = (String)this.field;
                                }
                                oxyz = field;
                                if (ouvw == null) continue block19;
                            }
                            case 17: {
                                if (ouvw == null) {
                                    this.haveSpinReferences = true;
                                    ouvw = "u" + field;
                                }
                            }
                            case 16: {
                                if (ouvw == null) {
                                    ouvw = field;
                                }
                                if (oxyz == null) continue block19;
                                ouvw = this.parseUvwMath(ouvw);
                                field = oxyz + "(" + ouvw + ")";
                                timeRev = 0;
                            }
                        }
                        if (timeRev != 0) {
                            field = field + "," + (timeRev == 1 ? "m" : "-m");
                        }
                        field = field.replace(';', ' ');
                        this.symops.addLast(field);
                        this.setSymmetryOperator(field);
                        if (!this.modulated || this.modDim != 0 || this.modr == null) continue block19;
                        this.modDim = this.modr.modDim;
                        continue block19;
                    }
                    case 18: {
                        suvwId = "u" + field;
                        if (suvwMapped == null) continue block19;
                        field = suvwMapped;
                    }
                    case 19: {
                        suvwMapped = field;
                        if (suvwId == null) continue block19;
                        if (this.mapSpinIdToUVW == null) {
                            this.mapSpinIdToUVW = new Hashtable<String, String>();
                        }
                        this.mapSpinIdToUVW.put(suvwId, suvwMapped);
                        continue block19;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        this.isMagCIF = true;
                        isMag = true;
                        if (this.magCenterings == null) {
                            this.magCenterings = new Lst();
                        }
                        this.magCenterings.addLast(field);
                        continue block19;
                    }
                    case 12: {
                        timeRev = this.getTimeReversal(field);
                        sxyz = (String)this.field;
                        continue block19;
                    }
                    case 14: {
                        field = "u" + field;
                        this.haveSpinReferences = true;
                    }
                    case 13: {
                        suvw = field;
                        continue block19;
                    }
                }
            }
            if (sxyz == null) continue;
            if (suvw != null) {
                this.isSpinCIF = true;
                isMag = true;
                if (this.lstSpinLattices == null) {
                    this.lstSpinLattices = new Lst();
                }
                suvw = this.parseUvwMath(suvw);
                this.lstSpinLattices.addLast(sxyz + "(" + suvw + ")");
                suvwId = null;
                suvwMapped = null;
                suvw = null;
            }
            sxyz = null;
        }
    }

    private String parseUvwMath(String suvw) {
        return SimpleUnitCell.parseSimpleMath(this.vwr, suvw);
    }

    private int getTimeReversal(String field) {
        int tr;
        int n = field.endsWith(",+1") || field.endsWith(",1") ? 1 : (tr = field.endsWith(",-1") ? -1 : 0);
        if (tr != 0) {
            this.field = field.substring(0, field.lastIndexOf(44));
        }
        return tr;
    }

    public int getBondOrder(String field) {
        switch (field.toUpperCase().charAt(0)) {
            default: {
                Logger.warn("unknown CIF bond order: " + field);
            }
            case '\u0000': 
            case 'S': {
                return 1;
            }
            case 'D': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'Q': {
                return 4;
            }
            case 'A': 
        }
        this.haveAromatic = true;
        return 515;
    }

    private void processGeomBondLoopBlock() throws Exception {
        boolean ok;
        boolean bl = ok = !this.modulated && (this.isMolecular || !this.doApplySymmetry && !this.ignoreGeomBonds && (this.stateScriptVersionInt < 130304 || this.stateScriptVersionInt >= 140403));
        if (ok) {
            this.parseLoopParameters(geomBondFields);
            ok = this.checkAllFieldsPresent(geomBondFields, 2, true);
        }
        if (!ok) {
            this.skipLoop(false);
            return;
        }
        int bondCount = 0;
        while (this.cifParser.getData()) {
            String name1 = this.getFieldString((byte)0);
            String name2 = this.getFieldString((byte)1);
            int order = this.getBondOrder(this.getFieldString((byte)3));
            String sdist = this.getFieldString((byte)2);
            float distance = this.parseFloatStr(sdist);
            if (distance == 0.0f || Float.isNaN(distance)) {
                if (this.iHaveFractionalCoordinates) continue;
                Atom a = this.getAtomFromNameCheckCase(name1);
                Atom b = this.getAtomFromNameCheckCase(name2);
                if (a == null || b == null) {
                    System.err.println("ATOM_SITE atom for name " + (a != null ? name2 : (b != null ? name1 : name1 + " and " + name2)) + " not found");
                    continue;
                }
                this.asc.addNewBondWithOrder(a.index, b.index, order);
                continue;
            }
            float dx = this.getStandardDeviation(sdist);
            ++bondCount;
            this.bondTypes.addLast(new Object[]{name1, name2, Float.valueOf(distance), Float.valueOf(dx), order});
        }
        if (bondCount > 0) {
            Logger.info(bondCount + " bonds read");
            if (!this.doApplySymmetry) {
                this.isMolecular = true;
                this.forceSymmetry(false);
            }
        }
    }

    private float getStandardDeviation(String sdist) {
        int pt = sdist.indexOf(40);
        if (pt >= 0) {
            char[] data = sdist.toCharArray();
            String sdx = sdist.substring(pt + 1, data.length - 1);
            int n = sdx.length();
            int j = pt;
            while (--j >= 0 && (data[j] != '.' || --j >= 0)) {
                data[j] = --n < 0 ? 48 : data[pt + 1 + n];
            }
            float dx = this.parseFloatStr(String.valueOf(data));
            if (!Float.isNaN(dx)) {
                return dx;
            }
        }
        Logger.info("CifReader error reading uncertainty for " + sdist + " (set to 0.015) on line " + this.line);
        return 0.015f;
    }

    private Atom getAtomFromNameCheckCase(String name) {
        Atom a = this.asc.getAtomFromName(name);
        if (a == null) {
            if (!this.asc.atomMapAnyCase) {
                this.asc.setAtomMapAnyCase();
            }
            a = this.asc.getAtomFromName(name.toUpperCase());
        }
        return a;
    }

    private void setBondingAndMolecules() {
        int i;
        this.atoms = this.asc.atoms;
        this.firstAtom = this.asc.getLastAtomSetAtomIndex();
        int nat = this.asc.getLastAtomSetAtomCount();
        this.ac = this.firstAtom + nat;
        Logger.info("CIF creating molecule for " + nat + " atoms " + (this.bondTypes.size() > 0 ? " using GEOM_BOND records" : ""));
        this.bsSets = new BS[nat];
        this.symmetry = this.asc.getSymmetry();
        for (i = this.firstAtom; i < this.ac; ++i) {
            int ipt = this.asc.getAtomFromName((String)this.atoms[i].atomName).index - this.firstAtom;
            if (ipt < 0) continue;
            if (this.bsSets[ipt] == null) {
                this.bsSets[ipt] = new BS();
            }
            this.bsSets[ipt].set(i - this.firstAtom);
        }
        if (this.isMolecular) {
            this.atomRadius = new float[this.ac];
            for (i = this.firstAtom; i < this.ac; ++i) {
                int charge;
                int elemnoWithIsotope = JmolAdapter.getElementNumber(this.atoms[i].getElementSymbol());
                this.atoms[i].elementNumber = (short)elemnoWithIsotope;
                int n = charge = this.atoms[i].formalCharge == Integer.MIN_VALUE ? 0 : this.atoms[i].formalCharge;
                if (elemnoWithIsotope <= 0) continue;
                this.atomRadius[i] = JmolAdapter.getBondingRadius(elemnoWithIsotope, charge);
            }
            this.bsConnected = new BS[this.ac];
            for (i = this.firstAtom; i < this.ac; ++i) {
                this.bsConnected[i] = new BS();
            }
            this.bsMolecule = new BS();
            this.bsExclude = new BS();
        }
        boolean isFirst = true;
        this.bsBondDuplicates = new BS();
        while (this.createBonds(isFirst)) {
            isFirst = false;
        }
        if (this.isMolecular && this.iHaveFractionalCoordinates && !this.bsMolecule.isEmpty()) {
            BS bs = this.asc.getBSAtoms(this.asc.bsAtoms == null ? this.firstAtom : 0);
            bs.clearBits(this.firstAtom, this.ac);
            bs.or(this.bsMolecule);
            bs.andNot(this.bsExclude);
            for (int i2 = this.firstAtom; i2 < this.ac; ++i2) {
                if (bs.get(i2)) {
                    this.symmetry.toCartesian(this.atoms[i2], true);
                    continue;
                }
                if (!this.debugging) continue;
                Logger.debug(this.molecularType + " removing " + i2 + " " + this.atoms[i2].atomName + " " + this.atoms[i2]);
            }
            this.asc.setCurrentModelInfo("unitCellParams", null);
            if (this.nMolecular++ == this.asc.iSet) {
                this.asc.clearGlobalBoolean(0);
                this.asc.clearGlobalBoolean(1);
                this.asc.clearGlobalBoolean(2);
            }
        }
        if (this.bondTypes.size() > 0) {
            this.asc.setCurrentModelInfo("hasBonds", Boolean.TRUE);
        }
        this.bondTypes.clear();
        this.atomRadius = null;
        this.bsSets = null;
        this.bsConnected = null;
        this.bsMolecule = null;
        this.bsExclude = null;
    }

    private void fixAtomForBonding(P3 pt, int i) {
        pt.setT(this.atoms[i]);
        if (this.iHaveFractionalCoordinates) {
            this.symmetry.toCartesian(pt, true);
        }
    }

    private boolean createBonds(boolean doInit) {
        String list = "";
        boolean haveH = false;
        int i = this.bondTypes.size();
        while (--i >= 0) {
            if (this.bsBondDuplicates.get(i)) continue;
            Object[] o = (Object[])this.bondTypes.get(i);
            float distance = ((Float)o[2]).floatValue();
            float dx = ((Float)o[3]).floatValue();
            int order = (Integer)o[4];
            Atom a1 = this.getAtomFromNameCheckCase((String)o[0]);
            Atom a2 = this.getAtomFromNameCheckCase((String)o[1]);
            if (a1 == null || a2 == null) {
                System.err.println("CifReader checking GEOM_BOND " + o[0] + "-" + o[1] + " found " + a1 + " " + a2);
                continue;
            }
            if (Float.isNaN(a1.x) || Float.isNaN(a2.x)) {
                System.err.println("CifReader checking GEOM_BOND " + o[0] + "-" + o[1] + " found x coord NaN");
                continue;
            }
            int iatom1 = a1.index;
            int iatom2 = a2.index;
            if (doInit) {
                String key = ";" + iatom1 + ";" + iatom2 + ";" + distance;
                if (list.indexOf(key) >= 0) {
                    this.bsBondDuplicates.set(i);
                    continue;
                }
                list = list + key;
            }
            BS bs1 = this.bsSets[iatom1 - this.firstAtom];
            BS bs2 = this.bsSets[iatom2 - this.firstAtom];
            if (bs1 == null || bs2 == null) continue;
            if (this.atoms[iatom1].elementNumber == 1 || this.atoms[iatom2].elementNumber == 1) {
                haveH = true;
            }
            int j = bs1.nextSetBit(0);
            while (j >= 0) {
                int k = bs2.nextSetBit(0);
                while (k >= 0) {
                    if (!(this.isMolecular && this.bsConnected[j + this.firstAtom].get(k) || !this.checkBond(this.atoms[j + this.firstAtom], this.atoms[k + this.firstAtom], distance, dx))) {
                        this.addNewBond(j + this.firstAtom, k + this.firstAtom, order);
                    }
                    k = bs2.nextSetBit(k + 1);
                }
                j = bs1.nextSetBit(j + 1);
            }
        }
        if (!this.iHaveFractionalCoordinates) {
            return false;
        }
        if (this.bondTypes.size() > 0 && !haveH) {
            for (i = this.firstAtom; i < this.ac; ++i) {
                if (this.atoms[i].elementNumber != 1) continue;
                boolean checkAltLoc = this.atoms[i].altLoc != '\u0000';
                for (int k = this.firstAtom; k < this.ac; ++k) {
                    if (k == i || this.atoms[k].elementNumber == 1 || checkAltLoc && this.atoms[k].altLoc != '\u0000' && this.atoms[k].altLoc != this.atoms[i].altLoc || this.bsConnected[i].get(k) || !this.checkBond(this.atoms[i], this.atoms[k], 1.1f, 0.0f)) continue;
                    this.addNewBond(i, k, 1);
                }
            }
        }
        if (!this.isMolecular) {
            return false;
        }
        if (doInit) {
            for (i = this.firstAtom; i < this.ac; ++i) {
                if (this.atoms[i].atomSite + this.firstAtom != i || this.bsMolecule.get(i)) continue;
                this.setBs(this.atoms, i, this.bsConnected, this.bsMolecule);
            }
        }
        float bondTolerance = this.vwr.getFloat(0x22000004);
        BS bsBranch = new BS();
        P3 cart1 = new P3();
        P3 cart2 = new P3();
        int nFactor = 2;
        for (int i2 = this.firstAtom; i2 < this.ac; ++i2) {
            if (this.bsMolecule.get(i2) || this.bsExclude.get(i2)) continue;
            int j = this.bsMolecule.nextSetBit(0);
            while (j >= 0) {
                if (this.checkBondDistance(this.atoms[j], this.atoms[i2], this.atomRadius[i2] + this.atomRadius[j] + bondTolerance, 0.0f, nFactor, nFactor, nFactor, this.ptOffset)) {
                    this.setBs(this.atoms, i2, this.bsConnected, bsBranch);
                    int k = bsBranch.nextSetBit(0);
                    while (k >= 0) {
                        this.atoms[k].add(this.ptOffset);
                        this.fixAtomForBonding(cart1, k);
                        BS bs = this.bsSets[this.asc.getAtomIndex(this.atoms[k].atomName) - this.firstAtom];
                        if (bs != null) {
                            int ii = bs.nextSetBit(0);
                            while (ii >= 0) {
                                if (ii + this.firstAtom != k) {
                                    this.fixAtomForBonding(cart2, ii + this.firstAtom);
                                    if (cart2.distance(cart1) < 0.1f) {
                                        this.bsExclude.set(k);
                                        break;
                                    }
                                }
                                ii = bs.nextSetBit(ii + 1);
                            }
                        }
                        this.bsMolecule.set(k);
                        k = bsBranch.nextSetBit(k + 1);
                    }
                    return true;
                }
                j = this.bsMolecule.nextSetBit(j + 1);
            }
        }
        return false;
    }

    private boolean checkBond(Atom a, Atom b, float distance, float dx) {
        boolean ret;
        if (this.iHaveFractionalCoordinates) {
            ret = this.checkBondDistance(a, b, distance, dx, 0, 0, 0, this.ptOffset);
        } else {
            double d = a.distance(b);
            ret = dx > 0.0f ? Math.abs(d - (double)distance) <= (double)dx : d <= (double)distance && d > 0.1;
        }
        return ret;
    }

    private boolean checkBondDistance(P3 f1, P3 f2, float distance, float slop, int iRange, int jRange, int kRange, P3 ptOffset) {
        P3 p1 = P3.newP(f1);
        this.symmetry.toCartesian(p1, true);
        for (int i = -iRange; i <= iRange; ++i) {
            for (int j = -jRange; j <= jRange; ++j) {
                for (int k = -kRange; k <= kRange; ++k) {
                    ptOffset.set(f2.x + (float)i, f2.y + (float)j, f2.z + (float)k);
                    this.symmetry.toCartesian(ptOffset, true);
                    double d = p1.distance(ptOffset);
                    if (!(slop > 0.0f ? Math.abs(d - (double)distance) <= (double)slop : d <= (double)distance && d > 0.1)) continue;
                    ptOffset.set(i, j, k);
                    return true;
                }
            }
        }
        return false;
    }

    private void addNewBond(int i, int j, int order) {
        this.asc.addNewBondWithOrder(i, j, order);
        if (!this.isMolecular) {
            return;
        }
        this.bsConnected[i].set(j);
        this.bsConnected[j].set(i);
    }

    private void setBs(Atom[] atoms, int iatom, BS[] bsBonds, BS bs) {
        BS bsBond = bsBonds[iatom];
        bs.set(iatom);
        int i = bsBond.nextSetBit(0);
        while (i >= 0) {
            if (!bs.get(i)) {
                this.setBs(atoms, i, bsBonds, bs);
            }
            i = bsBond.nextSetBit(i + 1);
        }
    }

    protected boolean checkSubclassSymmetry() {
        return this.doCheckUnitCell;
    }

    protected boolean checkAllFieldsPresent(String[] keys, int lastKey, boolean critical) {
        int i;
        int n = i = lastKey < 0 ? keys.length : lastKey;
        while (--i >= 0) {
            if (this.key2col[i] != -1) continue;
            if (critical) {
                Logger.warn("CIF reader missing property: " + keys[i]);
            }
            return false;
        }
        return true;
    }

    protected boolean isNull(String key) {
        return key.equals("\u0000");
    }

    protected void skipLoop(boolean doReport) throws Exception {
        if (this.isLoop) {
            this.cifParser.skipLoop(doReport);
        }
    }

    public static String fullTrim(Object s) {
        String str = (String)s;
        int pt0 = -1;
        int pt1 = str.length();
        while (++pt0 < pt1 && PT.isWhitespace(str.charAt(pt0))) {
        }
        while (--pt1 > pt0 && PT.isWhitespace(str.charAt(pt1))) {
        }
        return str.substring(pt0, pt1 + 1);
    }

    protected boolean isFieldValid() {
        return ((String)this.field).length() > 0 && (this.firstChar = ((String)this.field).charAt(0)) != '\u0000';
    }

    protected int parseIntField() {
        return this.parseIntStr((String)this.field);
    }

    protected float parseFloatField() {
        return this.parseFloatStr((String)this.field);
    }

    private boolean getData() throws Exception {
        this.key = (String)this.cifParser.getTokenPeeked();
        if (!this.continueWith(this.key)) {
            return false;
        }
        this.field = this.skipKey(this.key) ? this.cifParser.skipNextToken() : this.cifParser.getNextToken();
        if (this.field == null) {
            Logger.warn("CIF ERROR ? end of file; data missing: " + this.key);
            return false;
        }
        String field = (String)this.field;
        return field.length() == 0 || field.charAt(0) != '\u0000';
    }

    protected void parseLoopParameters(String[] fieldNames) throws Exception {
        this.cifParser.parseDataBlockParameters(fieldNames, this.isLoop ? null : this.key0, (String)this.field, this.key2col, this.col2key);
    }

    protected String getFieldString(byte type) {
        int i = this.key2col[type];
        return i <= -1 ? "\u0000" : (String)this.cifParser.getColumnData(i);
    }

    protected void skipLoopKeyword() {
        this.cifParser.getTokenPeeked();
    }

    protected boolean isLoopKey() {
        return this.key.startsWith("loop_");
    }

    protected float getFloatColumnData(int i) {
        return this.parseFloatStr((String)this.cifParser.getColumnData(i));
    }

    static interface Parser {
        public Parser setReader(CifReader var1);

        public boolean processBlock(String var1) throws Exception;

        public boolean finalizeReader() throws Exception;

        public void finalizeSymmetry(boolean var1) throws Exception;

        public void ProcessRecord(String var1, String var2) throws Exception;
    }
}

