/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.bundletool.com.android.ddmlib.IDevice;

public final class AdbDevice {
    private static Pattern SERIAL_PATTERN = Pattern.compile("([\\S&&[^\\(]]\\S*|\\(.*\\))\\s+(\\S+)\\s*.*$");
    private String serial;
    private IDevice.DeviceState state;

    public AdbDevice(String serial, IDevice.DeviceState state) {
        this.serial = serial;
        this.state = state;
    }

    public String getSerial() {
        return this.serial;
    }

    public IDevice.DeviceState getState() {
        return this.state;
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        AdbDevice device = (AdbDevice)o15;
        return Objects.equals(this.serial, device.serial) && this.state == device.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.serial, this.state});
    }

    public static AdbDevice parseAdbLine(String line) {
        Matcher matcher = SERIAL_PATTERN.matcher(line);
        if (matcher.matches()) {
            String serial = matcher.group(1);
            String stateName = matcher.group(2);
            if (serial != null && serial.startsWith("(")) {
                serial = null;
            }
            return new AdbDevice(serial, IDevice.DeviceState.getState(stateName));
        }
        return null;
    }
}

